/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.tree;

import com.google.common.base.Objects;
import com.google.common.collect.BiMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DataType;
import org.dmg.pmml.tree.Node;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EntityClassification;
import org.jpmml.evaluator.HasConfidence;
import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.Values;

public class NodeScoreDistribution
extends EntityClassification<Node>
implements HasProbability,
HasConfidence {
    private Map<String, Double> confidences = null;

    protected NodeScoreDistribution(BiMap<String, Node> entityRegistry, Node node) {
        super(Classification.Type.PROBABILITY, entityRegistry);
        this.setEntity(node);
    }

    @Override
    protected boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public void computeResult(DataType dataType) {
        Node node = (Node)this.getEntity();
        if (node.hasScore()) {
            Object result = TypeUtil.parseOrCast(dataType, node.getScore());
            super.setResult(result);
            return;
        }
        super.computeResult(dataType);
    }

    @Override
    public Set<String> getCategoryValues() {
        if (this.isEmpty()) {
            Node node = (Node)this.getEntity();
            return Collections.singleton(node.getScore());
        }
        return this.keySet();
    }

    @Override
    public Double getProbability(String value) {
        if (this.isEmpty()) {
            Node node = (Node)this.getEntity();
            if (value != null && value.equals(node.getScore())) {
                return Values.DOUBLE_ONE;
            }
        }
        return this.get(value);
    }

    @Override
    public Double getConfidence(String value) {
        if (this.confidences == null) {
            return null;
        }
        return this.confidences.get(value);
    }

    void putConfidence(String value, Double confidence) {
        if (this.confidences == null) {
            this.confidences = new LinkedHashMap<String, Double>();
        }
        this.confidences.put(value, confidence);
    }

    @Override
    protected Objects.ToStringHelper toStringHelper() {
        Objects.ToStringHelper helper = super.toStringHelper().add(Classification.Type.CONFIDENCE.entryKey(), this.confidences != null ? this.confidences.entrySet() : Collections.emptySet());
        return helper;
    }
}

