/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.visitors;

import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Lag;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Matrix;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.TableLocator;
import org.dmg.pmml.TextIndex;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.baseline.BaselineModel;
import org.dmg.pmml.bayesian_network.BayesianNetworkModel;
import org.dmg.pmml.clustering.CenterFields;
import org.dmg.pmml.clustering.ClusteringModel;
import org.dmg.pmml.gaussian_process.GaussianProcessModel;
import org.dmg.pmml.general_regression.Categories;
import org.dmg.pmml.general_regression.Predictor;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.neural_network.NeuralLayer;
import org.dmg.pmml.neural_network.NeuralNetwork;
import org.dmg.pmml.regression.Regression;
import org.dmg.pmml.sequence.SequenceModel;
import org.dmg.pmml.support_vector_machine.SupportVectorMachineModel;
import org.dmg.pmml.text.TextModel;
import org.dmg.pmml.time_series.TimeSeriesModel;
import org.dmg.pmml.tree.DecisionTree;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.evaluator.UnsupportedFeatureException;
import org.jpmml.evaluator.visitors.FeatureInspector;
import org.jpmml.model.ReflectionUtil;

public class UnsupportedFeatureInspector
extends FeatureInspector<UnsupportedFeatureException> {
    public VisitorAction visit(Aggregate aggregate) {
        Aggregate.Function function = aggregate.getFunction();
        switch (function) {
            case MULTISET: {
                this.report(new UnsupportedFeatureException((PMMLObject)aggregate, (Enum<?>)function));
                break;
            }
        }
        return super.visit(aggregate);
    }

    public VisitorAction visit(Apply apply) {
        String function;
        switch (function = apply.getFunction()) {
            case "erf": 
            case "normalCDF": 
            case "normalIDF": 
            case "normalPDF": 
            case "stdNormalCDF": 
            case "stdNormalIDF": 
            case "stdNormalPDF": {
                this.report(new UnsupportedFeatureException((PMMLObject)apply, ReflectionUtil.getField(Apply.class, (String)"function"), function));
                break;
            }
        }
        return super.visit(apply);
    }

    public VisitorAction visit(BaselineModel baselineModel) {
        this.report(new UnsupportedFeatureException((PMMLObject)baselineModel));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(BayesianNetworkModel bayesianNetworkModel) {
        this.report(new UnsupportedFeatureException((PMMLObject)bayesianNetworkModel));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(CenterFields centerFields) {
        this.report(new UnsupportedFeatureException((PMMLObject)centerFields));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(ClusteringModel clusteringModel) {
        ClusteringModel.ModelClass modelClass = clusteringModel.getModelClass();
        switch (modelClass) {
            case DISTRIBUTION_BASED: {
                this.report(new UnsupportedFeatureException((PMMLObject)clusteringModel, (Enum<?>)modelClass));
                break;
            }
        }
        return super.visit(clusteringModel);
    }

    public VisitorAction visit(DecisionTree decisionTree) {
        this.report(new UnsupportedFeatureException((PMMLObject)decisionTree));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(GaussianProcessModel gaussianProcessModel) {
        this.report(new UnsupportedFeatureException((PMMLObject)gaussianProcessModel));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(Lag lag) {
        this.report(new UnsupportedFeatureException((PMMLObject)lag));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(NeuralNetwork neuralNetwork) {
        NeuralNetwork.ActivationFunction activationFunction = neuralNetwork.getActivationFunction();
        switch (activationFunction) {
            case RADIAL_BASIS: {
                this.report(new UnsupportedFeatureException((PMMLObject)neuralNetwork, (Enum<?>)activationFunction));
                break;
            }
        }
        return super.visit(neuralNetwork);
    }

    public VisitorAction visit(NeuralLayer neuralLayer) {
        NeuralNetwork.ActivationFunction activationFunction = neuralLayer.getActivationFunction();
        if (activationFunction != null) {
            switch (activationFunction) {
                case RADIAL_BASIS: {
                    this.report(new UnsupportedFeatureException((PMMLObject)neuralLayer, (Enum<?>)activationFunction));
                    break;
                }
            }
        }
        return super.visit(neuralLayer);
    }

    public VisitorAction visit(NormDiscrete normDiscrete) {
        NormDiscrete.Method method = normDiscrete.getMethod();
        switch (method) {
            case THERMOMETER: {
                this.report(new UnsupportedFeatureException((PMMLObject)normDiscrete, (Enum<?>)method));
                break;
            }
        }
        return super.visit(normDiscrete);
    }

    public VisitorAction visit(OutputField outputField) {
        ResultFeature resultFeature = outputField.getResultFeature();
        switch (resultFeature) {
            case STANDARD_ERROR: {
                this.report(new UnsupportedFeatureException((PMMLObject)outputField, (Enum<?>)resultFeature));
                break;
            }
        }
        return super.visit(outputField);
    }

    public VisitorAction visit(Predictor predictor) {
        Categories categories;
        Matrix matrix = predictor.getMatrix();
        if (matrix != null && (categories = predictor.getCategories()) == null) {
            this.report(new UnsupportedFeatureException((PMMLObject)predictor));
        }
        return super.visit(predictor);
    }

    public VisitorAction visit(Regression regression) {
        this.report(new UnsupportedFeatureException((PMMLObject)regression));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(Segmentation segmentation) {
        LocalTransformations localTransformations = segmentation.getLocalTransformations();
        if (localTransformations != null) {
            this.report(new UnsupportedFeatureException((PMMLObject)localTransformations));
        }
        return super.visit(segmentation);
    }

    public VisitorAction visit(SequenceModel sequenceModel) {
        this.report(new UnsupportedFeatureException((PMMLObject)sequenceModel));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(SupportVectorMachineModel supportVectorMachineModel) {
        boolean maxWins = supportVectorMachineModel.isMaxWins();
        if (maxWins) {
            this.report(new UnsupportedFeatureException((PMMLObject)supportVectorMachineModel, ReflectionUtil.getField(SupportVectorMachineModel.class, (String)"maxWins"), true));
        }
        SupportVectorMachineModel.Representation representation = supportVectorMachineModel.getRepresentation();
        switch (representation) {
            case COEFFICIENTS: {
                this.report(new UnsupportedFeatureException((PMMLObject)supportVectorMachineModel, (Enum<?>)representation));
                break;
            }
        }
        return super.visit(supportVectorMachineModel);
    }

    public VisitorAction visit(TableLocator tableLocator) {
        this.report(new UnsupportedFeatureException((PMMLObject)tableLocator));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(TextIndex textIndex) {
        boolean tokenize = textIndex.isTokenize();
        if (!tokenize) {
            this.report(new UnsupportedFeatureException((PMMLObject)textIndex, ReflectionUtil.getField(TextIndex.class, (String)"tokenize"), false));
        }
        TextIndex.LocalTermWeights localTermWeights = textIndex.getLocalTermWeights();
        switch (localTermWeights) {
            case AUGMENTED_NORMALIZED_TERM_FREQUENCY: {
                this.report(new UnsupportedFeatureException((PMMLObject)textIndex, (Enum<?>)localTermWeights));
                break;
            }
        }
        return super.visit(textIndex);
    }

    public VisitorAction visit(TextModel textModel) {
        this.report(new UnsupportedFeatureException((PMMLObject)textModel));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(TimeSeriesModel timeSeriesModel) {
        this.report(new UnsupportedFeatureException((PMMLObject)timeSeriesModel));
        return VisitorAction.SKIP;
    }

    public VisitorAction visit(TreeModel treeModel) {
        TreeModel.MissingValueStrategy missingValueStrategy = treeModel.getMissingValueStrategy();
        switch (missingValueStrategy) {
            case AGGREGATE_NODES: 
            case WEIGHTED_CONFIDENCE: {
                this.report(new UnsupportedFeatureException((PMMLObject)treeModel, (Enum<?>)missingValueStrategy));
                break;
            }
        }
        return super.visit(treeModel);
    }
}

