/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Value;

public class FloatValue
extends Value<Float> {
    protected float value = 0.0f;
    public static final double E = 2.7182817;
    public static final double PI = 3.1415927;

    public FloatValue(float value) {
        this.value = value;
    }

    @Override
    public int compareTo(Value<Float> that) {
        return Float.compare(this.floatValue(), that.floatValue());
    }

    public String toString() {
        return Float.toString(this.value);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public boolean equals(Object object) {
        if (object instanceof FloatValue) {
            FloatValue that = (FloatValue)object;
            return Float.floatToIntBits(this.value) == Float.floatToIntBits(that.value);
        }
        return false;
    }

    public FloatValue copy() {
        return new FloatValue(this.value);
    }

    public FloatValue add(double value) {
        this.value += (float)value;
        return this;
    }

    public FloatValue add(Value<?> value) {
        this.value += value.floatValue();
        return this;
    }

    public FloatValue add(double coefficient, Number factor, int exponent) {
        float value = factor.floatValue();
        if (exponent != 1) {
            value = FloatValue.pow(value, exponent);
        }
        this.value += (value *= (float)coefficient);
        return this;
    }

    public FloatValue add(double coefficient, Value<?> factor, int exponent) {
        float value = factor.floatValue();
        if (exponent != 1) {
            value = FloatValue.pow(value, exponent);
        }
        this.value += (value *= (float)coefficient);
        return this;
    }

    public FloatValue add(double coefficient, List<? extends Number> factors) {
        float value = (float)coefficient;
        for (int i = 0; i < factors.size(); ++i) {
            Number factor = factors.get(i);
            value *= factor.floatValue();
        }
        this.value += value;
        return this;
    }

    public FloatValue subtract(double value) {
        this.value -= (float)value;
        return this;
    }

    public FloatValue subtract(Value<?> value) {
        this.value -= value.floatValue();
        return this;
    }

    public FloatValue multiply(double value) {
        this.value *= (float)value;
        return this;
    }

    public FloatValue multiply(Number factor, double exponent) {
        float value = factor.floatValue();
        if (exponent != 1.0) {
            value = FloatValue.pow(value, (float)exponent);
        }
        this.value *= value;
        return this;
    }

    public FloatValue multiply(Value<?> factor, double exponent) {
        float value = factor.floatValue();
        if (exponent != 1.0) {
            value = FloatValue.pow(value, (float)exponent);
        }
        this.value *= value;
        return this;
    }

    public FloatValue multiply(Value<?> value) {
        this.value *= value.floatValue();
        return this;
    }

    public FloatValue divide(double value) {
        this.value /= (float)value;
        return this;
    }

    public FloatValue divide(Value<?> value) {
        this.value /= value.floatValue();
        return this;
    }

    public FloatValue residual(Value<?> value) {
        this.value = 1.0f - value.floatValue();
        return this;
    }

    public FloatValue square() {
        this.value *= this.value;
        return this;
    }

    public FloatValue reciprocal() {
        this.value = 1.0f / this.value;
        return this;
    }

    public FloatValue elliott() {
        this.value /= 1.0f + Math.abs(this.value);
        return this;
    }

    public FloatValue exp() {
        this.value = FloatValue.exp(this.value);
        return this;
    }

    public FloatValue gauss() {
        this.value = FloatValue.exp(-(this.value * this.value));
        return this;
    }

    public FloatValue inverseLogit() {
        this.value = 1.0f / (1.0f + FloatValue.exp(-this.value));
        return this;
    }

    public FloatValue inverseCloglog() {
        this.value = 1.0f - FloatValue.exp(-FloatValue.exp(this.value));
        return this;
    }

    public FloatValue inverseLoglog() {
        this.value = FloatValue.exp(-FloatValue.exp(-this.value));
        return this;
    }

    public FloatValue inverseLogc() {
        this.value = 1.0f - FloatValue.exp(this.value);
        return this;
    }

    public FloatValue inverseNegbin(double value) {
        this.value = 1.0f / ((float)value * (FloatValue.exp(-this.value) - 1.0f));
        return this;
    }

    public FloatValue inverseOddspower(double value) {
        this.value = value < 0.0 || value > 0.0 ? 1.0f / (1.0f + FloatValue.pow(1.0f + (float)value * this.value, -(1.0f / (float)value))) : 1.0f / (1.0f + FloatValue.exp(-this.value));
        return this;
    }

    public FloatValue inversePower(double value) {
        this.value = value < 0.0 || value > 0.0 ? FloatValue.pow(this.value, 1.0f / (float)value) : FloatValue.exp(this.value);
        return this;
    }

    public FloatValue inverseCauchit() {
        this.value = 0.5f + 0.31830987f * (float)Math.atan(this.value);
        return this;
    }

    public FloatValue inverseProbit() {
        throw new EvaluationException();
    }

    public FloatValue sin() {
        this.value = (float)Math.sin(this.value);
        return this;
    }

    public FloatValue cos() {
        this.value = (float)Math.cos(this.value);
        return this;
    }

    public FloatValue atan() {
        this.value = (float)Math.atan(this.value);
        return this;
    }

    public FloatValue tanh() {
        this.value = (float)Math.tanh(this.value);
        return this;
    }

    public FloatValue threshold(double value) {
        this.value = this.value > (float)value ? 1.0f : 0.0f;
        return this;
    }

    public FloatValue relu() {
        this.value = Math.max(this.value, 0.0f);
        return this;
    }

    public FloatValue restrict(double lowValue, double highValue) {
        this.value = Math.max(this.value, (float)lowValue);
        this.value = Math.min(this.value, (float)highValue);
        return this;
    }

    public FloatValue round() {
        this.value = Math.round(this.value);
        return this;
    }

    public FloatValue ceiling() {
        this.value = (float)Math.ceil(this.value);
        return this;
    }

    public FloatValue floor() {
        this.value = (float)Math.floor(this.value);
        return this;
    }

    public FloatValue denormalize(double leftOrig, double leftNorm, double rightOrig, double rightNorm) {
        this.value = (this.value - (float)leftNorm) / ((float)rightNorm - (float)leftNorm) * ((float)rightOrig - (float)leftOrig) + (float)leftOrig;
        return this;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    public static float exp(float value) {
        return (float)Math.pow(2.7182817, value);
    }

    public static float pow(float value, float power) {
        return (float)Math.pow(value, power);
    }
}

