/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Indexable;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.InvalidFeatureException;

public class IndexableUtil {
    private IndexableUtil() {
    }

    public static <K, E extends PMMLObject> E find(K key, List<E> elements) {
        for (PMMLObject element : elements) {
            if (!key.equals(IndexableUtil.ensureKey(element))) continue;
            return (E)element;
        }
        return null;
    }

    public static <K, E extends PMMLObject> List<K> keys(List<E> elements) {
        ArrayList<K> result = new ArrayList<K>(elements.size());
        for (PMMLObject element : elements) {
            result.add(IndexableUtil.ensureKey(element));
        }
        return result;
    }

    public static <K, E extends PMMLObject> Map<K, E> buildMap(List<E> elements) {
        return IndexableUtil.buildMap(elements, false);
    }

    public static <K, E extends PMMLObject> Map<K, E> buildMap(List<E> elements, boolean nullable) {
        LinkedHashMap<K, PMMLObject> result = new LinkedHashMap<K, PMMLObject>();
        for (PMMLObject element : elements) {
            K key = IndexableUtil.ensureKey(element, nullable);
            if (result.containsKey(key)) {
                throw new InvalidFeatureException(element);
            }
            result.put(key, element);
        }
        return Collections.unmodifiableMap(result);
    }

    private static <K, E extends PMMLObject> K ensureKey(E element) {
        return IndexableUtil.ensureKey(element, false);
    }

    private static <K, E extends PMMLObject> K ensureKey(E element, boolean nullable) {
        Object key = ((Indexable)element).getKey();
        if (key == null && !nullable) {
            throw new InvalidFeatureException(element);
        }
        return (K)key;
    }
}

