/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dmg.pmml.HasTable;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Row;
import org.dmg.pmml.TableLocator;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InlineTableUtil {
    private static final LoadingCache<InlineTable, Table<Integer, String, String>> contentCache = CacheUtil.buildLoadingCache(new CacheLoader<InlineTable, Table<Integer, String, String>>(){

        public Table<Integer, String, String> load(InlineTable inlineTable) {
            return Tables.unmodifiableTable(InlineTableUtil.parse(inlineTable));
        }
    });

    private InlineTableUtil() {
    }

    public static <E extends PMMLObject> InlineTable getInlineTable(E object) {
        InlineTable inlineTable = ((HasTable)object).getInlineTable();
        TableLocator tableLocator = ((HasTable)object).getTableLocator();
        if (tableLocator != null) {
            throw new UnsupportedFeatureException((PMMLObject)tableLocator);
        }
        return inlineTable;
    }

    public static Table<Integer, String, String> getContent(InlineTable inlineTable) {
        return CacheUtil.getValue(inlineTable, contentCache);
    }

    static Table<Integer, String, String> parse(InlineTable inlineTable) {
        HashBasedTable result = HashBasedTable.create();
        Integer rowKey = 1;
        List rows = inlineTable.getRows();
        for (Row row : rows) {
            List cells = row.getContent();
            for (Object cell : cells) {
                if (!(cell instanceof Element)) continue;
                Element element = (Element)cell;
                result.put((Object)rowKey, (Object)element.getTagName(), (Object)element.getTextContent());
            }
            rowKey = rowKey + 1;
        }
        return result;
    }

    static InlineTable format(Table<Integer, String, String> table) {
        DocumentBuilder documentBuilder;
        InlineTable result = new InlineTable();
        Map tableRows = table.rowMap();
        int minRow = (Integer)Collections.min(tableRows.keySet());
        int maxRow = (Integer)Collections.max(tableRows.keySet());
        if (minRow != 1 || maxRow != tableRows.size()) {
            throw new IllegalArgumentException();
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
        for (int i = minRow; i <= maxRow; ++i) {
            Map tableRow = (Map)tableRows.get(i);
            Row row = new Row();
            Document document = documentBuilder.newDocument();
            Set columns = tableRow.keySet();
            for (String column : columns) {
                Element cell = document.createElement(column);
                cell.setTextContent((String)tableRow.get(column));
                row.addContent(new Object[]{cell});
            }
            result.addRows(new Row[]{row});
        }
        return result;
    }
}

