/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.KeyValueAggregator;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.Vector;

public abstract class ProbabilityAggregator<V extends Number>
extends KeyValueAggregator<String, V> {
    private List<HasProbability> hasProbabilities = null;
    private int size = 0;
    private Vector<V> weights = null;

    public ProbabilityAggregator(int capacity) {
        this(capacity, null);
    }

    public ProbabilityAggregator(int capacity, Vector<V> weights) {
        super(capacity);
        if (capacity > 0) {
            this.hasProbabilities = new ArrayList<HasProbability>(capacity);
        }
        this.weights = weights;
    }

    @Override
    public void add(HasProbability hasProbability) {
        if (this.weights != null) {
            throw new IllegalStateException();
        }
        if (this.hasProbabilities != null) {
            this.hasProbabilities.add(hasProbability);
        }
        Set<String> categories = hasProbability.getCategoryValues();
        for (String category : categories) {
            Double probability = hasProbability.getProbability(category);
            this.add(category, (double)probability);
        }
        ++this.size;
    }

    @Override
    public void add(HasProbability hasProbability, double weight) {
        if (this.weights == null) {
            throw new IllegalStateException();
        }
        if (weight < 0.0) {
            throw new IllegalArgumentException();
        }
        if (this.hasProbabilities != null) {
            this.hasProbabilities.add(hasProbability);
        }
        Set<String> categories = hasProbability.getCategoryValues();
        for (String category : categories) {
            Double probability = hasProbability.getProbability(category);
            this.add(category, weight, probability);
        }
        ++this.size;
        this.weights.add(weight);
    }

    public ValueMap<String, V> averageMap() {
        if (this.weights != null) {
            throw new IllegalStateException();
        }
        Function function = new Function<Vector<V>, Value<V>>(){
            private double denominator;
            {
                this.denominator = ProbabilityAggregator.this.size;
            }

            public Value<V> apply(Vector<V> values) {
                return values.sum().divide(this.denominator);
            }
        };
        return new ValueMap(this.asTransformedMap(function));
    }

    public ValueMap<String, V> weightedAverageMap() {
        if (this.weights == null) {
            throw new IllegalStateException();
        }
        Function function = new Function<Vector<V>, Value<V>>(){
            private double denominator;
            {
                this.denominator = ProbabilityAggregator.this.weights.sum().doubleValue();
            }

            public Value<V> apply(Vector<V> values) {
                return values.sum().divide(this.denominator);
            }
        };
        return new ValueMap(this.asTransformedMap(function));
    }

    public ValueMap<String, V> maxMap(Collection<String> categories) {
        if (this.hasProbabilities == null) {
            throw new IllegalStateException();
        }
        if (this.weights != null) {
            throw new IllegalStateException();
        }
        Function function = new Function<Vector<V>, Value<V>>(){

            public Value<V> apply(Vector<V> values) {
                return values.max();
            }
        };
        Map<String, Value<V>> maxMap = this.asTransformedMap(function);
        Map.Entry<String, Value<V>> winnerEntry = ProbabilityAggregator.getWinner(maxMap, categories);
        if (winnerEntry == null) {
            return new ValueMap();
        }
        String category = winnerEntry.getKey();
        Value<V> maxProbability = winnerEntry.getValue();
        ArrayList<HasProbability> contributors = new ArrayList<HasProbability>();
        Vector values = this.get(category);
        int max = values.size();
        for (int i = 0; i < max; ++i) {
            Value probability = values.get(i);
            if (maxProbability.compareTo(probability) != 0) continue;
            HasProbability contributor = this.hasProbabilities.get(i);
            contributors.add(contributor);
        }
        return this.averageMap(contributors);
    }

    public ValueMap<String, V> medianMap(Collection<String> categories) {
        if (this.hasProbabilities == null) {
            throw new IllegalStateException();
        }
        if (this.weights != null) {
            throw new IllegalStateException();
        }
        Function function = new Function<Vector<V>, Value<V>>(){

            public Value<V> apply(Vector<V> values) {
                return values.median();
            }
        };
        Map<String, Value<V>> medianMap = this.asTransformedMap(function);
        Map.Entry<String, Value<V>> winnerEntry = ProbabilityAggregator.getWinner(medianMap, categories);
        if (winnerEntry == null) {
            return new ValueMap();
        }
        String category = winnerEntry.getKey();
        Value<V> medianProbability = winnerEntry.getValue();
        ArrayList<HasProbability> contributors = new ArrayList<HasProbability>();
        double minDifference = Double.MAX_VALUE;
        Vector values = this.get(category);
        int max = values.size();
        for (int i = 0; i < max; ++i) {
            Value probability = values.get(i);
            double difference = Math.abs(medianProbability.doubleValue() - probability.doubleValue());
            if (difference < minDifference) {
                contributors.clear();
                minDifference = difference;
            }
            if (!(difference <= minDifference)) continue;
            HasProbability contributor = this.hasProbabilities.get(i);
            contributors.add(contributor);
        }
        return this.averageMap(contributors);
    }

    private ValueMap<String, V> averageMap(List<HasProbability> hasProbabilities) {
        if (hasProbabilities.size() == 1) {
            HasProbability hasProbability = hasProbabilities.get(0);
            ValueFactory valueFactory = this.getValueFactory();
            ValueMap result = new ValueMap();
            Set<String> categories = hasProbability.getCategoryValues();
            for (String category : categories) {
                Double probability = hasProbability.getProbability(category);
                Value value = valueFactory.newValue(probability);
                result.put(category, value);
            }
            return result;
        }
        if (hasProbabilities.size() > 1) {
            ProbabilityAggregator aggregator = new ProbabilityAggregator<V>(0){

                @Override
                public ValueFactory<V> getValueFactory() {
                    return ProbabilityAggregator.this.getValueFactory();
                }
            };
            for (HasProbability hasProbability : hasProbabilities) {
                aggregator.add(hasProbability);
            }
            return aggregator.averageMap();
        }
        throw new EvaluationException();
    }

    private static <V extends Number> Map.Entry<String, Value<V>> getWinner(Map<String, Value<V>> values, Collection<String> categories) {
        if (categories == null || categories.isEmpty()) {
            throw new EvaluationException();
        }
        AbstractMap.SimpleEntry<String, Value<V>> maxEntry = null;
        for (String category : categories) {
            Value<V> value = values.get(category);
            if (value == null || maxEntry != null && ((Value)maxEntry.getValue()).compareTo(value) >= 0) continue;
            maxEntry = new AbstractMap.SimpleEntry<String, Value<V>>(category, value);
        }
        return maxEntry;
    }
}

