/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Target;
import org.dmg.pmml.TargetValue;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.ProbabilityDistribution;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;

public class TargetUtil {
    private TargetUtil() {
    }

    public static <V extends Number> Map<FieldName, ?> evaluateRegressionDefault(ValueFactory<V> valueFactory, TargetField targetField) {
        Value<V> value;
        Target target = targetField.getTarget();
        if (target != null && target.hasTargetValues() && (value = TargetUtil.getDefaultValue(valueFactory, target)) != null) {
            return TargetUtil.evaluateRegression(targetField, value);
        }
        return Collections.singletonMap(targetField.getName(), null);
    }

    public static Map<FieldName, ?> evaluateRegression(TargetField targetField, Double value) {
        return Collections.singletonMap(targetField.getName(), TargetUtil.evaluateRegressionInternal(targetField, value));
    }

    public static <V extends Number> Map<FieldName, ?> evaluateRegression(TargetField targetField, Value<V> value) {
        return Collections.singletonMap(targetField.getName(), TargetUtil.evaluateRegressionInternal(targetField, value));
    }

    public static Object evaluateRegressionInternal(TargetField targetField, Double value) {
        DataField dataField = targetField.getDataField();
        Target target = targetField.getTarget();
        if (target != null) {
            value = TargetUtil.processValue(target, value);
        }
        return TypeUtil.cast(dataField.getDataType(), (Object)value);
    }

    public static <V extends Number> Object evaluateRegressionInternal(TargetField targetField, Value<V> value) {
        DataField dataField = targetField.getDataField();
        Target target = targetField.getTarget();
        if (target != null) {
            value = TargetUtil.processValue(target, value);
        }
        return TypeUtil.cast(dataField.getDataType(), value.getValue());
    }

    public static <V extends Number> Map<FieldName, ? extends Classification> evaluateClassificationDefault(ValueFactory<V> valueFactory, TargetField targetField) {
        ProbabilityDistribution result;
        Target target = targetField.getTarget();
        if (target != null && target.hasTargetValues() && (result = TargetUtil.getPriorProbabilities(valueFactory, target)) != null) {
            return TargetUtil.evaluateClassification(targetField, result);
        }
        return Collections.singletonMap(targetField.getName(), null);
    }

    public static Map<FieldName, ? extends Classification> evaluateClassification(TargetField targetField, Classification value) {
        DataField dataField = targetField.getDataField();
        value.computeResult(dataField.getDataType());
        return Collections.singletonMap(targetField.getName(), value);
    }

    public static Double processValue(Target target, Double value) {
        Target.CastInteger castInteger;
        Double rescaleConstant;
        Double rescaleFactor;
        Double max;
        double result = value;
        Double min = target.getMin();
        if (min != null) {
            result = Math.max(result, min);
        }
        if ((max = target.getMax()) != null) {
            result = Math.min(result, max);
        }
        if ((rescaleFactor = target.getRescaleFactor()) != null) {
            result *= rescaleFactor.doubleValue();
        }
        if ((rescaleConstant = target.getRescaleConstant()) != null) {
            result += rescaleConstant.doubleValue();
        }
        if ((castInteger = target.getCastInteger()) == null) {
            if (result == value) {
                return value;
            }
            return result;
        }
        switch (castInteger) {
            case ROUND: {
                return Math.round(result);
            }
            case CEILING: {
                return Math.ceil(result);
            }
            case FLOOR: {
                return Math.floor(result);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)target, (Enum<?>)castInteger);
    }

    public static <V extends Number> Value<V> processValue(Target target, Value<V> value) {
        Target.CastInteger castInteger;
        Double rescaleConstant;
        Double rescaleFactor;
        Double max;
        double result = value.doubleValue();
        Double min = target.getMin();
        if (min != null) {
            value.restrict(min, Double.MAX_VALUE);
        }
        if ((max = target.getMax()) != null) {
            value.restrict(-1.7976931348623157E308, max);
        }
        if ((rescaleFactor = target.getRescaleFactor()) != null) {
            value.multiply(rescaleFactor);
        }
        if ((rescaleConstant = target.getRescaleConstant()) != null) {
            value.add(rescaleConstant);
        }
        if ((castInteger = target.getCastInteger()) == null) {
            return value;
        }
        switch (castInteger) {
            case ROUND: {
                return value.round();
            }
            case CEILING: {
                return value.ceiling();
            }
            case FLOOR: {
                return value.floor();
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)target, (Enum<?>)castInteger);
    }

    public static TargetValue getTargetValue(Target target, Object value) {
        DataType dataType = TypeUtil.getDataType(value);
        List targetValues = target.getTargetValues();
        for (TargetValue targetValue : targetValues) {
            if (!TypeUtil.equals(dataType, value, TypeUtil.parseOrCast(dataType, targetValue.getValue()))) continue;
            return targetValue;
        }
        return null;
    }

    private static <V extends Number> Value<V> getDefaultValue(ValueFactory<V> valueFactory, Target target) {
        if (!target.hasTargetValues()) {
            return null;
        }
        List targetValues = target.getTargetValues();
        if (targetValues.size() != 1) {
            throw new InvalidFeatureException((PMMLObject)target);
        }
        TargetValue targetValue = (TargetValue)targetValues.get(0);
        Double defaultValue = targetValue.getDefaultValue();
        if (targetValue.getValue() != null || targetValue.getPriorProbability() != null) {
            throw new InvalidFeatureException((PMMLObject)targetValue);
        }
        if (defaultValue == null) {
            return null;
        }
        return valueFactory.newValue(defaultValue);
    }

    private static <V extends Number> ProbabilityDistribution getPriorProbabilities(ValueFactory<V> valueFactory, Target target) {
        if (!target.hasTargetValues()) {
            return null;
        }
        ProbabilityDistribution result = new ProbabilityDistribution();
        Value<V> sum = valueFactory.newValue(0.0);
        List targetValues = target.getTargetValues();
        for (TargetValue targetValue : targetValues) {
            String targetCategory = targetValue.getValue();
            Double probability = targetValue.getPriorProbability();
            if (targetCategory == null || probability == null) {
                throw new InvalidFeatureException((PMMLObject)targetValue);
            }
            if (targetValue.getDefaultValue() != null) {
                throw new InvalidFeatureException((PMMLObject)targetValue);
            }
            Value<V> value = valueFactory.newValue(probability);
            sum.add(value);
            result.put(targetCategory, value.doubleValue());
        }
        if (sum.doubleValue() != 1.0) {
            throw new InvalidFeatureException((PMMLObject)target);
        }
        return result;
    }
}

