/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.TypeUtil;

public class TypeCheckException
extends EvaluationException {
    public TypeCheckException(Field field, Object value) {
        this(field.getDataType(), value);
    }

    public TypeCheckException(DataType expected, Object value) {
        this(TypeCheckException.formatDataType(expected), TypeCheckException.formatDataType(TypeCheckException.getDataType(value)), value);
    }

    public TypeCheckException(Class<?> expected, Object value) {
        this(TypeCheckException.formatClass(expected), TypeCheckException.formatClass(TypeCheckException.getClass(value)), value);
    }

    private TypeCheckException(String expected, String actual, Object value) {
        super(TypeCheckException.formatMessage(expected, actual, value));
    }

    private static String formatMessage(String expected, String actual, Object value) {
        String message = "Expected " + expected + ", but got " + actual;
        if (value != null) {
            message = message + " (" + String.valueOf(value) + ")";
        }
        return message;
    }

    private static DataType getDataType(Object value) {
        if (value != null) {
            try {
                return TypeUtil.getDataType(value);
            }
            catch (EvaluationException evaluationException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String formatDataType(DataType dataType) {
        return String.valueOf(dataType);
    }

    private static Class<?> getClass(Object value) {
        if (value != null) {
            return value.getClass();
        }
        return null;
    }

    private static String formatClass(Class<?> clazz) {
        return String.valueOf(clazz != null ? clazz.getName() : null);
    }
}

