/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.MathContext;
import org.jpmml.evaluator.ComplexDoubleVector;
import org.jpmml.evaluator.ComplexFloatVector;
import org.jpmml.evaluator.DoubleValue;
import org.jpmml.evaluator.FloatValue;
import org.jpmml.evaluator.SimpleDoubleVector;
import org.jpmml.evaluator.SimpleFloatVector;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.Vector;

public abstract class ValueFactory<V extends Number> {
    public static final ValueFactory<Float> FLOAT = new ValueFactory<Float>(){

        public FloatValue newValue(double value) {
            return new FloatValue((float)value);
        }

        public FloatValue newValue(Number value) {
            return new FloatValue(value.floatValue());
        }

        public FloatValue newValue(String string) {
            return new FloatValue(Float.parseFloat(string));
        }

        @Override
        public Vector<Float> newVector(int capacity) {
            return capacity > 0 ? new ComplexFloatVector(capacity) : new SimpleFloatVector();
        }
    };
    public static final ValueFactory<Double> DOUBLE = new ValueFactory<Double>(){

        public DoubleValue newValue(double value) {
            return new DoubleValue(value);
        }

        public DoubleValue newValue(Number value) {
            return new DoubleValue(value.doubleValue());
        }

        public DoubleValue newValue(String string) {
            return new DoubleValue(Double.parseDouble(string));
        }

        @Override
        public Vector<Double> newVector(int capacity) {
            return capacity > 0 ? new ComplexDoubleVector(capacity) : new SimpleDoubleVector();
        }
    };

    protected ValueFactory() {
    }

    public abstract Value<V> newValue(double var1);

    public abstract Value<V> newValue(Number var1);

    public abstract Value<V> newValue(String var1);

    public abstract Vector<V> newVector(int var1);

    public static ValueFactory<?> getInstance(MathContext mathContext) {
        switch (mathContext) {
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
        }
        throw new IllegalArgumentException();
    }
}

