/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.association;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Target;
import org.dmg.pmml.Targets;
import org.dmg.pmml.association.AssociationModel;
import org.dmg.pmml.association.AssociationRule;
import org.dmg.pmml.association.Item;
import org.dmg.pmml.association.ItemRef;
import org.dmg.pmml.association.Itemset;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.HasGroupFields;
import org.jpmml.evaluator.IndexableUtil;
import org.jpmml.evaluator.InputField;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.MissingValueException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;
import org.jpmml.evaluator.association.Association;

public class AssociationModelEvaluator
extends ModelEvaluator<AssociationModel>
implements HasGroupFields,
HasEntityRegistry<AssociationRule> {
    private transient List<InputField> groupInputFields = null;
    private transient BiMap<String, AssociationRule> entityRegistry = null;
    private transient Map<String, Item> items = null;
    private transient Map<String, Itemset> itemsets = null;
    private transient BiMap<String, String> itemValues = null;
    private static final FieldValue TRUE = FieldValueUtil.create(DataType.BOOLEAN, OpType.CATEGORICAL, true);
    private static final FieldValue FALSE = FieldValueUtil.create(DataType.BOOLEAN, OpType.CATEGORICAL, false);
    private static final LoadingCache<AssociationModel, BiMap<String, AssociationRule>> entityCache = CacheUtil.buildLoadingCache(new CacheLoader<AssociationModel, BiMap<String, AssociationRule>>(){

        public BiMap<String, AssociationRule> load(AssociationModel associationModel) {
            return EntityUtil.buildBiMap(associationModel.getAssociationRules());
        }
    });
    private static final LoadingCache<AssociationModel, Map<String, Item>> itemCache = CacheUtil.buildLoadingCache(new CacheLoader<AssociationModel, Map<String, Item>>(){

        public Map<String, Item> load(AssociationModel associationModel) {
            return IndexableUtil.buildMap(associationModel.getItems());
        }
    });
    private static final LoadingCache<AssociationModel, Map<String, Itemset>> itemsetCache = CacheUtil.buildLoadingCache(new CacheLoader<AssociationModel, Map<String, Itemset>>(){

        public Map<String, Itemset> load(AssociationModel associationModel) {
            return IndexableUtil.buildMap(associationModel.getItemsets());
        }
    });
    private static final LoadingCache<AssociationModel, BiMap<String, String>> itemValueCache = CacheUtil.buildLoadingCache(new CacheLoader<AssociationModel, BiMap<String, String>>(){

        public BiMap<String, String> load(AssociationModel associationModel) {
            return ImmutableBiMap.copyOf((Map)AssociationModelEvaluator.parseItemValues(associationModel));
        }
    });

    public AssociationModelEvaluator(PMML pmml) {
        this(pmml, AssociationModelEvaluator.selectModel(pmml, AssociationModel.class));
    }

    public AssociationModelEvaluator(PMML pmml, AssociationModel associationModel) {
        super(pmml, associationModel);
        Targets targets = associationModel.getTargets();
        if (targets != null) {
            throw new InvalidFeatureException((PMMLObject)targets);
        }
    }

    @Override
    public String getSummary() {
        return "Association rules";
    }

    @Override
    public List<InputField> getGroupFields() {
        if (this.groupInputFields == null) {
            this.groupInputFields = this.createInputFields(MiningField.UsageType.GROUP);
        }
        return this.groupInputFields;
    }

    @Override
    public Target getTarget(FieldName name) {
        return null;
    }

    @Override
    public FieldName getTargetFieldName() {
        return Evaluator.DEFAULT_TARGET_NAME;
    }

    @Override
    public BiMap<String, AssociationRule> getEntityRegistry() {
        if (this.entityRegistry == null) {
            this.entityRegistry = this.getValue(entityCache);
        }
        return this.entityRegistry;
    }

    @Override
    protected List<TargetField> createTargetFields() {
        List<TargetField> targetFields = super.createTargetFields();
        if (targetFields.size() > 0) {
            AssociationModel associationModel = (AssociationModel)this.getModel();
            MiningSchema miningSchema = associationModel.getMiningSchema();
            throw new InvalidFeatureException("Too many target fields", (PMMLObject)miningSchema);
        }
        return targetFields;
    }

    @Override
    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        Map<FieldName, Association> predictions;
        AssociationModel associationModel = (AssociationModel)this.getModel();
        if (!associationModel.isScorable()) {
            throw new InvalidResultException((PMMLObject)associationModel);
        }
        MathContext mathContext = associationModel.getMathContext();
        switch (mathContext) {
            case DOUBLE: {
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)associationModel, (Enum<?>)mathContext);
            }
        }
        MiningFunction miningFunction = associationModel.getMiningFunction();
        switch (miningFunction) {
            case ASSOCIATION_RULES: {
                predictions = this.evaluateAssociationRules(context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)associationModel, (Enum<?>)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, Association> evaluateAssociationRules(EvaluationContext context) {
        AssociationModel associationModel = (AssociationModel)this.getModel();
        Set<String> activeItems = this.getActiveItems(context);
        HashMap<String, Boolean> flags = new HashMap<String, Boolean>();
        List itemsets = associationModel.getItemsets();
        for (Itemset itemset : itemsets) {
            flags.put(itemset.getId(), AssociationModelEvaluator.isSubset(activeItems, itemset));
        }
        List associationRules = associationModel.getAssociationRules();
        BitSet antecedentFlags = new BitSet(associationRules.size());
        BitSet consequentFlags = new BitSet(associationRules.size());
        for (int i = 0; i < associationRules.size(); ++i) {
            AssociationRule associationRule = (AssociationRule)associationRules.get(i);
            Boolean antecedentFlag = (Boolean)flags.get(associationRule.getAntecedent());
            if (antecedentFlag == null) {
                throw new InvalidFeatureException((PMMLObject)associationRule);
            }
            antecedentFlags.set(i, antecedentFlag);
            Boolean consequentFlag = (Boolean)flags.get(associationRule.getConsequent());
            if (consequentFlag == null) {
                throw new InvalidFeatureException((PMMLObject)associationRule);
            }
            consequentFlags.set(i, consequentFlag);
        }
        Association association = new Association(associationRules, antecedentFlags, consequentFlags){

            @Override
            public Map<String, Item> getItems() {
                return AssociationModelEvaluator.this.getItems();
            }

            @Override
            public Map<String, Itemset> getItemsets() {
                return AssociationModelEvaluator.this.getItemsets();
            }

            @Override
            public BiMap<String, AssociationRule> getAssociationRuleRegistry() {
                return AssociationModelEvaluator.this.getEntityRegistry();
            }
        };
        return Collections.singletonMap(this.getTargetFieldName(), association);
    }

    Set<String> getActiveItems(EvaluationContext context) {
        AssociationModel associationModel = (AssociationModel)this.getModel();
        List<InputField> activeFields = this.getActiveFields();
        List<InputField> groupFields = this.getGroupFields();
        MiningSchema miningSchema = associationModel.getMiningSchema();
        ArrayList<String> itemValues = new ArrayList<String>();
        if (groupFields.size() == 0) {
            if (activeFields.size() < 1) {
                throw new InvalidFeatureException("No active fields", (PMMLObject)miningSchema);
            }
            block3: for (InputField activeField : activeFields) {
                FieldName name = activeField.getName();
                FieldValue value = context.evaluate(name);
                if (value == null) continue;
                OpType opType = value.getOpType();
                switch (opType) {
                    case CATEGORICAL: {
                        if (TRUE.equalsValue(value) || value.equalsString("T")) {
                            itemValues.add(name.getValue());
                            continue block3;
                        }
                        if (FALSE.equalsValue(value) || value.equalsString("F")) continue block3;
                        Object object = value.getValue();
                        itemValues.add(name.getValue() + "=" + TypeUtil.format(object));
                        continue block3;
                    }
                }
                throw new EvaluationException();
            }
        } else if (groupFields.size() == 1) {
            if (activeFields.size() < 1) {
                throw new InvalidFeatureException("No active fields", (PMMLObject)miningSchema);
            }
            if (activeFields.size() > 1) {
                throw new InvalidFeatureException("Too many active fields", (PMMLObject)miningSchema);
            }
            InputField activeField = activeFields.get(0);
            FieldName name = activeField.getName();
            FieldValue value = context.evaluate(name);
            if (value == null) {
                throw new MissingValueException(name);
            }
            Collection objects = FieldValueUtil.getValue(Collection.class, value);
            for (Object object : objects) {
                itemValues.add(TypeUtil.format(object));
            }
        } else {
            throw new InvalidFeatureException((PMMLObject)miningSchema);
        }
        HashSet<String> result = new HashSet<String>();
        BiMap valueItems = this.getItemValues().inverse();
        for (String itemValue : itemValues) {
            String itemId = (String)valueItems.get(itemValue);
            if (itemId == null) {
                context.addWarning("Unknown item value \"" + itemValue + "\"");
                continue;
            }
            result.add(itemId);
        }
        return result;
    }

    private static boolean isSubset(Set<String> items, Itemset itemset) {
        boolean result = true;
        List itemRefs = itemset.getItemRefs();
        for (ItemRef itemRef : itemRefs) {
            if (result &= items.contains(itemRef.getItemRef())) continue;
            return false;
        }
        return result;
    }

    private Map<String, Item> getItems() {
        if (this.items == null) {
            this.items = this.getValue(itemCache);
        }
        return this.items;
    }

    private Map<String, Itemset> getItemsets() {
        if (this.itemsets == null) {
            this.itemsets = this.getValue(itemsetCache);
        }
        return this.itemsets;
    }

    private BiMap<String, String> getItemValues() {
        if (this.itemValues == null) {
            this.itemValues = this.getValue(itemValueCache);
        }
        return this.itemValues;
    }

    private static BiMap<String, String> parseItemValues(AssociationModel associationModel) {
        HashBiMap result = HashBiMap.create();
        List items = associationModel.getItems();
        for (Item item : items) {
            result.put((Object)item.getId(), (Object)item.getValue());
        }
        return result;
    }
}

