/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.general_regression;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasValue;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.Matrix;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TypeDefinitionField;
import org.dmg.pmml.general_regression.BaseCumHazardTables;
import org.dmg.pmml.general_regression.BaselineCell;
import org.dmg.pmml.general_regression.BaselineStratum;
import org.dmg.pmml.general_regression.Categories;
import org.dmg.pmml.general_regression.Category;
import org.dmg.pmml.general_regression.GeneralRegressionModel;
import org.dmg.pmml.general_regression.PCell;
import org.dmg.pmml.general_regression.PPCell;
import org.dmg.pmml.general_regression.PPMatrix;
import org.dmg.pmml.general_regression.ParamMatrix;
import org.dmg.pmml.general_regression.Parameter;
import org.dmg.pmml.general_regression.ParameterCell;
import org.dmg.pmml.general_regression.ParameterList;
import org.dmg.pmml.general_regression.Predictor;
import org.dmg.pmml.general_regression.PredictorList;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.HasParsedValueMapping;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.MatrixUtil;
import org.jpmml.evaluator.MissingValueException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.ProbabilityDistribution;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.ValueUtil;
import org.jpmml.evaluator.general_regression.GeneralRegressionModelUtil;

public class GeneralRegressionModelEvaluator
extends ModelEvaluator<GeneralRegressionModel> {
    private transient BiMap<String, Parameter> parameterRegistry = null;
    private transient Map<String, Map<String, Row>> ppMatrixMap = null;
    private transient Map<String, List<PCell>> paramMatrixMap = null;
    private transient List<String> targetCategories = null;
    private static final LoadingCache<GeneralRegressionModel, BiMap<String, Parameter>> parameterCache = CacheUtil.buildLoadingCache(new CacheLoader<GeneralRegressionModel, BiMap<String, Parameter>>(){

        public BiMap<String, Parameter> load(GeneralRegressionModel generalRegressionModel) {
            return ImmutableBiMap.copyOf((Map)GeneralRegressionModelEvaluator.parseParameterRegistry(generalRegressionModel.getParameterList()));
        }
    });
    private static final LoadingCache<GeneralRegressionModel, BiMap<FieldName, Predictor>> factorCache = CacheUtil.buildLoadingCache(new CacheLoader<GeneralRegressionModel, BiMap<FieldName, Predictor>>(){

        public BiMap<FieldName, Predictor> load(GeneralRegressionModel generalRegressionModel) {
            return ImmutableBiMap.copyOf((Map)GeneralRegressionModelEvaluator.parsePredictorRegistry((PredictorList)generalRegressionModel.getFactorList()));
        }
    });
    private static final LoadingCache<GeneralRegressionModel, BiMap<FieldName, Predictor>> covariateCache = CacheUtil.buildLoadingCache(new CacheLoader<GeneralRegressionModel, BiMap<FieldName, Predictor>>(){

        public BiMap<FieldName, Predictor> load(GeneralRegressionModel generalRegressionModel) {
            return ImmutableBiMap.copyOf((Map)GeneralRegressionModelEvaluator.parsePredictorRegistry((PredictorList)generalRegressionModel.getCovariateList()));
        }
    });
    private static final LoadingCache<GeneralRegressionModel, Map<String, Map<String, Row>>> ppMatrixCache = CacheUtil.buildLoadingCache(new CacheLoader<GeneralRegressionModel, Map<String, Map<String, Row>>>(){

        public Map<String, Map<String, Row>> load(GeneralRegressionModel generalRegressionModel) {
            return Collections.unmodifiableMap(GeneralRegressionModelEvaluator.parsePPMatrix(generalRegressionModel));
        }
    });
    private static final LoadingCache<GeneralRegressionModel, Map<String, List<PCell>>> paramMatrixCache = CacheUtil.buildLoadingCache(new CacheLoader<GeneralRegressionModel, Map<String, List<PCell>>>(){

        public Map<String, List<PCell>> load(GeneralRegressionModel generalRegressionModel) {
            return Collections.unmodifiableMap(GeneralRegressionModelEvaluator.parseParamMatrix(generalRegressionModel));
        }
    });

    public GeneralRegressionModelEvaluator(PMML pmml) {
        this(pmml, GeneralRegressionModelEvaluator.selectModel(pmml, GeneralRegressionModel.class));
    }

    public GeneralRegressionModelEvaluator(PMML pmml, GeneralRegressionModel generalRegressionModel) {
        super(pmml, generalRegressionModel);
        ParameterList parameterList = generalRegressionModel.getParameterList();
        if (parameterList == null) {
            throw new InvalidFeatureException((PMMLObject)generalRegressionModel);
        }
        PPMatrix ppMatrix = generalRegressionModel.getPPMatrix();
        if (ppMatrix == null) {
            throw new InvalidFeatureException((PMMLObject)generalRegressionModel);
        }
        ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
        if (paramMatrix == null) {
            throw new InvalidFeatureException((PMMLObject)generalRegressionModel);
        }
    }

    @Override
    public String getSummary() {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.getModelType();
        switch (modelType) {
            case COX_REGRESSION: {
                return "Cox regression";
            }
        }
        return "General regression";
    }

    @Override
    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        Map<FieldName, Object> predictions;
        ValueFactory<?> valueFactory;
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        if (!generalRegressionModel.isScorable()) {
            throw new InvalidResultException((PMMLObject)generalRegressionModel);
        }
        MathContext mathContext = generalRegressionModel.getMathContext();
        switch (mathContext) {
            case FLOAT: 
            case DOUBLE: {
                valueFactory = ValueFactory.getInstance(mathContext);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum<?>)mathContext);
            }
        }
        MiningFunction miningFunction = generalRegressionModel.getMiningFunction();
        switch (miningFunction) {
            case REGRESSION: {
                predictions = this.evaluateRegression(valueFactory, context);
                break;
            }
            case CLASSIFICATION: {
                predictions = this.evaluateClassification(valueFactory, context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum<?>)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private <V extends Number> Map<FieldName, ?> evaluateRegression(ValueFactory<V> valueFactory, EvaluationContext context) {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.getModelType();
        switch (modelType) {
            case COX_REGRESSION: {
                return this.evaluateCoxRegression(valueFactory, context);
            }
        }
        return this.evaluateGeneralRegression(valueFactory, context);
    }

    private <V extends Number> Map<FieldName, V> evaluateCoxRegression(ValueFactory<V> valueFactory, EvaluationContext context) {
        FieldValue value;
        Double maxTime;
        List baselineCells;
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        BaseCumHazardTables baseCumHazardTables = generalRegressionModel.getBaseCumHazardTables();
        if (baseCumHazardTables == null) {
            throw new InvalidFeatureException((PMMLObject)generalRegressionModel);
        }
        FieldName baselineStrataVariable = generalRegressionModel.getBaselineStrataVariable();
        if (baselineStrataVariable != null) {
            FieldValue value2 = GeneralRegressionModelEvaluator.getVariable(baselineStrataVariable, context);
            BaselineStratum baselineStratum = GeneralRegressionModelEvaluator.getBaselineStratum(baseCumHazardTables, value2);
            if (baselineStratum == null) {
                return null;
            }
            baselineCells = baselineStratum.getBaselineCells();
            maxTime = baselineStratum.getMaxTime();
        } else {
            baselineCells = baseCumHazardTables.getBaselineCells();
            maxTime = baseCumHazardTables.getMaxTime();
            if (maxTime == null) {
                throw new InvalidFeatureException((PMMLObject)baseCumHazardTables);
            }
        }
        Comparator<BaselineCell> comparator = new Comparator<BaselineCell>(){

            @Override
            public int compare(BaselineCell left, BaselineCell right) {
                return Double.compare(left.getTime(), right.getTime());
            }
        };
        Ordering ordering = Ordering.from((Comparator)comparator);
        FieldName startTimeVariable = generalRegressionModel.getStartTimeVariable();
        FieldName endTimeVariable = generalRegressionModel.getEndTimeVariable();
        if (endTimeVariable != null) {
            FieldValue minTimeValue;
            BaselineCell minBaselineCell = (BaselineCell)ordering.min((Iterable)baselineCells);
            Double minTime = minBaselineCell.getTime();
            value = GeneralRegressionModelEvaluator.getVariable(endTimeVariable, context);
            if (value.compareToValue(minTimeValue = FieldValueUtil.create(DataType.DOUBLE, OpType.CONTINUOUS, minTime)) < 0) {
                Value<V> cumHazard = valueFactory.newValue(0.0);
                return Collections.singletonMap(this.getTargetFieldName(), cumHazard.getValue());
            }
            FieldValue maxTimeValue = FieldValueUtil.create(DataType.DOUBLE, OpType.CONTINUOUS, maxTime);
            if (value.compareToValue(maxTimeValue) > 0) {
                return null;
            }
        } else {
            throw new InvalidFeatureException((PMMLObject)generalRegressionModel);
        }
        Predicate<BaselineCell> predicate = new Predicate<BaselineCell>(){
            private double time;
            {
                this.time = value.asNumber().doubleValue();
            }

            public boolean apply(BaselineCell baselineCell) {
                return baselineCell.getTime() <= this.time;
            }
        };
        BaselineCell baselineCell = (BaselineCell)ordering.max(Iterables.filter((Iterable)baselineCells, (Predicate)predicate));
        double baselineCumHazard = baselineCell.getCumHazard();
        Value<V> r = this.computeDotProduct(valueFactory, context);
        Value<V> s = this.computeReferencePoint(valueFactory);
        if (r == null || s == null) {
            return null;
        }
        Value<V> cumHazard = r.subtract(s).exp().multiply(baselineCumHazard);
        return Collections.singletonMap(this.getTargetFieldName(), cumHazard.getValue());
    }

    private <V extends Number> Map<FieldName, ?> evaluateGeneralRegression(ValueFactory<V> valueFactory, EvaluationContext context) {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        TargetField targetField = this.getTargetField();
        Value<V> result = this.computeDotProduct(valueFactory, context);
        if (result == null) {
            return TargetUtil.evaluateRegressionDefault(valueFactory, targetField);
        }
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.getModelType();
        switch (modelType) {
            case REGRESSION: 
            case GENERAL_LINEAR: {
                break;
            }
            case GENERALIZED_LINEAR: {
                result = this.computeLink(result, context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
            }
        }
        return TargetUtil.evaluateRegression(targetField, result);
    }

    private <V extends Number> Map<FieldName, ? extends Classification> evaluateClassification(ValueFactory<V> valueFactory, EvaluationContext context) {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        TargetField targetField = this.getTargetField();
        List<String> targetCategories = this.getTargetCategories();
        Map<String, Map<String, Row>> ppMatrixMap = this.getPPMatrixMap();
        Map<String, List<PCell>> paramMatrixMap = this.getParamMatrixMap();
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.getModelType();
        ValueMap<String, Value<V>> values = new ValueMap<String, Value<V>>(2 * targetCategories.size());
        Value<V> previousValue = null;
        for (int i = 0; i < targetCategories.size(); ++i) {
            Value<V> value;
            String targetCategory = targetCategories.get(i);
            if (i < targetCategories.size() - 1) {
                Iterable parameterCells;
                Map<String, Row> parameterPredictorRows;
                if (ppMatrixMap.isEmpty()) {
                    parameterPredictorRows = Collections.emptyMap();
                } else {
                    parameterPredictorRows = ppMatrixMap.get(targetCategory);
                    if (parameterPredictorRows == null) {
                        parameterPredictorRows = ppMatrixMap.get(null);
                    }
                    if (parameterPredictorRows == null) {
                        PPMatrix ppMatrix = generalRegressionModel.getPPMatrix();
                        throw new InvalidFeatureException((PMMLObject)ppMatrix);
                    }
                }
                switch (modelType) {
                    case GENERALIZED_LINEAR: 
                    case MULTINOMIAL_LOGISTIC: {
                        parameterCells = paramMatrixMap.get(targetCategory);
                        if (parameterCells == null && targetCategories.size() == 2) {
                            parameterCells = paramMatrixMap.get(null);
                        }
                        if (parameterCells != null) break;
                        ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
                        throw new InvalidFeatureException((PMMLObject)paramMatrix);
                    }
                    case ORDINAL_MULTINOMIAL: {
                        List<PCell> interceptCells = paramMatrixMap.get(targetCategory);
                        if (interceptCells == null || interceptCells.size() != 1) {
                            ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
                            throw new InvalidFeatureException((PMMLObject)paramMatrix);
                        }
                        parameterCells = paramMatrixMap.get(null);
                        if (parameterCells == null) {
                            ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
                            throw new InvalidFeatureException((PMMLObject)paramMatrix);
                        }
                        parameterCells = Iterables.concat(interceptCells, (Iterable)parameterCells);
                        break;
                    }
                    default: {
                        throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
                    }
                }
                if ((value = this.computeDotProduct(valueFactory, parameterCells, parameterPredictorRows, context)) == null) {
                    return TargetUtil.evaluateClassificationDefault(valueFactory, targetField);
                }
                switch (modelType) {
                    case GENERALIZED_LINEAR: {
                        value = this.computeLink(value, context);
                        break;
                    }
                    case MULTINOMIAL_LOGISTIC: {
                        value.exp();
                        break;
                    }
                    case ORDINAL_MULTINOMIAL: {
                        value = this.computeCumulativeLink(value, context);
                        break;
                    }
                    default: {
                        throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
                    }
                }
            } else {
                switch (modelType) {
                    case GENERALIZED_LINEAR: {
                        value = valueFactory.newValue(1.0);
                        value.subtract(previousValue);
                        break;
                    }
                    case MULTINOMIAL_LOGISTIC: {
                        value = valueFactory.newValue(0.0);
                        value.exp();
                        break;
                    }
                    case ORDINAL_MULTINOMIAL: {
                        value = valueFactory.newValue(1.0);
                        break;
                    }
                    default: {
                        throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
                    }
                }
            }
            switch (modelType) {
                case GENERALIZED_LINEAR: 
                case MULTINOMIAL_LOGISTIC: {
                    break;
                }
                case ORDINAL_MULTINOMIAL: {
                    value.subtract(previousValue);
                    break;
                }
                default: {
                    throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
                }
            }
            values.put(targetCategory, value);
            previousValue = value;
        }
        switch (modelType) {
            case GENERALIZED_LINEAR: {
                break;
            }
            case MULTINOMIAL_LOGISTIC: {
                ValueUtil.normalizeSimpleMax(values);
                break;
            }
            case ORDINAL_MULTINOMIAL: {
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
            }
        }
        ProbabilityDistribution result = new ProbabilityDistribution(values.asDoubleMap());
        return TargetUtil.evaluateClassification(targetField, result);
    }

    private <V extends Number> Value<V> computeDotProduct(ValueFactory<V> valueFactory, EvaluationContext context) {
        Map<String, Row> parameterPredictorRows;
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        Map<String, Map<String, Row>> ppMatrixMap = this.getPPMatrixMap();
        if (ppMatrixMap.isEmpty()) {
            parameterPredictorRows = Collections.emptyMap();
        } else {
            parameterPredictorRows = ppMatrixMap.get(null);
            if (parameterPredictorRows == null) {
                PPMatrix ppMatrix = generalRegressionModel.getPPMatrix();
                throw new InvalidFeatureException((PMMLObject)ppMatrix);
            }
        }
        Map<String, List<PCell>> paramMatrixMap = this.getParamMatrixMap();
        List<PCell> parameterCells = paramMatrixMap.get(null);
        if (paramMatrixMap.size() != 1 || parameterCells == null) {
            ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
            throw new InvalidFeatureException((PMMLObject)paramMatrix);
        }
        return this.computeDotProduct(valueFactory, parameterCells, parameterPredictorRows, context);
    }

    private <V extends Number> Value<V> computeDotProduct(ValueFactory<V> valueFactory, Iterable<PCell> parameterCells, Map<String, Row> parameterPredictorRows, EvaluationContext context) {
        Value<V> result = null;
        for (PCell parameterCell : parameterCells) {
            Row parameterPredictorRow = parameterPredictorRows.get(parameterCell.getParameterName());
            if (result == null) {
                result = valueFactory.newValue(0.0);
            }
            if (parameterPredictorRow != null) {
                Value<V> x = parameterPredictorRow.evaluate(valueFactory, context);
                if (x == null) {
                    return null;
                }
                result.add(parameterCell.getBeta(), x, 1);
                continue;
            }
            result.add(parameterCell.getBeta());
        }
        return result;
    }

    private <V extends Number> Value<V> computeReferencePoint(ValueFactory<V> valueFactory) {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        BiMap<String, Parameter> parameters = this.getParameterRegistry();
        Map<String, List<PCell>> paramMatrixMap = this.getParamMatrixMap();
        Iterable parameterCells = paramMatrixMap.get(null);
        if (paramMatrixMap.size() != 1 || parameterCells == null) {
            ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
            throw new InvalidFeatureException((PMMLObject)paramMatrix);
        }
        Value<V> result = null;
        for (PCell parameterCell : parameterCells) {
            Parameter parameter = (Parameter)parameters.get((Object)parameterCell.getParameterName());
            if (result == null) {
                result = valueFactory.newValue(0.0);
            }
            if (parameter != null) {
                result.add(parameterCell.getBeta(), parameter.getReferencePoint(), 1);
                continue;
            }
            return null;
        }
        return result;
    }

    private <V extends Number> Value<V> computeLink(Value<V> value, EvaluationContext context) {
        Double offset;
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        GeneralRegressionModel.LinkFunction linkFunction = generalRegressionModel.getLinkFunction();
        if (linkFunction == null) {
            throw new InvalidFeatureException((PMMLObject)generalRegressionModel);
        }
        Double distParameter = generalRegressionModel.getDistParameter();
        Double linkParameter = generalRegressionModel.getLinkParameter();
        switch (linkFunction) {
            case CLOGLOG: 
            case IDENTITY: 
            case LOG: 
            case LOGC: 
            case LOGIT: 
            case LOGLOG: 
            case PROBIT: {
                if (distParameter == null && linkParameter == null) break;
                throw new InvalidFeatureException((PMMLObject)generalRegressionModel);
            }
            case NEGBIN: {
                if (distParameter != null && linkParameter == null) break;
                throw new InvalidFeatureException((PMMLObject)generalRegressionModel);
            }
            case ODDSPOWER: 
            case POWER: {
                if (distParameter == null && linkParameter != null) break;
                throw new InvalidFeatureException((PMMLObject)generalRegressionModel);
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum<?>)linkFunction);
            }
        }
        if ((offset = GeneralRegressionModelEvaluator.getOffset(generalRegressionModel, context)) != null) {
            value.add(offset);
        }
        switch (linkFunction) {
            case CLOGLOG: 
            case IDENTITY: 
            case LOG: 
            case LOGC: 
            case LOGIT: 
            case LOGLOG: 
            case PROBIT: 
            case NEGBIN: 
            case ODDSPOWER: 
            case POWER: {
                GeneralRegressionModelUtil.computeLink(value, distParameter, linkParameter, linkFunction);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum<?>)linkFunction);
            }
        }
        Integer trials = GeneralRegressionModelEvaluator.getTrials(generalRegressionModel, context);
        if (trials != null) {
            value.multiply(trials.doubleValue());
        }
        return value;
    }

    private <V extends Number> Value<V> computeCumulativeLink(Value<V> value, EvaluationContext context) {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        GeneralRegressionModel.CumulativeLinkFunction cumulativeLinkFunction = generalRegressionModel.getCumulativeLinkFunction();
        if (cumulativeLinkFunction == null) {
            throw new InvalidFeatureException((PMMLObject)generalRegressionModel);
        }
        Double offset = GeneralRegressionModelEvaluator.getOffset(generalRegressionModel, context);
        if (offset != null) {
            value.add(offset);
        }
        switch (cumulativeLinkFunction) {
            case LOGIT: 
            case PROBIT: 
            case CLOGLOG: 
            case LOGLOG: 
            case CAUCHIT: {
                GeneralRegressionModelUtil.computeCumulativeLink(value, cumulativeLinkFunction);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum<?>)cumulativeLinkFunction);
            }
        }
        return value;
    }

    public BiMap<String, Parameter> getParameterRegistry() {
        if (this.parameterRegistry == null) {
            this.parameterRegistry = this.getValue(parameterCache);
        }
        return this.parameterRegistry;
    }

    private Map<String, Map<String, Row>> getPPMatrixMap() {
        if (this.ppMatrixMap == null) {
            this.ppMatrixMap = this.getValue(ppMatrixCache);
        }
        return this.ppMatrixMap;
    }

    private Map<String, List<PCell>> getParamMatrixMap() {
        if (this.paramMatrixMap == null) {
            this.paramMatrixMap = this.getValue(paramMatrixCache);
        }
        return this.paramMatrixMap;
    }

    private List<String> getTargetCategories() {
        if (this.targetCategories == null) {
            this.targetCategories = ImmutableList.copyOf(this.parseTargetCategories());
        }
        return this.targetCategories;
    }

    private List<String> parseTargetCategories() {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        TargetField targetField = this.getTargetField();
        DataField dataField = targetField.getDataField();
        OpType opType = dataField.getOpType();
        switch (opType) {
            case CONTINUOUS: {
                throw new InvalidFeatureException((PMMLObject)dataField);
            }
            case CATEGORICAL: 
            case ORDINAL: {
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)dataField, (Enum<?>)opType);
            }
        }
        List<String> targetCategories = FieldValueUtil.getTargetCategories((TypeDefinitionField)dataField);
        if (targetCategories.size() > 0 && targetCategories.size() < 2) {
            throw new InvalidFeatureException((PMMLObject)dataField);
        }
        String targetReferenceCategory = generalRegressionModel.getTargetReferenceCategory();
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.getModelType();
        switch (modelType) {
            case GENERALIZED_LINEAR: 
            case MULTINOMIAL_LOGISTIC: {
                if (targetReferenceCategory != null) break;
                Predicate<String> filter = new Predicate<String>(){
                    private Map<String, List<PCell>> paramMatrixMap;
                    {
                        this.paramMatrixMap = GeneralRegressionModelEvaluator.this.getParamMatrixMap();
                    }

                    public boolean apply(String string) {
                        return !this.paramMatrixMap.containsKey(string);
                    }
                };
                LinkedHashSet targetReferenceCategories = Sets.newLinkedHashSet((Iterable)Iterables.filter(targetCategories, (Predicate)filter));
                if (targetReferenceCategories.size() != 1) {
                    ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
                    throw new InvalidFeatureException((PMMLObject)paramMatrix);
                }
                targetReferenceCategory = (String)Iterables.getOnlyElement((Iterable)targetReferenceCategories);
                break;
            }
            case ORDINAL_MULTINOMIAL: {
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
            }
        }
        if (targetReferenceCategory != null && (targetCategories = new ArrayList<String>(targetCategories)).remove(targetReferenceCategory)) {
            targetCategories.add(targetReferenceCategory);
        }
        return targetCategories;
    }

    private static Double getOffset(GeneralRegressionModel generalRegressionModel, EvaluationContext context) {
        FieldName offsetVariable = generalRegressionModel.getOffsetVariable();
        if (offsetVariable != null) {
            FieldValue value = GeneralRegressionModelEvaluator.getVariable(offsetVariable, context);
            return value.asDouble();
        }
        return generalRegressionModel.getOffsetValue();
    }

    private static Integer getTrials(GeneralRegressionModel generalRegressionModel, EvaluationContext context) {
        FieldName trialsVariable = generalRegressionModel.getTrialsVariable();
        if (trialsVariable != null) {
            FieldValue value = GeneralRegressionModelEvaluator.getVariable(trialsVariable, context);
            return value.asInteger();
        }
        return generalRegressionModel.getTrialsValue();
    }

    private static FieldValue getVariable(FieldName name, EvaluationContext context) {
        FieldValue value = context.evaluate(name);
        if (value == null) {
            throw new MissingValueException(name);
        }
        return value;
    }

    private static BaselineStratum getBaselineStratum(BaseCumHazardTables baseCumHazardTables, FieldValue value) {
        if (baseCumHazardTables instanceof HasParsedValueMapping) {
            HasParsedValueMapping hasParsedValueMapping = (HasParsedValueMapping)baseCumHazardTables;
            return (BaselineStratum)value.getMapping(hasParsedValueMapping);
        }
        List baselineStrata = baseCumHazardTables.getBaselineStrata();
        for (BaselineStratum baselineStratum : baselineStrata) {
            if (!value.equalsString(baselineStratum.getValue())) continue;
            return baselineStratum;
        }
        return null;
    }

    private static BiMap<String, Parameter> parseParameterRegistry(ParameterList parameterList) {
        HashBiMap result = HashBiMap.create();
        if (!parameterList.hasParameters()) {
            return result;
        }
        List parameters = parameterList.getParameters();
        for (Parameter parameter : parameters) {
            result.put((Object)parameter.getName(), (Object)parameter);
        }
        return result;
    }

    private static BiMap<FieldName, Predictor> parsePredictorRegistry(PredictorList predictorList) {
        HashBiMap result = HashBiMap.create();
        if (predictorList == null || !predictorList.hasPredictors()) {
            return result;
        }
        List predictors = predictorList.getPredictors();
        for (Predictor predictor : predictors) {
            result.put((Object)predictor.getName(), (Object)predictor);
        }
        return result;
    }

    private static Map<String, Map<String, Row>> parsePPMatrix(final GeneralRegressionModel generalRegressionModel) {
        Function<List<PPCell>, Row> function = new Function<List<PPCell>, Row>(){
            private BiMap<FieldName, Predictor> factors;
            private BiMap<FieldName, Predictor> covariates;
            {
                this.factors = (BiMap)CacheUtil.getValue(generalRegressionModel, factorCache);
                this.covariates = (BiMap)CacheUtil.getValue(generalRegressionModel, covariateCache);
            }

            public Row apply(List<PPCell> ppCells) {
                Row result = new Row();
                for (PPCell ppCell : ppCells) {
                    FieldName name = ppCell.getPredictorName();
                    Predictor factor = (Predictor)this.factors.get((Object)name);
                    if (factor != null) {
                        result.addFactor(ppCell, factor);
                        continue;
                    }
                    Predictor covariate = (Predictor)this.covariates.get((Object)name);
                    if (covariate != null) {
                        result.addCovariate(ppCell);
                        continue;
                    }
                    throw new InvalidFeatureException((PMMLObject)ppCell);
                }
                return result;
            }
        };
        PPMatrix ppMatrix = generalRegressionModel.getPPMatrix();
        ListMultimap targetCategoryMap = GeneralRegressionModelEvaluator.groupByTargetCategory(ppMatrix.getPPCells());
        LinkedHashMap<String, Map<String, Row>> result = new LinkedHashMap<String, Map<String, Row>>();
        Set targetCategoryEntries = GeneralRegressionModelEvaluator.asMap(targetCategoryMap).entrySet();
        for (Map.Entry entry : targetCategoryEntries) {
            LinkedHashMap predictorMap = new LinkedHashMap();
            ListMultimap parameterNameMap = GeneralRegressionModelEvaluator.groupByParameterName((List)entry.getValue());
            Set parameterNameEntries = GeneralRegressionModelEvaluator.asMap(parameterNameMap).entrySet();
            for (Map.Entry entry2 : parameterNameEntries) {
                predictorMap.put(entry2.getKey(), function.apply(entry2.getValue()));
            }
            result.put((String)entry.getKey(), predictorMap);
        }
        return result;
    }

    private static Map<String, List<PCell>> parseParamMatrix(GeneralRegressionModel generalRegressionModel) {
        ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
        ListMultimap targetCategoryCells = GeneralRegressionModelEvaluator.groupByTargetCategory(paramMatrix.getPCells());
        return GeneralRegressionModelEvaluator.asMap(targetCategoryCells);
    }

    private static <C extends ParameterCell> Map<String, List<C>> asMap(ListMultimap<String, C> multimap) {
        return multimap.asMap();
    }

    private static <C extends ParameterCell> ListMultimap<String, C> groupByParameterName(List<C> cells) {
        Function function = new Function<C, String>(){

            public String apply(C cell) {
                return cell.getParameterName();
            }
        };
        return GeneralRegressionModelEvaluator.groupCells(cells, function);
    }

    private static <C extends ParameterCell> ListMultimap<String, C> groupByTargetCategory(List<C> cells) {
        Function function = new Function<C, String>(){

            public String apply(C cell) {
                return cell.getTargetCategory();
            }
        };
        return GeneralRegressionModelEvaluator.groupCells(cells, function);
    }

    private static <C extends ParameterCell> ListMultimap<String, C> groupCells(List<C> cells, Function<C, String> function) {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (ParameterCell cell : cells) {
            result.put(function.apply((Object)cell), (Object)cell);
        }
        return result;
    }

    private static class Row {
        private List<FactorHandler> factorHandlers = new ArrayList<FactorHandler>();
        private List<CovariateHandler> covariateHandlers = new ArrayList<CovariateHandler>();

        private Row() {
        }

        public <V extends Number> Value<V> evaluate(ValueFactory<V> valueFactory, EvaluationContext context) {
            Value<V> result = valueFactory.newValue(1.0);
            List<FactorHandler> factorHandlers = this.getFactorHandlers();
            int max = factorHandlers.size();
            for (int i = 0; i < max; ++i) {
                FactorHandler factorHandler = factorHandlers.get(i);
                FieldValue value = context.evaluate(factorHandler.getPredictorName());
                if (value == null) {
                    return null;
                }
                factorHandler.updateProduct(result, value);
            }
            if (result.doubleValue() == 0.0) {
                return result;
            }
            List<CovariateHandler> covariateHandlers = this.getCovariateHandlers();
            int max2 = covariateHandlers.size();
            for (int i = 0; i < max2; ++i) {
                CovariateHandler covariateHandler = covariateHandlers.get(i);
                FieldValue value = context.evaluate(covariateHandler.getPredictorName());
                if (value == null) {
                    return null;
                }
                covariateHandler.updateProduct(result, value);
            }
            return result;
        }

        public void addFactor(PPCell ppCell, Predictor predictor) {
            List<FactorHandler> factorHandlers = this.getFactorHandlers();
            Matrix matrix = predictor.getMatrix();
            if (matrix != null) {
                Categories categories = predictor.getCategories();
                if (categories == null) {
                    throw new UnsupportedFeatureException((PMMLObject)predictor);
                }
                Function<Category, String> function = new Function<Category, String>(){

                    public String apply(Category category) {
                        return category.getValue();
                    }
                };
                List values = Lists.transform((List)categories.getCategories(), (Function)function);
                factorHandlers.add(new ContrastMatrixHandler(ppCell, matrix, values));
            } else {
                factorHandlers.add(new FactorHandler(ppCell));
            }
        }

        private void addCovariate(PPCell ppCell) {
            List<CovariateHandler> covariateHandlers = this.getCovariateHandlers();
            covariateHandlers.add(new CovariateHandler(ppCell));
        }

        public List<FactorHandler> getFactorHandlers() {
            return this.factorHandlers;
        }

        public List<CovariateHandler> getCovariateHandlers() {
            return this.covariateHandlers;
        }

        private class CovariateHandler
        extends PredictorHandler {
            private double power;

            private CovariateHandler(PPCell ppCell) {
                super(ppCell);
                this.power = 1.0;
                String value = ppCell.getValue();
                if (value == null) {
                    throw new InvalidFeatureException((PMMLObject)ppCell);
                }
                this.setPower(Double.parseDouble(value));
            }

            @Override
            public <V extends Number> Value<V> updateProduct(Value<V> product, FieldValue value) {
                double power = this.getPower();
                return product.multiply(value.asNumber(), power);
            }

            public double getPower() {
                return this.power;
            }

            private void setPower(double power) {
                this.power = power;
            }
        }

        private class ContrastMatrixHandler
        extends FactorHandler {
            private Matrix matrix;
            private List<String> categories;
            private List<FieldValue> parsedValueList;

            private ContrastMatrixHandler(PPCell ppCell, Matrix matrix, List<String> categories) {
                super(ppCell);
                this.matrix = null;
                this.categories = null;
                this.parsedValueList = null;
                this.setMatrix(matrix);
                this.setCategories(categories);
            }

            @Override
            public <V extends Number> Value<V> updateProduct(Value<V> product, FieldValue value) {
                Matrix matrix = this.getMatrix();
                int row = this.getIndex(value);
                int column = this.getIndex(this.getCategory());
                if (row < 0 || column < 0) {
                    throw new EvaluationException();
                }
                Number result = MatrixUtil.getElementAt(matrix, row + 1, column + 1);
                if (result == null) {
                    throw new EvaluationException();
                }
                return product.multiply(result.doubleValue());
            }

            public int getIndex(FieldValue value) {
                if (this.parsedValueList == null) {
                    this.parsedValueList = ImmutableList.copyOf(this.parseCategories(value.getDataType(), value.getOpType()));
                }
                return this.parsedValueList.indexOf(value);
            }

            public int getIndex(String category) {
                List<String> categories = this.getCategories();
                return categories.indexOf(category);
            }

            private List<FieldValue> parseCategories(final DataType dataType, final OpType opType) {
                List<String> categories = this.getCategories();
                Function<String, FieldValue> function = new Function<String, FieldValue>(){

                    public FieldValue apply(String value) {
                        return FieldValueUtil.create(dataType, opType, value);
                    }
                };
                return Lists.transform(categories, (Function)function);
            }

            public Matrix getMatrix() {
                return this.matrix;
            }

            private void setMatrix(Matrix matrix) {
                this.matrix = matrix;
            }

            public List<String> getCategories() {
                return this.categories;
            }

            private void setCategories(List<String> categories) {
                this.categories = categories;
            }
        }

        private class FactorHandler
        extends PredictorHandler {
            private String category;

            private FactorHandler(PPCell ppCell) {
                super(ppCell);
                this.category = null;
                String value = ppCell.getValue();
                if (value == null) {
                    throw new InvalidFeatureException((PMMLObject)ppCell);
                }
                this.setCategory(value);
            }

            @Override
            public <V extends Number> Value<V> updateProduct(Value<V> product, FieldValue value) {
                PPCell ppCell = this.getPPCell();
                boolean equals = value.equals((HasValue<?>)ppCell);
                return product.multiply(equals ? 1.0 : 0.0);
            }

            public String getCategory() {
                return this.category;
            }

            private void setCategory(String category) {
                this.category = category;
            }
        }

        private abstract class PredictorHandler {
            private PPCell ppCell = null;

            private PredictorHandler(PPCell ppCell) {
                this.setPPCell(ppCell);
            }

            public abstract <V extends Number> Value<V> updateProduct(Value<V> var1, FieldValue var2);

            public FieldName getPredictorName() {
                PPCell ppCell = this.getPPCell();
                return ppCell.getPredictorName();
            }

            public PPCell getPPCell() {
                return this.ppCell;
            }

            private void setPPCell(PPCell ppCell) {
                this.ppCell = ppCell;
            }
        }
    }
}

