/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.nearest_neighbor;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.Measure;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TypeDefinitionField;
import org.dmg.pmml.nearest_neighbor.InstanceField;
import org.dmg.pmml.nearest_neighbor.InstanceFields;
import org.dmg.pmml.nearest_neighbor.KNNInput;
import org.dmg.pmml.nearest_neighbor.KNNInputs;
import org.dmg.pmml.nearest_neighbor.NearestNeighborModel;
import org.dmg.pmml.nearest_neighbor.TrainingInstances;
import org.jpmml.evaluator.AffinityDistribution;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.ComplexDoubleVector;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InlineTableUtil;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.MeasureUtil;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.MissingValueException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.SimpleDoubleVector;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;
import org.jpmml.evaluator.ValueAggregator;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.VoteAggregator;

public class NearestNeighborModelEvaluator
extends ModelEvaluator<NearestNeighborModel> {
    private transient Table<Integer, FieldName, FieldValue> trainingInstances = null;
    private transient Map<Integer, BitSet> instanceFlags = null;
    private transient Map<Integer, List<FieldValue>> instanceValues = null;
    private static final Cache<NearestNeighborModel, Table<Integer, FieldName, FieldValue>> trainingInstanceCache = CacheUtil.buildCache();
    private static final Cache<NearestNeighborModel, Map<Integer, BitSet>> instanceFlagCache = CacheUtil.buildCache();
    private static final Cache<NearestNeighborModel, Map<Integer, List<FieldValue>>> instanceValueCache = CacheUtil.buildCache();

    public NearestNeighborModelEvaluator(PMML pmml) {
        this(pmml, NearestNeighborModelEvaluator.selectModel(pmml, NearestNeighborModel.class));
    }

    public NearestNeighborModelEvaluator(PMML pmml, NearestNeighborModel nearestNeighborModel) {
        super(pmml, nearestNeighborModel);
        ComparisonMeasure comparisoonMeasure = nearestNeighborModel.getComparisonMeasure();
        if (comparisoonMeasure == null) {
            throw new InvalidFeatureException((PMMLObject)nearestNeighborModel);
        }
        TrainingInstances trainingInstances = nearestNeighborModel.getTrainingInstances();
        if (trainingInstances == null) {
            throw new InvalidFeatureException((PMMLObject)nearestNeighborModel);
        }
        InstanceFields instanceFields = trainingInstances.getInstanceFields();
        if (instanceFields == null) {
            throw new InvalidFeatureException((PMMLObject)trainingInstances);
        }
        if (!instanceFields.hasInstanceFields()) {
            throw new InvalidFeatureException((PMMLObject)instanceFields);
        }
        KNNInputs knnInputs = nearestNeighborModel.getKNNInputs();
        if (knnInputs == null) {
            throw new InvalidFeatureException((PMMLObject)nearestNeighborModel);
        }
        if (!knnInputs.hasKNNInputs()) {
            throw new InvalidFeatureException((PMMLObject)knnInputs);
        }
    }

    @Override
    public String getSummary() {
        return "k-Nearest neighbors model";
    }

    @Override
    protected DataField getDataField() {
        MiningFunction miningFunction = this.getMiningFunction();
        switch (miningFunction) {
            case REGRESSION: 
            case CLASSIFICATION: 
            case MIXED: {
                return null;
            }
        }
        return super.getDataField();
    }

    @Override
    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        Map<FieldName, AffinityDistribution> predictions;
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)this.getModel();
        if (!nearestNeighborModel.isScorable()) {
            throw new InvalidResultException((PMMLObject)nearestNeighborModel);
        }
        MathContext mathContext = nearestNeighborModel.getMathContext();
        switch (mathContext) {
            case DOUBLE: {
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)nearestNeighborModel, (Enum<?>)mathContext);
            }
        }
        MiningFunction miningFunction = nearestNeighborModel.getMiningFunction();
        switch (miningFunction) {
            case REGRESSION: 
            case CLASSIFICATION: 
            case MIXED: {
                predictions = this.evaluateMixed(context);
                break;
            }
            case CLUSTERING: {
                predictions = this.evaluateClustering(context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)nearestNeighborModel, (Enum<?>)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, AffinityDistribution> evaluateMixed(EvaluationContext context) {
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)this.getModel();
        Table<Integer, FieldName, FieldValue> table = this.getTrainingInstances();
        List<InstanceResult> instanceResults = this.evaluateInstanceRows(context);
        Ordering ordering = Ordering.natural().reverse();
        List<InstanceResult> nearestInstanceResults = ordering.sortedCopy(instanceResults);
        nearestInstanceResults = nearestInstanceResults.subList(0, nearestNeighborModel.getNumberOfNeighbors());
        Function<Integer, String> function = new Function<Integer, String>(){

            public String apply(Integer row) {
                return row.toString();
            }
        };
        FieldName instanceIdVariable = nearestNeighborModel.getInstanceIdVariable();
        if (instanceIdVariable != null) {
            function = this.createIdentifierResolver(instanceIdVariable, table);
        }
        LinkedHashMap<FieldName, AffinityDistribution> result = new LinkedHashMap<FieldName, AffinityDistribution>();
        List<TargetField> targetFields = this.getTargetFields();
        for (TargetField targetField : targetFields) {
            Object value;
            FieldName name = targetField.getName();
            DataField dataField = targetField.getDataField();
            OpType opType = dataField.getOpType();
            switch (opType) {
                case CONTINUOUS: {
                    value = this.calculateContinuousTarget(name, nearestInstanceResults, table);
                    break;
                }
                case CATEGORICAL: {
                    value = this.calculateCategoricalTarget(name, nearestInstanceResults, table);
                    break;
                }
                default: {
                    throw new UnsupportedFeatureException((PMMLObject)dataField, (Enum<?>)opType);
                }
            }
            value = TypeUtil.parseOrCast(dataField.getDataType(), value);
            result.put(name, this.createAffinityDistribution(instanceResults, function, value));
        }
        return result;
    }

    private Map<FieldName, AffinityDistribution> evaluateClustering(EvaluationContext context) {
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)this.getModel();
        Table<Integer, FieldName, FieldValue> table = this.getTrainingInstances();
        List<InstanceResult> instanceResults = this.evaluateInstanceRows(context);
        FieldName instanceIdVariable = nearestNeighborModel.getInstanceIdVariable();
        if (instanceIdVariable == null) {
            throw new InvalidFeatureException((PMMLObject)nearestNeighborModel);
        }
        Function<Integer, String> function = this.createIdentifierResolver(instanceIdVariable, table);
        return Collections.singletonMap(this.getTargetFieldName(), this.createAffinityDistribution(instanceResults, function, null));
    }

    private List<InstanceResult> evaluateInstanceRows(EvaluationContext context) {
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)this.getModel();
        ArrayList<FieldValue> values = new ArrayList<FieldValue>();
        KNNInputs knnInputs = nearestNeighborModel.getKNNInputs();
        for (KNNInput knnInput : knnInputs) {
            FieldValue value = context.evaluate(knnInput.getField());
            values.add(value);
        }
        ComparisonMeasure comparisonMeasure = nearestNeighborModel.getComparisonMeasure();
        Measure measure = comparisonMeasure.getMeasure();
        if (MeasureUtil.isSimilarity(measure)) {
            return this.evaluateSimilarity(comparisonMeasure, knnInputs.getKNNInputs(), values);
        }
        if (MeasureUtil.isDistance(measure)) {
            return this.evaluateDistance(comparisonMeasure, knnInputs.getKNNInputs(), values);
        }
        throw new UnsupportedFeatureException((PMMLObject)measure);
    }

    private List<InstanceResult> evaluateSimilarity(ComparisonMeasure comparisonMeasure, List<KNNInput> knnInputs, List<FieldValue> values) {
        BitSet flags = MeasureUtil.toBitSet(values);
        Map<Integer, BitSet> flagMap = this.getInstanceFlags();
        ArrayList<InstanceResult> result = new ArrayList<InstanceResult>(flagMap.size());
        Set<Integer> rowKeys = flagMap.keySet();
        for (Integer rowKey : rowKeys) {
            BitSet instanceFlags = flagMap.get(rowKey);
            Double similarity = MeasureUtil.evaluateSimilarity(comparisonMeasure, knnInputs, flags, instanceFlags);
            result.add(new InstanceResult.Similarity(rowKey, similarity));
        }
        return result;
    }

    private List<InstanceResult> evaluateDistance(ComparisonMeasure comparisonMeasure, List<KNNInput> knnInputs, List<FieldValue> values) {
        Map<Integer, List<FieldValue>> valueMap = this.getInstanceValues();
        ArrayList<InstanceResult> result = new ArrayList<InstanceResult>(valueMap.size());
        double adjustment = MeasureUtil.calculateAdjustment(values);
        Set<Integer> rowKeys = valueMap.keySet();
        for (Integer rowKey : rowKeys) {
            List<FieldValue> instanceValues = valueMap.get(rowKey);
            Double distance = MeasureUtil.evaluateDistance(comparisonMeasure, knnInputs, values, instanceValues, adjustment);
            result.add(new InstanceResult.Distance(rowKey, distance));
        }
        return result;
    }

    private Double calculateContinuousTarget(FieldName name, List<InstanceResult> instanceResults, Table<Integer, FieldName, FieldValue> table) {
        ValueAggregator<Double> aggregator;
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)this.getModel();
        NearestNeighborModel.ContinuousScoringMethod continuousScoringMethod = nearestNeighborModel.getContinuousScoringMethod();
        switch (continuousScoringMethod) {
            case AVERAGE: {
                aggregator = new ValueAggregator<Double>(new SimpleDoubleVector());
                break;
            }
            case WEIGHTED_AVERAGE: {
                aggregator = new ValueAggregator<Double>(new SimpleDoubleVector(), new SimpleDoubleVector(), new SimpleDoubleVector());
                break;
            }
            case MEDIAN: {
                aggregator = new ValueAggregator<Double>(new ComplexDoubleVector(instanceResults.size()));
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)nearestNeighborModel, (Enum<?>)continuousScoringMethod);
            }
        }
        block14: for (InstanceResult instanceResult : instanceResults) {
            FieldValue value = (FieldValue)table.get((Object)instanceResult.getId(), (Object)name);
            if (value == null) {
                throw new MissingValueException(name);
            }
            Number number = value.asNumber();
            switch (continuousScoringMethod) {
                case AVERAGE: 
                case MEDIAN: {
                    aggregator.add(number);
                    continue block14;
                }
                case WEIGHTED_AVERAGE: {
                    double weight = instanceResult.getWeight(nearestNeighborModel.getThreshold());
                    aggregator.add(number, weight);
                    continue block14;
                }
            }
            throw new UnsupportedFeatureException((PMMLObject)nearestNeighborModel, (Enum<?>)continuousScoringMethod);
        }
        switch (continuousScoringMethod) {
            case AVERAGE: {
                return aggregator.average().getValue();
            }
            case WEIGHTED_AVERAGE: {
                return aggregator.weightedAverage().getValue();
            }
            case MEDIAN: {
                return aggregator.median().getValue();
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)nearestNeighborModel, (Enum<?>)continuousScoringMethod);
    }

    private Object calculateCategoricalTarget(FieldName name, List<InstanceResult> instanceResults, Table<Integer, FieldName, FieldValue> table) {
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)this.getModel();
        VoteAggregator<Object, Double> aggregator = new VoteAggregator<Object, Double>(){

            @Override
            public ValueFactory getValueFactory() {
                return ValueFactory.DOUBLE;
            }
        };
        NearestNeighborModel.CategoricalScoringMethod categoricalScoringMethod = nearestNeighborModel.getCategoricalScoringMethod();
        block4: for (InstanceResult instanceResult : instanceResults) {
            FieldValue value = (FieldValue)table.get((Object)instanceResult.getId(), (Object)name);
            if (value == null) {
                throw new MissingValueException(name);
            }
            Object object = value.getValue();
            switch (categoricalScoringMethod) {
                case MAJORITY_VOTE: {
                    aggregator.add(object);
                    continue block4;
                }
                case WEIGHTED_MAJORITY_VOTE: {
                    double weight = instanceResult.getWeight(nearestNeighborModel.getThreshold());
                    aggregator.add(object, weight);
                    continue block4;
                }
            }
            throw new UnsupportedFeatureException((PMMLObject)nearestNeighborModel, (Enum<?>)categoricalScoringMethod);
        }
        Set winners = aggregator.getWinners();
        if (winners.size() > 1) {
            LinkedHashMultiset multiset = LinkedHashMultiset.create();
            Map column = table.column((Object)name);
            Function<FieldValue, Object> function = new Function<FieldValue, Object>(){

                public Object apply(FieldValue value) {
                    return value.getValue();
                }
            };
            multiset.addAll(Collections2.transform(column.values(), (Function)function));
            aggregator.clear();
            for (Object winner : winners) {
                aggregator.add(winner, multiset.count(winner));
            }
            winners = aggregator.getWinners();
            if (winners.size() > 1) {
                return Collections.min(winners);
            }
        }
        return Iterables.getFirst(winners, null);
    }

    private Function<Integer, String> createIdentifierResolver(final FieldName name, final Table<Integer, FieldName, FieldValue> table) {
        Function<Integer, String> function = new Function<Integer, String>(){

            public String apply(Integer row) {
                FieldValue value = (FieldValue)table.get((Object)row, (Object)name);
                if (value == null) {
                    throw new MissingValueException(name);
                }
                return value.asString();
            }
        };
        return function;
    }

    private AffinityDistribution createAffinityDistribution(List<InstanceResult> instanceResults, Function<Integer, String> function, Object value) {
        AffinityDistribution result;
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)this.getModel();
        ComparisonMeasure comparisonMeasure = nearestNeighborModel.getComparisonMeasure();
        Measure measure = comparisonMeasure.getMeasure();
        if (MeasureUtil.isSimilarity(measure)) {
            result = new AffinityDistribution(Classification.Type.SIMILARITY, value);
        } else if (MeasureUtil.isDistance(measure)) {
            result = new AffinityDistribution(Classification.Type.DISTANCE, value);
        } else {
            throw new UnsupportedFeatureException((PMMLObject)measure);
        }
        for (InstanceResult instanceResult : instanceResults) {
            result.put((String)function.apply((Object)instanceResult.getId()), instanceResult.getValue());
        }
        return result;
    }

    private Table<Integer, FieldName, FieldValue> getTrainingInstances() {
        if (this.trainingInstances == null) {
            this.trainingInstances = this.getValue(trainingInstanceCache, NearestNeighborModelEvaluator.createTrainingInstanceLoader(this));
        }
        return this.trainingInstances;
    }

    private static Callable<Table<Integer, FieldName, FieldValue>> createTrainingInstanceLoader(final NearestNeighborModelEvaluator modelEvaluator) {
        return new Callable<Table<Integer, FieldName, FieldValue>>(){

            @Override
            public Table<Integer, FieldName, FieldValue> call() {
                return NearestNeighborModelEvaluator.parseTrainingInstances(modelEvaluator);
            }
        };
    }

    private static Table<Integer, FieldName, FieldValue> parseTrainingInstances(NearestNeighborModelEvaluator modelEvaluator) {
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)modelEvaluator.getModel();
        FieldName instanceIdVariable = nearestNeighborModel.getInstanceIdVariable();
        TrainingInstances trainingInstances = nearestNeighborModel.getTrainingInstances();
        ArrayList<FieldLoader> fieldLoaders = new ArrayList<FieldLoader>();
        InstanceFields instanceFields = trainingInstances.getInstanceFields();
        for (InstanceField instanceField : instanceFields) {
            FieldName name = instanceField.getField();
            String column = instanceField.getColumn();
            if (instanceIdVariable != null && instanceIdVariable.equals((Object)name)) {
                fieldLoaders.add(new IdentifierLoader(name, column));
                continue;
            }
            TypeDefinitionField field = modelEvaluator.resolveField(name);
            if (field == null) {
                throw new MissingFieldException(name, (PMMLObject)instanceField);
            }
            if (field instanceof DataField) {
                DataField dataField = (DataField)field;
                MiningField miningField = modelEvaluator.getMiningField(name);
                fieldLoaders.add(new DataFieldLoader(name, column, dataField, miningField));
                continue;
            }
            if (field instanceof DerivedField) {
                DerivedField derivedField = (DerivedField)field;
                fieldLoaders.add(new DerivedFieldLoader(name, column, derivedField));
                continue;
            }
            throw new InvalidFeatureException((PMMLObject)instanceField);
        }
        HashBasedTable result = HashBasedTable.create();
        InlineTable inlineTable = InlineTableUtil.getInlineTable(trainingInstances);
        if (inlineTable != null) {
            Table<Integer, String, String> table = InlineTableUtil.getContent(inlineTable);
            Set rowKeys = table.rowKeySet();
            for (Integer rowKey : rowKeys) {
                Map rowValues = table.row((Object)rowKey);
                for (FieldLoader fieldLoader : fieldLoaders) {
                    result.put((Object)rowKey, (Object)fieldLoader.getName(), (Object)fieldLoader.load(rowValues));
                }
            }
        }
        KNNInputs knnInputs = nearestNeighborModel.getKNNInputs();
        for (KNNInput knnInput : knnInputs) {
            FieldName name = knnInput.getField();
            DerivedField derivedField = modelEvaluator.resolveDerivedField(name);
            if (derivedField == null) continue;
            Set rowKeys = result.rowKeySet();
            for (Integer rowKey : rowKeys) {
                Map rowValues = result.row((Object)rowKey);
                if (rowValues.containsKey(name)) continue;
                ModelEvaluationContext context = new ModelEvaluationContext(null, modelEvaluator);
                context.declareAll(rowValues);
                result.put((Object)rowKey, (Object)name, (Object)ExpressionUtil.evaluate(derivedField, (EvaluationContext)context));
            }
        }
        return result;
    }

    private Map<Integer, BitSet> getInstanceFlags() {
        if (this.instanceFlags == null) {
            this.instanceFlags = this.getValue(instanceFlagCache, NearestNeighborModelEvaluator.createInstanceFlagLoader(this));
        }
        return this.instanceFlags;
    }

    private static Callable<Map<Integer, BitSet>> createInstanceFlagLoader(final NearestNeighborModelEvaluator modelEvaluator) {
        return new Callable<Map<Integer, BitSet>>(){

            @Override
            public Map<Integer, BitSet> call() {
                return NearestNeighborModelEvaluator.loadInstanceFlags(modelEvaluator);
            }
        };
    }

    private static Map<Integer, BitSet> loadInstanceFlags(NearestNeighborModelEvaluator modelEvaluator) {
        LinkedHashMap<Integer, BitSet> result = new LinkedHashMap<Integer, BitSet>();
        Map<Integer, List<FieldValue>> valueMap = modelEvaluator.getValue(instanceValueCache, NearestNeighborModelEvaluator.createInstanceValueLoader(modelEvaluator));
        Maps.EntryTransformer<Integer, List<FieldValue>, BitSet> transformer = new Maps.EntryTransformer<Integer, List<FieldValue>, BitSet>(){

            public BitSet transformEntry(Integer key, List<FieldValue> value) {
                return MeasureUtil.toBitSet(value);
            }
        };
        result.putAll(Maps.transformEntries(valueMap, (Maps.EntryTransformer)transformer));
        return result;
    }

    private Map<Integer, List<FieldValue>> getInstanceValues() {
        if (this.instanceValues == null) {
            this.instanceValues = this.getValue(instanceValueCache, NearestNeighborModelEvaluator.createInstanceValueLoader(this));
        }
        return this.instanceValues;
    }

    private static Callable<Map<Integer, List<FieldValue>>> createInstanceValueLoader(final NearestNeighborModelEvaluator modelEvaluator) {
        return new Callable<Map<Integer, List<FieldValue>>>(){

            @Override
            public Map<Integer, List<FieldValue>> call() {
                return NearestNeighborModelEvaluator.loadInstanceValues(modelEvaluator);
            }
        };
    }

    private static Map<Integer, List<FieldValue>> loadInstanceValues(NearestNeighborModelEvaluator modelEvaluator) {
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)modelEvaluator.getModel();
        LinkedHashMap<Integer, List<FieldValue>> result = new LinkedHashMap<Integer, List<FieldValue>>();
        Table<Integer, FieldName, FieldValue> table = modelEvaluator.getValue(trainingInstanceCache, NearestNeighborModelEvaluator.createTrainingInstanceLoader(modelEvaluator));
        KNNInputs knnInputs = nearestNeighborModel.getKNNInputs();
        ImmutableSortedSet rowKeys = ImmutableSortedSet.copyOf((Collection)table.rowKeySet());
        for (Integer rowKey : rowKeys) {
            ArrayList<FieldValue> values = new ArrayList<FieldValue>();
            Map rowValues = table.row((Object)rowKey);
            for (KNNInput knnInput : knnInputs) {
                FieldValue value = (FieldValue)rowValues.get(knnInput.getField());
                values.add(value);
            }
            result.put(rowKey, values);
        }
        return result;
    }

    private static abstract class InstanceResult
    implements Comparable<InstanceResult> {
        private Integer id = null;
        private Double value = null;

        private InstanceResult(Integer id, Double value) {
            this.setId(id);
            this.setValue(value);
        }

        public abstract double getWeight(double var1);

        public Integer getId() {
            return this.id;
        }

        private void setId(Integer id) {
            this.id = id;
        }

        public Double getValue() {
            return this.value;
        }

        private void setValue(Double value) {
            this.value = value;
        }

        private static class Distance
        extends InstanceResult {
            private Distance(Integer id, Double value) {
                super(id, value);
            }

            @Override
            public int compareTo(InstanceResult that) {
                if (that instanceof Distance) {
                    return Classification.Type.DISTANCE.compare(this.getValue(), that.getValue());
                }
                throw new ClassCastException();
            }

            @Override
            public double getWeight(double threshold) {
                return 1.0 / (this.getValue() + threshold);
            }
        }

        private static class Similarity
        extends InstanceResult {
            private Similarity(Integer id, Double value) {
                super(id, value);
            }

            @Override
            public int compareTo(InstanceResult that) {
                if (that instanceof Similarity) {
                    return Classification.Type.SIMILARITY.compare(this.getValue(), that.getValue());
                }
                throw new ClassCastException();
            }

            @Override
            public double getWeight(double threshold) {
                throw new EvaluationException();
            }
        }
    }

    private static class DerivedFieldLoader
    extends FieldLoader {
        private DerivedField derivedField = null;

        private DerivedFieldLoader(FieldName name, String column, DerivedField derivedField) {
            super(name, column);
            this.setDerivedField(derivedField);
        }

        @Override
        public FieldValue prepare(String value) {
            return FieldValueUtil.create((Field)this.getDerivedField(), value);
        }

        public DerivedField getDerivedField() {
            return this.derivedField;
        }

        private void setDerivedField(DerivedField derivedField) {
            this.derivedField = derivedField;
        }
    }

    private static class DataFieldLoader
    extends FieldLoader {
        private DataField dataField = null;
        private MiningField miningField = null;

        private DataFieldLoader(FieldName name, String column, DataField dataField, MiningField miningField) {
            super(name, column);
            this.setDataField(dataField);
            this.setMiningField(miningField);
        }

        @Override
        public FieldValue prepare(String value) {
            return FieldValueUtil.prepareInputValue((Field)this.getDataField(), this.getMiningField(), value);
        }

        public DataField getDataField() {
            return this.dataField;
        }

        private void setDataField(DataField dataField) {
            this.dataField = dataField;
        }

        public MiningField getMiningField() {
            return this.miningField;
        }

        private void setMiningField(MiningField miningField) {
            this.miningField = miningField;
        }
    }

    private static class IdentifierLoader
    extends FieldLoader {
        private IdentifierLoader(FieldName name, String column) {
            super(name, column);
        }

        @Override
        public FieldValue prepare(String value) {
            return FieldValueUtil.create(DataType.STRING, OpType.CATEGORICAL, value);
        }
    }

    private static abstract class FieldLoader {
        private FieldName name = null;
        private String column = null;

        private FieldLoader(FieldName name, String column) {
            this.setName(name);
            this.setColumn(column);
        }

        public abstract FieldValue prepare(String var1);

        public FieldValue load(Map<String, String> values) {
            String value = values.get(this.getColumn());
            return this.prepare(value);
        }

        public FieldName getName() {
            return this.name;
        }

        private void setName(FieldName name) {
            this.name = name;
        }

        public String getColumn() {
            return this.column;
        }

        private void setColumn(String column) {
            this.column = column;
        }
    }
}

