/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.scorecard;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.scorecard.Attribute;
import org.dmg.pmml.scorecard.Characteristic;
import org.dmg.pmml.scorecard.Characteristics;
import org.dmg.pmml.scorecard.ComplexPartialScore;
import org.dmg.pmml.scorecard.Scorecard;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.PredicateUtil;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.VoteAggregator;
import org.jpmml.evaluator.scorecard.ReasonCodeRanking;

public class ScorecardEvaluator
extends ModelEvaluator<Scorecard> {
    public ScorecardEvaluator(PMML pmml) {
        this(pmml, ScorecardEvaluator.selectModel(pmml, Scorecard.class));
    }

    public ScorecardEvaluator(PMML pmml, Scorecard scorecard) {
        super(pmml, scorecard);
        Characteristics characteristics = scorecard.getCharacteristics();
        if (characteristics == null) {
            throw new InvalidFeatureException((PMMLObject)scorecard);
        }
        if (!characteristics.hasCharacteristics()) {
            throw new InvalidFeatureException((PMMLObject)characteristics);
        }
    }

    @Override
    public String getSummary() {
        return "Scorecard";
    }

    @Override
    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        Map<FieldName, ?> predictions;
        ValueFactory<?> valueFactory;
        Scorecard scorecard = (Scorecard)this.getModel();
        if (!scorecard.isScorable()) {
            throw new InvalidResultException((PMMLObject)scorecard);
        }
        MathContext mathContext = scorecard.getMathContext();
        switch (mathContext) {
            case FLOAT: 
            case DOUBLE: {
                valueFactory = ValueFactory.getInstance(mathContext);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)scorecard, (Enum<?>)mathContext);
            }
        }
        MiningFunction miningFunction = scorecard.getMiningFunction();
        switch (miningFunction) {
            case REGRESSION: {
                predictions = this.evaluateRegression(valueFactory, context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)scorecard, (Enum<?>)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private <V extends Number> Map<FieldName, ?> evaluateRegression(final ValueFactory<V> valueFactory, EvaluationContext context) {
        Scorecard scorecard = (Scorecard)this.getModel();
        boolean useReasonCodes = scorecard.isUseReasonCodes();
        TargetField targetField = this.getTargetField();
        Value<V> score = valueFactory.newValue(scorecard.getInitialScore());
        VoteAggregator reasonCodePoints = null;
        if (useReasonCodes) {
            reasonCodePoints = new VoteAggregator<String, V>(){

                @Override
                public ValueFactory<V> getValueFactory() {
                    return valueFactory;
                }
            };
        }
        Characteristics characteristics = scorecard.getCharacteristics();
        for (Characteristic characteristic : characteristics) {
            Double baselineScore = null;
            if (useReasonCodes) {
                baselineScore = characteristic.getBaselineScore();
                if (baselineScore == null) {
                    baselineScore = scorecard.getBaselineScore();
                }
                if (baselineScore == null) {
                    throw new InvalidFeatureException((PMMLObject)characteristic);
                }
            }
            Double partialScore = null;
            List attributes = characteristic.getAttributes();
            for (Attribute attribute : attributes) {
                double difference;
                Predicate predicate = attribute.getPredicate();
                if (predicate == null) {
                    throw new InvalidFeatureException((PMMLObject)attribute);
                }
                Boolean status = PredicateUtil.evaluate(predicate, context);
                if (status == null || !status.booleanValue()) continue;
                ComplexPartialScore complexPartialScore = attribute.getComplexPartialScore();
                if (complexPartialScore != null) {
                    Expression expression = complexPartialScore.getExpression();
                    if (expression == null) {
                        throw new InvalidFeatureException((PMMLObject)complexPartialScore);
                    }
                    FieldValue computedValue = ExpressionUtil.evaluate(expression, context);
                    if (computedValue == null) {
                        return TargetUtil.evaluateRegressionDefault(valueFactory, targetField);
                    }
                    partialScore = computedValue.asDouble();
                } else {
                    partialScore = attribute.getPartialScore();
                    if (partialScore == null) {
                        throw new InvalidFeatureException((PMMLObject)attribute);
                    }
                }
                score.add(partialScore);
                if (!useReasonCodes) break;
                String reasonCode = attribute.getReasonCode();
                if (reasonCode == null) {
                    reasonCode = characteristic.getReasonCode();
                }
                if (reasonCode == null) {
                    throw new InvalidFeatureException((PMMLObject)attribute);
                }
                Scorecard.ReasonCodeAlgorithm reasonCodeAlgorithm = scorecard.getReasonCodeAlgorithm();
                switch (reasonCodeAlgorithm) {
                    case POINTS_ABOVE: {
                        difference = partialScore - baselineScore;
                        break;
                    }
                    case POINTS_BELOW: {
                        difference = baselineScore - partialScore;
                        break;
                    }
                    default: {
                        throw new UnsupportedFeatureException((PMMLObject)scorecard, (Enum<?>)reasonCodeAlgorithm);
                    }
                }
                reasonCodePoints.add(reasonCode, difference);
                break;
            }
            if (partialScore != null) continue;
            throw new InvalidResultException((PMMLObject)characteristic);
        }
        Object result = TargetUtil.evaluateRegressionInternal(targetField, score);
        if (useReasonCodes) {
            result = ScorecardEvaluator.createReasonCodeList(reasonCodePoints.sumMap(), result);
        }
        return Collections.singletonMap(targetField.getName(), result);
    }

    private static <V extends Number> ReasonCodeRanking createReasonCodeList(Map<String, Value<V>> reasonCodes, Object value) {
        LinkedHashMap<String, Double> meaningfulReasonCodes = new LinkedHashMap<String, Double>();
        Set<Map.Entry<String, Value<V>>> entrySet = reasonCodes.entrySet();
        for (Map.Entry entry : entrySet) {
            String reasonCode = (String)entry.getKey();
            Value points = (Value)entry.getValue();
            if (!(points.doubleValue() >= 0.0)) continue;
            meaningfulReasonCodes.put(reasonCode, points.doubleValue());
        }
        ReasonCodeRanking result = new ReasonCodeRanking(value, meaningfulReasonCodes);
        return result;
    }
}

