/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.support_vector_machine;

import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.support_vector_machine.Kernel;
import org.dmg.pmml.support_vector_machine.LinearKernel;
import org.dmg.pmml.support_vector_machine.PolynomialKernel;
import org.dmg.pmml.support_vector_machine.RadialBasisKernel;
import org.dmg.pmml.support_vector_machine.SigmoidKernel;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.UnsupportedFeatureException;

public class KernelUtil {
    private KernelUtil() {
    }

    public static double evaluate(Kernel kernel, double[] input, double[] vector) {
        if (kernel instanceof LinearKernel) {
            return KernelUtil.evaluateLinearKernel((LinearKernel)kernel, input, vector);
        }
        if (kernel instanceof PolynomialKernel) {
            return KernelUtil.evaluatePolynomialKernel((PolynomialKernel)kernel, input, vector);
        }
        if (kernel instanceof RadialBasisKernel) {
            return KernelUtil.evaluateRadialBasisKernel((RadialBasisKernel)kernel, input, vector);
        }
        if (kernel instanceof SigmoidKernel) {
            return KernelUtil.evaluateSigmoidKernel((SigmoidKernel)kernel, input, vector);
        }
        throw new UnsupportedFeatureException((PMMLObject)kernel);
    }

    public static double evaluateLinearKernel(LinearKernel linearKernel, double[] input, double[] vector) {
        return KernelUtil.dotProduct(input, vector);
    }

    public static double evaluatePolynomialKernel(PolynomialKernel polynomialKernel, double[] input, double[] vector) {
        return Math.pow(polynomialKernel.getGamma() * KernelUtil.dotProduct(input, vector) + polynomialKernel.getCoef0(), polynomialKernel.getDegree());
    }

    public static double evaluateRadialBasisKernel(RadialBasisKernel radialBasisKernel, double[] input, double[] vector) {
        return Math.exp(-radialBasisKernel.getGamma().doubleValue() * KernelUtil.squaredDistance(input, vector));
    }

    public static double evaluateSigmoidKernel(SigmoidKernel sigmoidKernel, double[] input, double[] vector) {
        return Math.tanh(sigmoidKernel.getGamma() * KernelUtil.dotProduct(input, vector) + sigmoidKernel.getCoef0());
    }

    private static double dotProduct(double[] left, double[] right) {
        double sum = 0.0;
        if (left.length != right.length) {
            throw new EvaluationException();
        }
        for (int i = 0; i < left.length; ++i) {
            sum += left[i] * right[i];
        }
        return sum;
    }

    private static double squaredDistance(double[] left, double[] right) {
        double sum = 0.0;
        if (left.length != right.length) {
            throw new EvaluationException();
        }
        for (int i = 0; i < left.length; ++i) {
            double diff = left[i] - right[i];
            sum += diff * diff;
        }
        return sum;
    }
}

