/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Joiner;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.Target;
import org.dmg.pmml.TargetValue;
import org.dmg.pmml.Value;
import org.dmg.pmml.association.AssociationRule;
import org.dmg.pmml.association.Item;
import org.dmg.pmml.association.ItemRef;
import org.dmg.pmml.association.Itemset;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.FieldValues;
import org.jpmml.evaluator.HasAffinity;
import org.jpmml.evaluator.HasAffinityRanking;
import org.jpmml.evaluator.HasDisplayValue;
import org.jpmml.evaluator.HasEntityAffinity;
import org.jpmml.evaluator.HasEntityId;
import org.jpmml.evaluator.HasEntityIdRanking;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.HasPrediction;
import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.HasReasonCodeRanking;
import org.jpmml.evaluator.HasRuleValues;
import org.jpmml.evaluator.InvalidAttributeException;
import org.jpmml.evaluator.InvalidElementException;
import org.jpmml.evaluator.MisplacedElementException;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.MissingValueException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.PMMLAttributes;
import org.jpmml.evaluator.Report;
import org.jpmml.evaluator.ReportUtil;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.UnsupportedElementException;
import org.jpmml.evaluator.mining.MiningModelEvaluationContext;
import org.jpmml.evaluator.mining.SegmentResult;

public class OutputUtil {
    private OutputUtil() {
    }

    public static Map<FieldName, ?> evaluate(Map<FieldName, ?> predictions, ModelEvaluationContext context) {
        ModelEvaluator<?> modelEvaluator = context.getModelEvaluator();
        Object model = modelEvaluator.getModel();
        Output output = model.getOutput();
        if (output == null || !output.hasOutputFields()) {
            return predictions;
        }
        LinkedHashMap result = new LinkedHashMap(predictions);
        List outputFields = output.getOutputFields();
        for (OutputField outputField : outputFields) {
            Object value;
            FieldName targetFieldName = outputField.getTargetField();
            Object targetValue = null;
            ResultFeature resultFeature = outputField.getResultFeature();
            String segmentId = outputField.getSegmentId();
            SegmentResult segmentPredictions = null;
            if (segmentId != null) {
                if (!(model instanceof MiningModel)) {
                    throw new InvalidAttributeException((PMMLObject)outputField, PMMLAttributes.OUTPUTFIELD_SEGMENTID, segmentId);
                }
                MiningModelEvaluationContext miningModelContext = (MiningModelEvaluationContext)context;
                segmentPredictions = miningModelContext.getResult(segmentId);
                if (segmentPredictions == null) continue;
                if (targetFieldName != null) {
                    if (!segmentPredictions.containsKey(targetFieldName)) {
                        throw new MissingValueException(targetFieldName, (PMMLObject)outputField);
                    }
                    targetValue = segmentPredictions.get(targetFieldName);
                } else {
                    targetValue = segmentPredictions.getTargetValue();
                }
            } else {
                switch (resultFeature) {
                    case ENTITY_ID: {
                        if (model instanceof MiningModel) {
                            targetValue = TypeUtil.cast(HasEntityId.class, predictions);
                            break;
                        }
                    }
                    default: {
                        if (targetFieldName == null) {
                            targetFieldName = modelEvaluator.getTargetFieldName();
                        }
                        if (!predictions.containsKey(targetFieldName)) {
                            throw new MissingValueException(targetFieldName, (PMMLObject)outputField);
                        }
                        targetValue = predictions.get(targetFieldName);
                    }
                }
            }
            if (targetValue == null) continue;
            block3 : switch (resultFeature) {
                case PREDICTED_VALUE: {
                    value = OutputUtil.getPredictedValue(targetValue);
                    break;
                }
                case PREDICTED_DISPLAY_VALUE: {
                    if (segmentId != null) {
                        throw new UnsupportedElementException((PMMLObject)outputField);
                    }
                    TargetField targetField = modelEvaluator.findTargetField(targetFieldName);
                    if (targetField == null) {
                        throw new MissingFieldException(targetFieldName, (PMMLObject)outputField);
                    }
                    value = OutputUtil.getPredictedDisplayValue(targetValue, targetField);
                    break;
                }
                case TRANSFORMED_VALUE: 
                case DECISION: {
                    if (segmentId != null) {
                        String name = outputField.getValue();
                        if (name == null) {
                            throw new MissingAttributeException((PMMLObject)outputField, PMMLAttributes.OUTPUTFIELD_VALUE);
                        }
                        Expression expression = outputField.getExpression();
                        if (expression != null) {
                            throw new MisplacedElementException((PMMLObject)expression);
                        }
                        value = segmentPredictions.get(FieldName.create((String)name));
                        break;
                    }
                    value = FieldValueUtil.getValue(ExpressionUtil.evaluateExpressionContainer(outputField, context));
                    break;
                }
                case PROBABILITY: {
                    value = OutputUtil.getProbability(targetValue, outputField);
                    break;
                }
                case RESIDUAL: {
                    if (segmentId != null) {
                        throw new UnsupportedElementException((PMMLObject)outputField);
                    }
                    FieldValue expectedTargetValue = context.evaluate(targetFieldName);
                    if (Objects.equals(FieldValues.MISSING_VALUE, expectedTargetValue)) {
                        throw new MissingValueException(targetFieldName, (PMMLObject)outputField);
                    }
                    TargetField targetField = modelEvaluator.findTargetField(targetFieldName);
                    if (targetField == null) {
                        throw new MissingFieldException(targetFieldName, (PMMLObject)outputField);
                    }
                    OpType opType = targetField.getOpType();
                    switch (opType) {
                        case CONTINUOUS: {
                            value = OutputUtil.getContinuousResidual(targetValue, expectedTargetValue);
                            break block3;
                        }
                        case CATEGORICAL: 
                        case ORDINAL: {
                            value = OutputUtil.getDiscreteResidual(targetValue, expectedTargetValue);
                            break block3;
                        }
                    }
                    throw new InvalidElementException((PMMLObject)outputField);
                }
                case CLUSTER_ID: {
                    value = OutputUtil.getClusterId(targetValue);
                    break;
                }
                case ENTITY_ID: {
                    if (targetValue instanceof HasRuleValues) {
                        value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.RULE_ID);
                        break;
                    }
                    value = OutputUtil.getEntityId(targetValue, outputField);
                    break;
                }
                case AFFINITY: {
                    value = OutputUtil.getAffinity(targetValue, outputField);
                    break;
                }
                case CLUSTER_AFFINITY: 
                case ENTITY_AFFINITY: {
                    String entityId = outputField.getValue();
                    if (entityId != null) {
                        value = OutputUtil.getAffinity(targetValue, outputField);
                        break;
                    }
                    value = OutputUtil.getEntityAffinity(targetValue);
                    break;
                }
                case REASON_CODE: {
                    value = OutputUtil.getReasonCode(targetValue, outputField);
                    break;
                }
                case RULE_VALUE: {
                    value = OutputUtil.getRuleValue(targetValue, outputField);
                    break;
                }
                case ANTECEDENT: {
                    value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.ANTECEDENT);
                    break;
                }
                case CONSEQUENT: {
                    value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.CONSEQUENT);
                    break;
                }
                case RULE: {
                    value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.RULE);
                    break;
                }
                case RULE_ID: {
                    value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.RULE_ID);
                    break;
                }
                case CONFIDENCE: {
                    value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.CONFIDENCE);
                    break;
                }
                case SUPPORT: {
                    value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.SUPPORT);
                    break;
                }
                case LIFT: {
                    value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.LIFT);
                    break;
                }
                case LEVERAGE: {
                    value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.LEVERAGE);
                    break;
                }
                case REPORT: {
                    FieldName reportFieldName = outputField.getReportField();
                    if (reportFieldName == null) {
                        throw new MissingAttributeException((PMMLObject)outputField, PMMLAttributes.OUTPUTFIELD_REPORTFIELD);
                    }
                    OutputField reportOutputField = modelEvaluator.getOutputField(reportFieldName);
                    if (reportOutputField == null) {
                        throw new MissingFieldException(reportFieldName);
                    }
                    value = OutputUtil.getReport(targetValue, reportOutputField);
                    break;
                }
                case WARNING: {
                    value = context.getWarnings();
                    break;
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)outputField, (Enum<?>)resultFeature);
                }
            }
            FieldValue outputValue = FieldValueUtil.create(outputField, value);
            context.declare(outputField.getName(), outputValue);
            result.put(outputField.getName(), FieldValueUtil.getValue(outputValue));
        }
        return result;
    }

    private static Object getPredictedValue(Object object) {
        return EvaluatorUtil.decode(object);
    }

    private static Object getPredictedDisplayValue(Object object, TargetField targetField) {
        String displayValue;
        TargetValue targetValue;
        if (object instanceof HasDisplayValue) {
            HasDisplayValue hasDisplayValue = TypeUtil.cast(HasDisplayValue.class, object);
            return hasDisplayValue.getDisplayValue();
        }
        object = OutputUtil.getPredictedValue(object);
        Target target = targetField.getTarget();
        if (target != null && (targetValue = TargetUtil.getTargetValue(target, object)) != null && (displayValue = targetValue.getDisplayValue()) != null) {
            return displayValue;
        }
        OpType opType = targetField.getOpType();
        switch (opType) {
            case CONTINUOUS: {
                break;
            }
            case CATEGORICAL: 
            case ORDINAL: {
                String displayValue2;
                Value value = FieldValueUtil.getValidValue(targetField, object);
                if (value == null || (displayValue2 = value.getDisplayValue()) == null) break;
                return displayValue2;
            }
            default: {
                DataField dataField = targetField.getDataField();
                throw new UnsupportedAttributeException((PMMLObject)dataField, (Enum<?>)opType);
            }
        }
        return object;
    }

    private static Double getProbability(Object object, OutputField outputField) {
        HasProbability hasProbability = TypeUtil.cast(HasProbability.class, object);
        String value = OutputUtil.getCategoryValue(object, outputField);
        return hasProbability.getProbability(value);
    }

    private static String getCategoryValue(Object object, OutputField outputField) {
        String value = outputField.getValue();
        if (value == null) {
            return (String)TypeUtil.cast(DataType.STRING, OutputUtil.getPredictedValue(object));
        }
        return value;
    }

    private static Double getContinuousResidual(Object object, FieldValue expectedObject) {
        Number value = (Number)OutputUtil.getPredictedValue(object);
        Number expectedValue = (Number)FieldValueUtil.getValue(expectedObject);
        return expectedValue.doubleValue() - value.doubleValue();
    }

    public static Double getDiscreteResidual(Object object, FieldValue expectedObject) {
        String expectedValue;
        HasProbability hasProbability = TypeUtil.cast(HasProbability.class, object);
        String value = (String)TypeUtil.cast(DataType.STRING, OutputUtil.getPredictedValue(object));
        boolean equals = value.equals(expectedValue = (String)TypeUtil.cast(DataType.STRING, FieldValueUtil.getValue(expectedObject)));
        return (equals ? 1.0 : 0.0) - hasProbability.getProbability(value);
    }

    private static String getClusterId(Object object) {
        HasEntityId hasEntityId = TypeUtil.cast(HasEntityId.class, object);
        return hasEntityId.getEntityId();
    }

    private static String getEntityId(Object object, OutputField outputField) {
        HasEntityId hasEntityId = TypeUtil.cast(HasEntityId.class, object);
        int rank = outputField.getRank();
        if (rank <= 0) {
            throw new InvalidAttributeException((PMMLObject)outputField, PMMLAttributes.OUTPUTFIELD_RANK, rank);
        }
        if (rank > 1) {
            HasEntityIdRanking hasEntityIdRanking = TypeUtil.cast(HasEntityIdRanking.class, object);
            OutputField.RankOrder rankOrder = outputField.getRankOrder();
            switch (rankOrder) {
                case DESCENDING: {
                    break;
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)outputField, (Enum<?>)rankOrder);
                }
            }
            return OutputUtil.getElement(hasEntityIdRanking.getEntityIdRanking(), rank);
        }
        return hasEntityId.getEntityId();
    }

    public static Double getAffinity(Object object, OutputField outputField) {
        HasAffinity hasAffinity = TypeUtil.cast(HasAffinity.class, object);
        int rank = outputField.getRank();
        if (rank <= 0) {
            throw new InvalidAttributeException((PMMLObject)outputField, PMMLAttributes.OUTPUTFIELD_RANK, rank);
        }
        if (rank > 1) {
            HasAffinityRanking hasAffinityRanking = TypeUtil.cast(HasAffinityRanking.class, object);
            OutputField.RankOrder rankOrder = outputField.getRankOrder();
            switch (rankOrder) {
                case DESCENDING: {
                    break;
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)outputField, (Enum<?>)rankOrder);
                }
            }
            return OutputUtil.getElement(hasAffinityRanking.getAffinityRanking(), rank);
        }
        String value = OutputUtil.getCategoryValue(object, outputField);
        return hasAffinity.getAffinity(value);
    }

    public static Double getEntityAffinity(Object object) {
        HasEntityAffinity hasEntityAffinity = TypeUtil.cast(HasEntityAffinity.class, object);
        return hasEntityAffinity.getEntityAffinity();
    }

    public static String getReasonCode(Object object, OutputField outputField) {
        HasReasonCodeRanking hasReasonCodeRanking = TypeUtil.cast(HasReasonCodeRanking.class, object);
        int rank = outputField.getRank();
        if (rank <= 0) {
            throw new InvalidAttributeException((PMMLObject)outputField, PMMLAttributes.OUTPUTFIELD_RANK, rank);
        }
        return OutputUtil.getElement(hasReasonCodeRanking.getReasonCodeRanking(), rank);
    }

    public static Object getRuleValue(Object object, OutputField outputField) {
        return OutputUtil.getRuleValue(object, outputField, outputField.getRuleFeature());
    }

    public static Object getRuleValue(Object object, OutputField outputField, OutputField.RuleFeature ruleFeature) {
        HasRuleValues hasRuleValues = TypeUtil.cast(HasRuleValues.class, object);
        List<AssociationRule> associationRules = OutputUtil.getRuleValues(hasRuleValues, outputField);
        String isMultiValued = outputField.getIsMultiValued();
        if ("0".equals(isMultiValued)) {
            int rank = outputField.getRank();
            if (rank <= 0) {
                throw new InvalidAttributeException((PMMLObject)outputField, PMMLAttributes.OUTPUTFIELD_RANK, rank);
            }
            AssociationRule associationRule = OutputUtil.getElement(associationRules, rank);
            if (associationRule != null) {
                return OutputUtil.getRuleFeature(hasRuleValues, associationRule, outputField, ruleFeature);
            }
            return null;
        }
        if ("1".equals(isMultiValued)) {
            int rank = outputField.getRank();
            if (rank < 0) {
                throw new InvalidAttributeException((PMMLObject)outputField, PMMLAttributes.OUTPUTFIELD_RANK, rank);
            }
            int size = rank == 0 ? associationRules.size() : Math.min(rank, associationRules.size());
            associationRules = associationRules.subList(0, size);
            ArrayList<Object> result = new ArrayList<Object>(associationRules.size());
            for (AssociationRule associationRule : associationRules) {
                result.add(OutputUtil.getRuleFeature(hasRuleValues, associationRule, outputField, ruleFeature));
            }
            return result;
        }
        throw new InvalidAttributeException((PMMLObject)outputField, PMMLAttributes.OUTPUTFIELD_ISMULTIVALUED, isMultiValued);
    }

    public static String getReport(Object object, OutputField outputField) {
        Report report = null;
        ResultFeature resultFeature = outputField.getResultFeature();
        switch (resultFeature) {
            case PREDICTED_VALUE: {
                HasPrediction hasPrediction;
                try {
                    hasPrediction = TypeUtil.cast(HasPrediction.class, object);
                }
                catch (TypeCheckException tce) {
                    return null;
                }
                report = hasPrediction.getPredictionReport();
                break;
            }
            case PROBABILITY: {
                HasProbability hasProbability = TypeUtil.cast(HasProbability.class, object);
                String value = OutputUtil.getCategoryValue(object, outputField);
                report = hasProbability.getProbabilityReport(value);
                break;
            }
            case AFFINITY: {
                HasAffinity hasAffinity = TypeUtil.cast(HasAffinity.class, object);
                String value = OutputUtil.getCategoryValue(object, outputField);
                report = hasAffinity.getAffinityReport(value);
                break;
            }
        }
        return ReportUtil.format(report);
    }

    private static List<AssociationRule> getRuleValues(HasRuleValues hasRuleValues, final OutputField outputField) {
        List<AssociationRule> associationRules;
        OutputField.Algorithm algorithm = outputField.getAlgorithm();
        switch (algorithm) {
            case RECOMMENDATION: 
            case EXCLUSIVE_RECOMMENDATION: 
            case RULE_ASSOCIATION: {
                associationRules = hasRuleValues.getRuleValues(algorithm);
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)outputField, (Enum<?>)algorithm);
            }
        }
        Comparator<AssociationRule> comparator = new Comparator<AssociationRule>(){
            private OutputField.RankBasis rankBasis;
            private OutputField.RankOrder rankOrder;
            {
                this.rankBasis = outputField.getRankBasis();
                this.rankOrder = outputField.getRankOrder();
            }

            @Override
            public int compare(AssociationRule left, AssociationRule right) {
                int order;
                switch (this.rankBasis) {
                    case CONFIDENCE: {
                        order = this.getConfidence(left).compareTo(this.getConfidence(right));
                        break;
                    }
                    case SUPPORT: {
                        order = this.getSupport(left).compareTo(this.getSupport(right));
                        break;
                    }
                    case LIFT: {
                        order = this.getLift(left).compareTo(this.getLift(right));
                        break;
                    }
                    case LEVERAGE: {
                        order = this.getLeverage(left).compareTo(this.getLeverage(right));
                        break;
                    }
                    case AFFINITY: {
                        order = this.getAffinity(left).compareTo(this.getAffinity(right));
                        break;
                    }
                    default: {
                        throw new UnsupportedAttributeException((PMMLObject)outputField, (Enum<?>)this.rankBasis);
                    }
                }
                switch (this.rankOrder) {
                    case ASCENDING: {
                        return order;
                    }
                    case DESCENDING: {
                        return -order;
                    }
                }
                throw new UnsupportedAttributeException((PMMLObject)outputField, (Enum<?>)this.rankOrder);
            }

            private Double getConfidence(AssociationRule associationRule) {
                return associationRule.getConfidence();
            }

            private Double getSupport(AssociationRule associationRule) {
                return associationRule.getSupport();
            }

            private Double getLift(AssociationRule associationRule) {
                Double lift = associationRule.getLift();
                if (lift == null) {
                    throw new MissingAttributeException((PMMLObject)associationRule, PMMLAttributes.ASSOCIATIONRULE_LIFT);
                }
                return lift;
            }

            private Double getLeverage(AssociationRule associationRule) {
                Double leverage = associationRule.getLeverage();
                if (leverage == null) {
                    throw new MissingAttributeException((PMMLObject)associationRule, PMMLAttributes.ASSOCIATIONRULE_LEVERAGE);
                }
                return leverage;
            }

            private Double getAffinity(AssociationRule associationRule) {
                Double affinity = associationRule.getAffinity();
                if (affinity == null) {
                    throw new MissingAttributeException((PMMLObject)associationRule, PMMLAttributes.ASSOCIATIONRULE_AFFINITY);
                }
                return affinity;
            }
        };
        Ordering ordering = Ordering.from((Comparator)comparator);
        return ordering.sortedCopy(associationRules);
    }

    private static Object getRuleFeature(HasRuleValues hasRuleValues, AssociationRule associationRule, OutputField outputField, OutputField.RuleFeature ruleFeature) {
        switch (ruleFeature) {
            case ANTECEDENT: {
                return OutputUtil.getItemValues(hasRuleValues, associationRule.getAntecedent());
            }
            case CONSEQUENT: {
                return OutputUtil.getItemValues(hasRuleValues, associationRule.getConsequent());
            }
            case RULE: {
                Joiner joiner = Joiner.on((char)',');
                StringBuilder sb = new StringBuilder();
                String left = joiner.join(OutputUtil.getItemValues(hasRuleValues, associationRule.getAntecedent()));
                sb.append('{').append(left).append('}');
                sb.append("->");
                String right = joiner.join(OutputUtil.getItemValues(hasRuleValues, associationRule.getConsequent()));
                sb.append('{').append(right).append('}');
                return sb.toString();
            }
            case RULE_ID: {
                HasEntityRegistry hasEntityRegistry = (HasEntityRegistry)((Object)hasRuleValues);
                return EntityUtil.getId(associationRule, hasEntityRegistry);
            }
            case CONFIDENCE: {
                return associationRule.getConfidence();
            }
            case SUPPORT: {
                return associationRule.getSupport();
            }
            case LIFT: {
                return associationRule.getLift();
            }
            case LEVERAGE: {
                return associationRule.getLeverage();
            }
            case AFFINITY: {
                return associationRule.getAffinity();
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)outputField, (Enum<?>)ruleFeature);
    }

    private static List<String> getItemValues(HasRuleValues hasRuleValues, String id) {
        Map<String, Item> items = hasRuleValues.getItems();
        Map<String, Itemset> itemsets = hasRuleValues.getItemsets();
        Itemset itemset = itemsets.get(id);
        List itemRefs = itemset.getItemRefs();
        ArrayList<String> result = new ArrayList<String>(itemRefs.size());
        int max = itemRefs.size();
        for (int i = 0; i < max; ++i) {
            ItemRef itemRef = (ItemRef)itemRefs.get(i);
            Item item = items.get(itemRef.getItemRef());
            result.add(item.getValue());
        }
        return result;
    }

    private static <E> E getElement(List<E> elements, int rank) {
        int index = rank - 1;
        if (index < elements.size()) {
            return elements.get(index);
        }
        return null;
    }
}

