/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Target;
import org.dmg.pmml.TargetValue;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.HasReport;
import org.jpmml.evaluator.InvalidElementException;
import org.jpmml.evaluator.InvalidElementListException;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.PMMLAttributes;
import org.jpmml.evaluator.ProbabilityDistribution;
import org.jpmml.evaluator.Regression;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UndefinedResultException;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.Vote;

public class TargetUtil {
    private TargetUtil() {
    }

    public static <V extends Number> Map<FieldName, ?> evaluateRegressionDefault(ValueFactory<V> valueFactory, TargetField targetField) {
        Value<V> value;
        Target target = targetField.getTarget();
        if (target != null && target.hasTargetValues() && (value = TargetUtil.getDefaultValue(valueFactory, target)) != null) {
            return TargetUtil.evaluateRegression(targetField, value);
        }
        return Collections.singletonMap(targetField.getName(), null);
    }

    public static <V extends Number> Map<FieldName, ?> evaluateRegression(TargetField targetField, Value<V> value) {
        DataField dataField = targetField.getDataField();
        if ((value = TargetUtil.evaluateRegressionInternal(targetField, value)) instanceof HasReport) {
            Regression<V> result = new Regression<V>(value);
            return TargetUtil.evaluateRegression(targetField, result);
        }
        Object result = TypeUtil.cast(dataField.getDataType(), value.getValue());
        return Collections.singletonMap(targetField.getName(), result);
    }

    public static <V extends Number> Map<FieldName, ? extends Regression<V>> evaluateRegression(TargetField targetField, Regression<V> regression) {
        DataField dataField = targetField.getDataField();
        regression.computeResult(dataField.getDataType());
        return Collections.singletonMap(targetField.getName(), regression);
    }

    public static <V extends Number> Value<V> evaluateRegressionInternal(TargetField targetField, Value<V> value) {
        Target target = targetField.getTarget();
        if (target != null) {
            return TargetUtil.processValue(target, value);
        }
        return value;
    }

    public static Map<FieldName, ? extends Vote> evaluateVote(TargetField targetField, Vote vote) {
        DataField dataField = targetField.getDataField();
        vote.computeResult(dataField.getDataType());
        return Collections.singletonMap(targetField.getName(), vote);
    }

    public static <V extends Number> Map<FieldName, ? extends Classification<V>> evaluateClassificationDefault(ValueFactory<V> valueFactory, TargetField targetField) {
        ProbabilityDistribution<V> result;
        Target target = targetField.getTarget();
        if (target != null && target.hasTargetValues() && (result = TargetUtil.getPriorProbabilities(valueFactory, target)) != null) {
            return TargetUtil.evaluateClassification(targetField, result);
        }
        return Collections.singletonMap(targetField.getName(), null);
    }

    public static <V extends Number> Map<FieldName, ? extends Classification<V>> evaluateClassification(TargetField targetField, Classification<V> classification) {
        DataField dataField = targetField.getDataField();
        classification.computeResult(dataField.getDataType());
        return Collections.singletonMap(targetField.getName(), classification);
    }

    public static <V extends Number> Value<V> processValue(Target target, Value<V> value) {
        Target.CastInteger castInteger;
        double rescaleConstant;
        double rescaleFactor;
        Double min = target.getMin();
        Double max = target.getMax();
        if (min != null || max != null) {
            value.restrict(min != null ? min : Double.NEGATIVE_INFINITY, max != null ? max : Double.POSITIVE_INFINITY);
        }
        if ((rescaleFactor = target.getRescaleFactor().doubleValue()) != 1.0) {
            value.multiply(rescaleFactor);
        }
        if ((rescaleConstant = target.getRescaleConstant().doubleValue()) != 0.0) {
            value.add(rescaleConstant);
        }
        if ((castInteger = target.getCastInteger()) == null) {
            return value;
        }
        switch (castInteger) {
            case ROUND: {
                return value.round();
            }
            case CEILING: {
                return value.ceiling();
            }
            case FLOOR: {
                return value.floor();
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)target, (Enum<?>)castInteger);
    }

    public static TargetValue getTargetValue(Target target, Object value) {
        DataType dataType = TypeUtil.getDataType(value);
        List targetValues = target.getTargetValues();
        for (TargetValue targetValue : targetValues) {
            String stringValue = targetValue.getValue();
            if (stringValue == null) {
                throw new MissingAttributeException((PMMLObject)targetValue, PMMLAttributes.TARGETVALUE_VALUE);
            }
            if (!value.equals(TypeUtil.parse(dataType, stringValue))) continue;
            return targetValue;
        }
        return null;
    }

    private static <V extends Number> Value<V> getDefaultValue(ValueFactory<V> valueFactory, Target target) {
        if (!target.hasTargetValues()) {
            return null;
        }
        List targetValues = target.getTargetValues();
        if (targetValues.size() != 1) {
            throw new InvalidElementListException(targetValues);
        }
        TargetValue targetValue = (TargetValue)targetValues.get(0);
        Double defaultValue = targetValue.getDefaultValue();
        if (targetValue.getValue() != null || targetValue.getPriorProbability() != null) {
            throw new InvalidElementException((PMMLObject)targetValue);
        }
        if (defaultValue == null) {
            return null;
        }
        return valueFactory.newValue(defaultValue);
    }

    private static <V extends Number> ProbabilityDistribution<V> getPriorProbabilities(ValueFactory<V> valueFactory, Target target) {
        if (!target.hasTargetValues()) {
            return null;
        }
        ValueMap<String, Value<V>> values = new ValueMap<String, Value<V>>();
        Value<V> sum = valueFactory.newValue();
        List targetValues = target.getTargetValues();
        for (TargetValue targetValue : targetValues) {
            String targetCategory = targetValue.getValue();
            if (targetCategory == null) {
                throw new MissingAttributeException((PMMLObject)targetValue, PMMLAttributes.TARGETVALUE_VALUE);
            }
            Double probability = targetValue.getPriorProbability();
            if (probability == null) {
                throw new MissingAttributeException((PMMLObject)targetValue, PMMLAttributes.TARGETVALUE_PRIORPROBABILITY);
            }
            if (targetValue.getDefaultValue() != null) {
                throw new InvalidElementException((PMMLObject)targetValue);
            }
            Value<V> value = valueFactory.newValue(probability);
            values.put(targetCategory, value);
            sum.add(value);
        }
        if (!sum.equals(1.0)) {
            if (sum.equals(0.0)) {
                throw new UndefinedResultException();
            }
            for (Value value : values) {
                value.divide(sum);
            }
        }
        return new ProbabilityDistribution(values);
    }
}

