/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.functions;

import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.FieldValues;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UndefinedResultException;
import org.jpmml.evaluator.functions.AbstractFunction;

public abstract class ArithmeticFunction
extends AbstractFunction {
    public ArithmeticFunction(String name) {
        super(name);
    }

    public abstract Number evaluate(Number var1, Number var2);

    @Override
    public FieldValue evaluate(List<FieldValue> arguments) {
        Number result;
        this.checkArguments(arguments, 2, true);
        FieldValue left = arguments.get(0);
        FieldValue right = arguments.get(1);
        if (left == null || right == null) {
            return FieldValues.MISSING_VALUE;
        }
        DataType dataType = TypeUtil.getResultDataType(left.getDataType(), right.getDataType());
        try {
            result = this.evaluate(left.asNumber(), right.asNumber());
        }
        catch (ArithmeticException ae) {
            throw new UndefinedResultException().initCause(ae);
        }
        return FieldValueUtil.create(dataType, OpType.CONTINUOUS, result);
    }
}

