/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.dmg.pmml.Array;
import org.dmg.pmml.MatCell;
import org.dmg.pmml.Matrix;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.ArrayUtil;
import org.jpmml.evaluator.InvalidElementException;
import org.jpmml.evaluator.UnsupportedAttributeException;

public class MatrixUtil {
    private static final Comparator<MatCell> rowComparator = new Comparator<MatCell>(){

        @Override
        public int compare(MatCell left, MatCell right) {
            return left.getRow() - right.getRow();
        }
    };
    private static final Comparator<MatCell> columnComparator = new Comparator<MatCell>(){

        @Override
        public int compare(MatCell left, MatCell right) {
            return left.getCol() - right.getCol();
        }
    };

    private MatrixUtil() {
    }

    public static Number getElementAt(Matrix matrix, int row, int column) {
        List arrays = matrix.getArrays();
        List matCells = matrix.getMatCells();
        Matrix.Kind kind = matrix.getKind();
        switch (kind) {
            case DIAGONAL: {
                if (arrays.size() != 1) break;
                Array array = (Array)arrays.get(0);
                List<? extends Number> elements = ArrayUtil.asNumberList(array);
                if (row == column) {
                    return elements.get(row - 1);
                }
                int min = 1;
                int max = elements.size();
                if (row < min || row > max || column < min || column > max) {
                    throw new IndexOutOfBoundsException();
                }
                return matrix.getOffDiagDefault();
            }
            case SYMMETRIC: {
                if (arrays.size() <= 0) break;
                if (column > row) {
                    int temp = row;
                    row = column;
                    column = temp;
                }
                return MatrixUtil.getArrayValue(arrays, row, column);
            }
            case ANY: {
                if (arrays.size() > 0) {
                    return MatrixUtil.getArrayValue(arrays, row, column);
                }
                if (matCells.size() <= 0) break;
                if (row < 1 || column < 1) {
                    throw new IndexOutOfBoundsException();
                }
                Number value = MatrixUtil.getMatCellValue(matCells, row, column);
                if (value == null) {
                    if (row == column) {
                        return matrix.getDiagDefault();
                    }
                    return matrix.getOffDiagDefault();
                }
                return value;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)matrix, (Enum<?>)kind);
            }
        }
        throw new InvalidElementException((PMMLObject)matrix);
    }

    private static Number getArrayValue(List<Array> arrays, int row, int column) {
        Array array = arrays.get(row - 1);
        List<? extends Number> elements = ArrayUtil.asNumberList(array);
        return elements.get(column - 1);
    }

    private static Number getMatCellValue(List<MatCell> matCells, final int row, final int column) {
        Predicate<MatCell> filter = new Predicate<MatCell>(){

            public boolean apply(MatCell matCell) {
                return matCell.getRow() == row && matCell.getCol() == column;
            }
        };
        MatCell matCell = (MatCell)Iterables.getFirst((Iterable)Iterables.filter(matCells, (Predicate)filter), null);
        if (matCell != null) {
            return Double.parseDouble(matCell.getValue());
        }
        return null;
    }

    public static int getRows(Matrix matrix) {
        Integer nbRows = matrix.getNbRows();
        if (nbRows != null) {
            return nbRows;
        }
        List arrays = matrix.getArrays();
        List matCells = matrix.getMatCells();
        Matrix.Kind kind = matrix.getKind();
        switch (kind) {
            case DIAGONAL: {
                if (arrays.size() != 1) break;
                Array array = (Array)arrays.get(0);
                return ArrayUtil.getSize(array);
            }
            case SYMMETRIC: {
                if (arrays.size() <= 0) break;
                return arrays.size();
            }
            case ANY: {
                if (arrays.size() > 0) {
                    return arrays.size();
                }
                if (matCells.size() <= 0) break;
                MatCell matCell = Collections.max(matCells, rowComparator);
                return matCell.getRow();
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)matrix, (Enum<?>)kind);
            }
        }
        throw new InvalidElementException((PMMLObject)matrix);
    }

    public static int getColumns(Matrix matrix) {
        Integer nbCols = matrix.getNbCols();
        if (nbCols != null) {
            return nbCols;
        }
        List arrays = matrix.getArrays();
        List matCells = matrix.getMatCells();
        Matrix.Kind kind = matrix.getKind();
        switch (kind) {
            case DIAGONAL: {
                if (arrays.size() != 1) break;
                Array array = (Array)arrays.get(0);
                return ArrayUtil.getSize(array);
            }
            case SYMMETRIC: {
                if (arrays.size() <= 0) break;
                return arrays.size();
            }
            case ANY: {
                if (arrays.size() > 0) {
                    Array array = (Array)arrays.get(arrays.size() - 1);
                    return ArrayUtil.getSize(array);
                }
                if (matCells.size() <= 0) break;
                MatCell matCell = Collections.max(matCells, columnComparator);
                return matCell.getCol();
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)matrix, (Enum<?>)kind);
            }
        }
        throw new InvalidElementException((PMMLObject)matrix);
    }
}

