/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.scorecard;

import java.util.List;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.HasReasonCodeRanking;
import org.jpmml.evaluator.Regression;
import org.jpmml.evaluator.ToStringHelper;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueMap;

public class ReasonCodeRanking<V extends Number>
extends Regression<V>
implements HasReasonCodeRanking {
    private ValueMap<String, V> reasonCodePoints = null;

    ReasonCodeRanking(Value<V> value, ValueMap<String, V> reasonCodePoints) {
        super(value);
        this.setReasonCodePoints(reasonCodePoints);
    }

    @Override
    protected ToStringHelper toStringHelper() {
        ValueMap<String, V> reasonCodePoints = this.getReasonCodePoints();
        ToStringHelper helper = super.toStringHelper().add(Classification.Type.VOTE.entryKey(), reasonCodePoints.entrySet()).add("reasonCodeRanking", this.getReasonCodeRanking());
        return helper;
    }

    @Override
    public List<String> getReasonCodeRanking() {
        ValueMap<String, V> reasonCodePoints = this.getReasonCodePoints();
        return Classification.entryKeys(Classification.getWinnerList(Classification.Type.VOTE, reasonCodePoints.entrySet()));
    }

    public ValueMap<String, V> getReasonCodePoints() {
        return this.reasonCodePoints;
    }

    private void setReasonCodePoints(ValueMap<String, V> reasonCodePoints) {
        if (reasonCodePoints == null) {
            throw new IllegalArgumentException();
        }
        this.reasonCodePoints = reasonCodePoints;
    }
}

