/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.tree;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.EmbeddedModel;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.InvalidAttributeException;
import org.jpmml.evaluator.MisplacedAttributeException;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.PMMLAttributes;
import org.jpmml.evaluator.PMMLElements;
import org.jpmml.evaluator.PredicateUtil;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.UndefinedResultException;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.UnsupportedElementException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.tree.NodeScore;
import org.jpmml.evaluator.tree.NodeScoreDistribution;
import org.jpmml.evaluator.tree.NodeVote;

public class TreeModelEvaluator
extends ModelEvaluator<TreeModel>
implements HasEntityRegistry<Node> {
    private transient BiMap<String, Node> entityRegistry = null;
    private static final LoadingCache<TreeModel, BiMap<String, Node>> entityCache = CacheUtil.buildLoadingCache(new CacheLoader<TreeModel, BiMap<String, Node>>(){

        public BiMap<String, Node> load(TreeModel treeModel) {
            ImmutableBiMap.Builder<String, Node> builder = new ImmutableBiMap.Builder<String, Node>();
            builder = this.collectNodes(treeModel.getNode(), new AtomicInteger(1), builder);
            return builder.build();
        }

        private ImmutableBiMap.Builder<String, Node> collectNodes(Node node, AtomicInteger index, ImmutableBiMap.Builder<String, Node> builder) {
            builder = EntityUtil.put(node, index, builder);
            if (!node.hasNodes()) {
                return builder;
            }
            List children = node.getNodes();
            for (Node child : children) {
                builder = this.collectNodes(child, index, builder);
            }
            return builder;
        }
    });

    public TreeModelEvaluator(PMML pmml) {
        this(pmml, TreeModelEvaluator.selectModel(pmml, TreeModel.class));
    }

    public TreeModelEvaluator(PMML pmml, TreeModel treeModel) {
        super(pmml, treeModel);
        Node root = treeModel.getNode();
        if (root == null) {
            throw new MissingElementException((PMMLObject)treeModel, PMMLElements.TREEMODEL_NODE);
        }
    }

    @Override
    public String getSummary() {
        return "Tree model";
    }

    @Override
    public BiMap<String, Node> getEntityRegistry() {
        if (this.entityRegistry == null) {
            this.entityRegistry = this.getValue(entityCache);
        }
        return this.entityRegistry;
    }

    @Override
    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        Map<FieldName, ?> predictions;
        ValueFactory<?> valueFactory;
        TreeModel treeModel = (TreeModel)this.ensureScorableModel();
        MathContext mathContext = treeModel.getMathContext();
        switch (mathContext) {
            case FLOAT: 
            case DOUBLE: {
                valueFactory = this.ensureValueFactory();
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)treeModel, (Enum<?>)mathContext);
            }
        }
        MiningFunction miningFunction = treeModel.getMiningFunction();
        switch (miningFunction) {
            case REGRESSION: {
                predictions = this.evaluateRegression(valueFactory, context);
                break;
            }
            case CLASSIFICATION: {
                predictions = this.evaluateClassification(valueFactory, context);
                break;
            }
            case ASSOCIATION_RULES: 
            case SEQUENCES: 
            case CLUSTERING: 
            case TIME_SERIES: 
            case MIXED: {
                throw new InvalidAttributeException((PMMLObject)treeModel, (Enum<?>)miningFunction);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)treeModel, (Enum<?>)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private <V extends Number> Map<FieldName, ?> evaluateRegression(ValueFactory<V> valueFactory, EvaluationContext context) {
        TargetField targetField = this.getTargetField();
        Trail trail = new Trail();
        Node node = this.evaluateTree(trail, context);
        if (node == null) {
            return TargetUtil.evaluateRegressionDefault(valueFactory, targetField);
        }
        NodeScore<V> result = this.createNodeScore(valueFactory, targetField, node);
        return TargetUtil.evaluateRegression(targetField, result);
    }

    private <V extends Number> Map<FieldName, ?> evaluateClassification(ValueFactory<V> valueFactory, EvaluationContext context) {
        TreeModel treeModel = (TreeModel)this.getModel();
        TargetField targetField = this.getTargetField();
        Trail trail = new Trail();
        Node node = this.evaluateTree(trail, context);
        if (node == null) {
            return TargetUtil.evaluateClassificationDefault(valueFactory, targetField);
        }
        if (!node.hasScoreDistributions()) {
            NodeVote result = this.createNodeVote(node);
            return TargetUtil.evaluateVote(targetField, result);
        }
        double missingValuePenalty = 1.0;
        int missingLevels = trail.getMissingLevels();
        if (missingLevels > 0) {
            missingValuePenalty = Math.pow(treeModel.getMissingValuePenalty(), missingLevels);
        }
        NodeScoreDistribution<V> result = this.createNodeScoreDistribution(valueFactory, node, missingValuePenalty);
        return TargetUtil.evaluateClassification(targetField, result);
    }

    private Node evaluateTree(Trail trail, EvaluationContext context) {
        TreeModel treeModel = (TreeModel)this.getModel();
        Node root = treeModel.getNode();
        Boolean status = this.evaluateNode(trail, root, context);
        if (status != null && status.booleanValue()) {
            Node node = (trail = this.handleTrue(trail, root, context)).getResult();
            if (node != null && !node.hasScore()) {
                throw new MissingAttributeException((PMMLObject)node, PMMLAttributes.NODE_SCORE);
            }
            return node;
        }
        return null;
    }

    private Boolean evaluateNode(Trail trail, Node node, EvaluationContext context) {
        EmbeddedModel embeddedModel = node.getEmbeddedModel();
        if (embeddedModel != null) {
            throw new UnsupportedElementException((PMMLObject)embeddedModel);
        }
        Predicate predicate = PredicateUtil.ensurePredicate(node);
        if (predicate instanceof CompoundPredicate) {
            CompoundPredicate compoundPredicate = (CompoundPredicate)predicate;
            PredicateUtil.CompoundPredicateResult result = PredicateUtil.evaluateCompoundPredicateInternal(compoundPredicate, context);
            if (result.isAlternative()) {
                trail.addMissingLevel();
            }
            return result.getResult();
        }
        return PredicateUtil.evaluate(predicate, context);
    }

    private Trail handleTrue(Trail trail, Node node, EvaluationContext context) {
        if (!node.hasNodes()) {
            return trail.selectNode(node);
        }
        trail.push(node);
        List children = node.getNodes();
        int max = children.size();
        for (int i = 0; i < max; ++i) {
            Node child = (Node)children.get(i);
            Boolean status = this.evaluateNode(trail, child, context);
            if (status == null) {
                Trail destination = this.handleMissingValue(trail, node, child, context);
                if (destination == null) continue;
                return destination;
            }
            if (!status.booleanValue()) continue;
            return this.handleTrue(trail, child, context);
        }
        return this.handleNoTrueChild(trail);
    }

    private Trail handleDefaultChild(Trail trail, Node node, EvaluationContext context) {
        String defaultChild = node.getDefaultChild();
        if (defaultChild == null) {
            throw new MissingAttributeException((PMMLObject)node, PMMLAttributes.NODE_DEFAULTCHILD);
        }
        trail.addMissingLevel();
        List children = node.getNodes();
        int max = children.size();
        for (int i = 0; i < max; ++i) {
            Node child = (Node)children.get(i);
            String id = child.getId();
            if (id == null || !id.equals(defaultChild)) continue;
            return this.handleTrue(trail, child, context);
        }
        throw new InvalidAttributeException((PMMLObject)node, PMMLAttributes.NODE_DEFAULTCHILD, defaultChild);
    }

    private Trail handleNoTrueChild(Trail trail) {
        TreeModel treeModel = (TreeModel)this.getModel();
        TreeModel.NoTrueChildStrategy noTrueChildStrategy = treeModel.getNoTrueChildStrategy();
        switch (noTrueChildStrategy) {
            case RETURN_NULL_PREDICTION: {
                return trail.selectNull();
            }
            case RETURN_LAST_PREDICTION: {
                Node lastPrediction = trail.getLastPrediction();
                if (lastPrediction.hasScore()) {
                    return trail.selectLastPrediction();
                }
                return trail.selectNull();
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)treeModel, (Enum<?>)noTrueChildStrategy);
    }

    private Trail handleMissingValue(Trail trail, Node parent, Node node, EvaluationContext context) {
        TreeModel treeModel = (TreeModel)this.getModel();
        TreeModel.MissingValueStrategy missingValueStrategy = treeModel.getMissingValueStrategy();
        switch (missingValueStrategy) {
            case NULL_PREDICTION: {
                return trail.selectNull();
            }
            case LAST_PREDICTION: {
                return trail.selectLastPrediction();
            }
            case DEFAULT_CHILD: {
                return this.handleDefaultChild(trail, parent, context);
            }
            case NONE: {
                return null;
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)treeModel, (Enum<?>)missingValueStrategy);
    }

    private <V extends Number> NodeScore<V> createNodeScore(ValueFactory<V> valueFactory, TargetField targetField, Node node) {
        Value<V> value = valueFactory.newValue(node.getScore());
        value = TargetUtil.evaluateRegressionInternal(targetField, value);
        NodeScore result = new NodeScore<V>(value, node){

            @Override
            public BiMap<String, Node> getEntityRegistry() {
                return TreeModelEvaluator.this.getEntityRegistry();
            }
        };
        return result;
    }

    private NodeVote createNodeVote(Node node) {
        NodeVote result = new NodeVote(node){

            @Override
            public BiMap<String, Node> getEntityRegistry() {
                return TreeModelEvaluator.this.getEntityRegistry();
            }
        };
        return result;
    }

    private <V extends Number> NodeScoreDistribution<V> createNodeScoreDistribution(ValueFactory<V> valueFactory, Node node, double missingValuePenalty) {
        List scoreDistributions = node.getScoreDistributions();
        NodeScoreDistribution result = new NodeScoreDistribution<V>(new ValueMap(2 * scoreDistributions.size()), node){

            @Override
            public BiMap<String, Node> getEntityRegistry() {
                return TreeModelEvaluator.this.getEntityRegistry();
            }
        };
        Value<V> sum = valueFactory.newValue();
        boolean hasProbabilities = false;
        int max = scoreDistributions.size();
        for (int i = 0; i < max; ++i) {
            Value<V> value;
            ScoreDistribution scoreDistribution = (ScoreDistribution)scoreDistributions.get(i);
            Double probability = scoreDistribution.getProbability();
            if (i == 0) {
                boolean bl = hasProbabilities = probability != null;
            }
            if (hasProbabilities) {
                if (probability == null) {
                    throw new MissingAttributeException((PMMLObject)scoreDistribution, PMMLAttributes.SCOREDISTRIBUTION_PROBABILITY);
                }
                if (probability < 0.0 || probability > 1.0) {
                    throw new InvalidAttributeException((PMMLObject)scoreDistribution, PMMLAttributes.SCOREDISTRIBUTION_PROBABILITY, probability);
                }
                sum.add(probability);
                value = valueFactory.newValue(probability);
            } else {
                if (probability != null) {
                    throw new MisplacedAttributeException((PMMLObject)scoreDistribution, PMMLAttributes.SCOREDISTRIBUTION_PROBABILITY, probability);
                }
                double recordCount = scoreDistribution.getRecordCount();
                if (recordCount != 0.0) {
                    sum.add(recordCount);
                }
                value = valueFactory.newValue(recordCount);
            }
            result.put(scoreDistribution.getValue(), value);
            Double confidence = scoreDistribution.getConfidence();
            if (confidence == null) continue;
            value = valueFactory.newValue(confidence);
            if (missingValuePenalty != 1.0) {
                value.multiply(missingValuePenalty);
            }
            result.putConfidence(scoreDistribution.getValue(), value);
        }
        if (!sum.equals(1.0)) {
            ValueMap values = result.getValues();
            if (sum.equals(0.0)) {
                throw new UndefinedResultException();
            }
            for (Value value : values) {
                value.divide(sum);
            }
        }
        return result;
    }

    private static class Trail {
        private Node lastPrediction = null;
        private Node result = null;
        private int missingLevels = 0;

        public void push(Node node) {
            this.setLastPrediction(node);
        }

        public Trail selectNull() {
            this.setResult(null);
            return this;
        }

        public Trail selectNode(Node node) {
            this.setResult(node);
            return this;
        }

        public Trail selectLastPrediction() {
            this.setResult(this.getLastPrediction());
            return this;
        }

        public Node getResult() {
            return this.result;
        }

        private void setResult(Node result) {
            this.result = result;
        }

        public Node getLastPrediction() {
            if (this.lastPrediction == null) {
                throw new EvaluationException("Empty trail");
            }
            return this.lastPrediction;
        }

        private void setLastPrediction(Node lastPrediction) {
            this.lastPrediction = lastPrediction;
        }

        public void addMissingLevel() {
            this.setMissingLevels(this.getMissingLevels() + 1);
        }

        public int getMissingLevels() {
            return this.missingLevels;
        }

        private void setMissingLevels(int missingLevels) {
            this.missingLevels = missingLevels;
        }
    }
}

