/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jpmml.evaluator.Numbers;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.Vector;

public abstract class KeyValueAggregator<K, V extends Number> {
    private Map<K, Vector<V>> map = new LinkedHashMap<K, Vector<V>>();
    private int capacity = 0;

    public KeyValueAggregator(int capacity) {
        this.capacity = capacity;
    }

    public abstract ValueFactory<V> getValueFactory();

    public void add(K key) {
        this.add(key, Numbers.DOUBLE_ONE);
    }

    public void add(K key, Number value) {
        Vector<V> values = this.ensureVector(key);
        values.add(value);
    }

    public void add(K key, Number coefficient, Number factor) {
        Vector<V> values = this.ensureVector(key);
        if (coefficient.doubleValue() != 1.0) {
            values.add(coefficient, factor);
        } else {
            values.add(factor);
        }
    }

    public void clear() {
        this.map.clear();
    }

    protected Vector<V> get(K key) {
        return this.map.get(key);
    }

    protected Map<K, Value<V>> asTransformedMap(Function<Vector<V>, Value<V>> function) {
        return Maps.transformValues(this.map, function);
    }

    private Vector<V> ensureVector(K key) {
        Vector<V> values = this.map.get(key);
        if (values == null) {
            ValueFactory<V> valueFactory = this.getValueFactory();
            values = valueFactory.newVector(this.capacity);
            this.map.put(key, values);
        }
        return values;
    }
}

