/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Visitable;
import org.jpmml.evaluator.ModelEvaluatorBuilder;
import org.jpmml.evaluator.PMMLUtil;
import org.jpmml.model.JAXBUtil;
import org.jpmml.model.SAXUtil;
import org.jpmml.model.VisitorBattery;
import org.jpmml.model.filters.ImportFilter;
import org.jpmml.model.visitors.LocatorNullifier;
import org.jpmml.model.visitors.LocatorTransformer;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;

public class LoadingModelEvaluatorBuilder
extends ModelEvaluatorBuilder {
    private Schema schema = null;
    private ValidationEventHandler validationEventHandler = null;
    private List<? extends XMLFilter> filters = null;
    private boolean locatable = false;
    private VisitorBattery visitors = null;

    public LoadingModelEvaluatorBuilder load(File file) throws IOException, SAXException, JAXBException {
        try (FileInputStream is = new FileInputStream(file);){
            LoadingModelEvaluatorBuilder loadingModelEvaluatorBuilder = this.load(is);
            return loadingModelEvaluatorBuilder;
        }
    }

    public LoadingModelEvaluatorBuilder load(File file, String modelName) throws IOException, SAXException, JAXBException {
        try (FileInputStream is = new FileInputStream(file);){
            LoadingModelEvaluatorBuilder loadingModelEvaluatorBuilder = this.load(is, modelName);
            return loadingModelEvaluatorBuilder;
        }
    }

    public LoadingModelEvaluatorBuilder load(InputStream is) throws SAXException, JAXBException {
        return this.load(is, (String)null);
    }

    public LoadingModelEvaluatorBuilder load(InputStream is, String modelName) throws SAXException, JAXBException {
        Schema schema = this.getSchema();
        ValidationEventHandler validationEventHandler = this.getValidationEventHandler();
        List<? extends XMLFilter> filters = this.getFilters();
        boolean locatable = this.getLocatable();
        VisitorBattery visitors = this.getVisitors();
        Unmarshaller unmarshaller = JAXBUtil.createUnmarshaller();
        unmarshaller.setSchema(schema);
        unmarshaller.setEventHandler(validationEventHandler);
        if (filters == null) {
            filters = Collections.singletonList(new ImportFilter());
        }
        SAXSource source = SAXUtil.createFilteredSource((InputStream)is, (XMLFilter[])filters.toArray(new XMLFilter[filters.size()]));
        PMML pmml = (PMML)unmarshaller.unmarshal((Source)source);
        LocatorTransformer locatorHandler = locatable ? new LocatorTransformer() : new LocatorNullifier();
        locatorHandler.applyTo((Visitable)pmml);
        if (visitors != null && visitors.size() > 0) {
            visitors.applyTo((Visitable)pmml);
        }
        Model model = PMMLUtil.findModel(pmml, modelName);
        this.setPMML(pmml);
        this.setModel(model);
        return this;
    }

    @Override
    public LoadingModelEvaluatorBuilder clone() {
        return (LoadingModelEvaluatorBuilder)super.clone();
    }

    public Schema getSchema() {
        return this.schema;
    }

    public LoadingModelEvaluatorBuilder setSchema(Schema schema) {
        this.schema = schema;
        return this;
    }

    public ValidationEventHandler getValidationEventHandler() {
        return this.validationEventHandler;
    }

    public LoadingModelEvaluatorBuilder setValidationEventHandler(ValidationEventHandler validationEventHandler) {
        this.validationEventHandler = validationEventHandler;
        return this;
    }

    public List<? extends XMLFilter> getFilters() {
        return this.filters;
    }

    public LoadingModelEvaluatorBuilder setFilters(List<? extends XMLFilter> filters) {
        this.filters = filters;
        return this;
    }

    public boolean getLocatable() {
        return this.locatable;
    }

    public LoadingModelEvaluatorBuilder setLocatable(boolean locatable) {
        this.locatable = locatable;
        return this;
    }

    public VisitorBattery getVisitors() {
        return this.visitors;
    }

    public LoadingModelEvaluatorBuilder setVisitors(VisitorBattery visitors) {
        this.visitors = visitors;
        return this;
    }
}

