/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.jpmml.evaluator.Report;
import org.jpmml.evaluator.ReportingDoubleValue;
import org.jpmml.evaluator.SimpleDoubleVector;
import org.jpmml.evaluator.Value;

public abstract class ReportingSimpleDoubleVector
extends SimpleDoubleVector {
    private String expression = "";

    public ReportingSimpleDoubleVector() {
    }

    public ReportingSimpleDoubleVector(String expression) {
        if (expression != null) {
            this.report(expression);
        }
    }

    protected abstract Report newReport();

    @Override
    public ReportingSimpleDoubleVector add(Number value) {
        ReportingSimpleDoubleVector result = (ReportingSimpleDoubleVector)super.add(value);
        this.report(new StringBuilder(256).append(this.getExpression()).append("<cn>").append(value.doubleValue()).append("</cn>").toString());
        return result;
    }

    @Override
    public ReportingSimpleDoubleVector add(Value<? extends Number> value) {
        ReportingSimpleDoubleVector result = (ReportingSimpleDoubleVector)super.add((Value)value);
        this.report(new StringBuilder(256).append(this.getExpression()).append("<cn>").append(value.doubleValue()).append("</cn>").toString());
        return result;
    }

    @Override
    public ReportingSimpleDoubleVector add(Number coefficient, Number factor) {
        ReportingSimpleDoubleVector result = (ReportingSimpleDoubleVector)super.add(coefficient, factor);
        this.report(new StringBuilder(256).append(this.getExpression()).append("<apply><times/>").append("<cn>").append(coefficient.doubleValue()).append("</cn>").append("<cn>").append(factor.doubleValue()).append("</cn>").append("</apply>").toString());
        return result;
    }

    public ReportingDoubleValue get(int index) {
        return new ReportingDoubleValue(this.doubleValue(index), this.newReport());
    }

    public ReportingDoubleValue max() {
        return new ReportingDoubleValue(this.doubleMax(), this.newReport(), new StringBuilder(256).append("<apply><max/>").append(this.getExpression()).append("</apply>").toString());
    }

    public ReportingDoubleValue median() {
        return new ReportingDoubleValue(this.doubleMedian(), this.newReport(), new StringBuilder(256).append("<apply><median/>").append(this.getExpression()).append("</apply>").toString());
    }

    public ReportingDoubleValue sum() {
        return new ReportingDoubleValue(this.doubleSum(), this.newReport(), new StringBuilder(256).append("<apply><plus/>").append(this.getExpression()).append("</apply>").toString());
    }

    private void report(String expression) {
        this.setExpression(expression);
    }

    public String getExpression() {
        return this.expression;
    }

    private void setExpression(String expression) {
        this.expression = expression;
    }
}

