/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.support_vector_machine;

import java.util.Set;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.Report;
import org.jpmml.evaluator.ReportUtil;
import org.jpmml.evaluator.UndefinedResultException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.ValueUtil;

public class VoteDistribution<V extends Number>
extends Classification<V>
implements HasProbability {
    private Value<V> sum = null;

    VoteDistribution(ValueMap<String, V> votes) {
        super(Classification.Type.VOTE, votes);
    }

    @Override
    protected void computeResult(DataType dataType) {
        ValueMap values = this.getValues();
        super.computeResult(dataType);
        this.sum = ValueUtil.sum(values);
    }

    @Override
    public Set<String> getCategories() {
        return this.keySet();
    }

    @Override
    public Double getProbability(String category) {
        Value<V> probability = this.computeProbability(category);
        return Classification.Type.PROBABILITY.getValue(probability);
    }

    @Override
    public Report getProbabilityReport(String category) {
        Value<V> probability = this.computeProbability(category);
        return ReportUtil.getReport(probability);
    }

    private Value<V> computeProbability(String category) {
        ValueMap values = this.getValues();
        if (this.sum == null) {
            throw new EvaluationException("Vote distribution result has not been computed");
        }
        Value probability = (Value)values.get(category);
        if (probability != null) {
            probability = probability.copy();
            if (this.sum.isZero()) {
                throw new UndefinedResultException();
            }
            probability.divide(this.sum);
        }
        return probability;
    }
}

