/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.DuplicateValueException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.MissingValueException;
import org.jpmml.evaluator.ScalarValue;
import org.jpmml.evaluator.SymbolTable;

public abstract class EvaluationContext {
    private Map<FieldName, FieldValue> values = new HashMap<FieldName, FieldValue>();
    private FieldName[] indexedNames = null;
    private FieldValue[] indexedValues = null;
    private List<String> warnings = null;
    private static final FieldValue UNDECLARED_VALUE = new ScalarValue(DataType.DOUBLE, Double.NaN){

        @Override
        public OpType getOpType() {
            return OpType.CONTINUOUS;
        }
    };
    public static final ThreadLocal<SymbolTable<FieldName>> DERIVEDFIELD_GUARD_PROVIDER = new ThreadLocal<SymbolTable<FieldName>>(){

        @Override
        public SymbolTable<FieldName> initialValue() {
            return null;
        }
    };
    public static final ThreadLocal<SymbolTable<String>> FUNCTION_GUARD_PROVIDER = new ThreadLocal<SymbolTable<String>>(){

        @Override
        public SymbolTable<String> initialValue() {
            return null;
        }
    };

    EvaluationContext() {
    }

    protected abstract FieldValue prepare(FieldName var1, Object var2);

    protected void reset(boolean clearValues) {
        if (clearValues) {
            this.values.clear();
            this.indexedNames = null;
            this.indexedValues = null;
        }
        if (this.warnings != null) {
            this.warnings.clear();
        }
    }

    public void setIndex(List<FieldName> names) {
        if (names == null) {
            this.indexedNames = null;
            this.indexedValues = null;
            return;
        }
        this.indexedNames = names.toArray(new FieldName[names.size()]);
        this.indexedValues = new FieldValue[names.size()];
        Arrays.fill(this.indexedValues, UNDECLARED_VALUE);
    }

    public FieldValue lookup(FieldName name) {
        Map<FieldName, FieldValue> values = this.getValues();
        FieldValue value = values.getOrDefault(name, UNDECLARED_VALUE);
        if (value != UNDECLARED_VALUE) {
            return value;
        }
        throw new MissingValueException(name);
    }

    public FieldValue evaluate(FieldName name) {
        Map<FieldName, FieldValue> values = this.getValues();
        FieldValue value = values.getOrDefault(name, UNDECLARED_VALUE);
        if (value != UNDECLARED_VALUE) {
            return value;
        }
        return this.resolve(name);
    }

    public FieldValue evaluate(int index) {
        if (this.indexedNames == null) {
            throw new IllegalStateException();
        }
        FieldValue value = this.indexedValues[index];
        if (value == UNDECLARED_VALUE) {
            FieldName name = this.indexedNames[index];
            this.indexedValues[index] = value = this.evaluate(name);
        }
        return value;
    }

    public List<FieldValue> evaluateAll(List<FieldName> names) {
        ArrayList<FieldValue> values = new ArrayList<FieldValue>(names.size());
        for (FieldName name : names) {
            FieldValue value = this.evaluate(name);
            values.add(value);
        }
        return values;
    }

    protected FieldValue resolve(FieldName name) {
        throw new MissingFieldException(name);
    }

    public FieldValue declare(FieldName name, Object value) {
        if (value instanceof FieldValue) {
            return this.declare(name, (FieldValue)value);
        }
        value = this.prepare(name, value);
        return this.declare(name, (FieldValue)value);
    }

    public FieldValue declare(FieldName name, FieldValue value) {
        Map<FieldName, FieldValue> values = this.getValues();
        FieldValue prevValue = values.putIfAbsent(name, value);
        if (prevValue != null) {
            throw new DuplicateValueException(name);
        }
        return value;
    }

    public void declareAll(Map<FieldName, ?> values) {
        Set<Map.Entry<FieldName, ?>> entries = values.entrySet();
        for (Map.Entry entry : entries) {
            this.declare((FieldName)entry.getKey(), entry.getValue());
        }
    }

    protected DefineFunction getDefineFunction(String name) {
        throw new UnsupportedOperationException();
    }

    public void addWarning(String warning) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>();
        }
        this.warnings.add(warning);
    }

    public Map<FieldName, FieldValue> getValues() {
        return this.values;
    }

    public List<String> getWarnings() {
        if (this.warnings == null) {
            return Collections.emptyList();
        }
        return this.warnings;
    }
}

