/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.Cache;
import com.google.common.collect.Table;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Row;
import org.dmg.pmml.TextIndex;
import org.dmg.pmml.TextIndexNormalization;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.InlineTableUtil;
import org.jpmml.evaluator.InvalidAttributeException;
import org.jpmml.evaluator.InvalidElementException;
import org.jpmml.evaluator.LevenshteinDistanceUtil;
import org.jpmml.evaluator.PMMLException;
import org.jpmml.evaluator.RegExUtil;
import org.jpmml.evaluator.TextTokenizer;
import org.jpmml.evaluator.UnsupportedAttributeException;

public class TextUtil {
    private static final Cache<TextIndex, Cache<FieldValue, List<String>>> textTokenCaches = CacheUtil.buildCache();
    private static final Callable<Cache<FieldValue, List<String>>> textTokenCacheLoader = new Callable<Cache<FieldValue, List<String>>>(){

        @Override
        public Cache<FieldValue, List<String>> call() {
            return CacheUtil.buildCache();
        }
    };
    private static final Cache<TextIndex, Cache<FieldValue, List<String>>> termTokenCaches = CacheUtil.buildCache();
    private static final Callable<Cache<FieldValue, List<String>>> termTokenCacheLoader = new Callable<Cache<FieldValue, List<String>>>(){

        @Override
        public Cache<FieldValue, List<String>> call() {
            return CacheUtil.buildCache();
        }
    };

    private TextUtil() {
    }

    public static String normalize(TextIndex textIndex, String string) {
        if (textIndex.hasTextIndexNormalizations()) {
            List textIndexNormalizations = textIndex.getTextIndexNormalizations();
            for (TextIndexNormalization textIndexNormalization : textIndexNormalizations) {
                string = TextUtil.normalize(textIndex, textIndexNormalization, string);
            }
        }
        return string;
    }

    public static String normalize(TextIndex textIndex, TextIndexNormalization textIndexNormalization, String string) {
        InlineTable inlineTable;
        Integer maxLevenshteinDistance;
        Boolean caseSensitive;
        TextTokenizer tokenizer = null;
        Boolean tokenize = textIndexNormalization.isTokenize();
        if (tokenize == null) {
            tokenize = textIndex.isTokenize();
        }
        if (tokenize.booleanValue()) {
            TextIndexNormalization locatable = textIndexNormalization;
            String wordSeparatorCharacterRE = textIndexNormalization.getWordSeparatorCharacterRE();
            if (wordSeparatorCharacterRE == null) {
                locatable = textIndex;
                wordSeparatorCharacterRE = textIndex.getWordSeparatorCharacterRE();
            }
            Pattern pattern = RegExUtil.compile(wordSeparatorCharacterRE, (PMMLObject)locatable);
            tokenizer = new TextTokenizer(pattern);
        }
        if ((caseSensitive = textIndexNormalization.isCaseSensitive()) == null) {
            caseSensitive = textIndex.isCaseSensitive();
        }
        if ((maxLevenshteinDistance = textIndexNormalization.getMaxLevenshteinDistance()) == null) {
            maxLevenshteinDistance = textIndex.getMaxLevenshteinDistance();
            if (maxLevenshteinDistance < 0) {
                throw new InvalidAttributeException((PMMLObject)textIndex, PMMLAttributes.TEXTINDEX_MAXLEVENSHTEINDISTANCE, maxLevenshteinDistance);
            }
        } else if (maxLevenshteinDistance < 0) {
            throw new InvalidAttributeException((PMMLObject)textIndexNormalization, PMMLAttributes.TEXTINDEXNORMALIZATION_MAXLEVENSHTEINDISTANCE, maxLevenshteinDistance);
        }
        if ((inlineTable = InlineTableUtil.getInlineTable(textIndexNormalization)) != null) {
            String normalizedString;
            String inField = textIndexNormalization.getInField();
            String outField = textIndexNormalization.getOutField();
            String regexField = textIndexNormalization.getRegexField();
            while (true) {
                try {
                    normalizedString = TextUtil.normalize(inlineTable, inField, outField, regexField, string, tokenizer, caseSensitive, maxLevenshteinDistance);
                }
                catch (PMMLException pe) {
                    throw pe.ensureContext((PMMLObject)textIndexNormalization);
                }
                if (!textIndexNormalization.isRecursive() || normalizedString.equals(string)) break;
                string = normalizedString;
            }
            return normalizedString;
        }
        return string;
    }

    static String normalize(InlineTable inlineTable, String inColumn, String outColumn, String regexColumn, String string, TextTokenizer tokenizer, boolean caseSensitive, int maxLevenshteinDistance) {
        Table<Integer, String, Object> table = InlineTableUtil.getContent(inlineTable);
        int regexFlags = caseSensitive ? 0 : 66;
        List rows = inlineTable.getRows();
        for (int i = 0; i < rows.size(); ++i) {
            Matcher matcher;
            Pattern pattern;
            Row row = (Row)rows.get(i);
            Integer rowKey = i + 1;
            String inValue = (String)table.get((Object)rowKey, (Object)inColumn);
            if (inValue == null) {
                throw new InvalidElementException("Cell " + PMMLException.formatKey(inColumn) + " is not defined", (PMMLObject)row);
            }
            String outValue = (String)table.get((Object)rowKey, (Object)outColumn);
            if (outValue == null) {
                throw new InvalidElementException("Cell " + PMMLException.formatKey(outColumn) + " is not defined", (PMMLObject)row);
            }
            String regexValue = (String)table.get((Object)rowKey, (Object)regexColumn);
            boolean regex = "true".equalsIgnoreCase(regexValue);
            if (regex) {
                pattern = RegExUtil.compile(inValue, regexFlags, (PMMLObject)row);
                matcher = pattern.matcher(string);
                string = matcher.replaceAll(outValue);
                continue;
            }
            pattern = RegExUtil.compile(Pattern.quote(inValue), regexFlags, (PMMLObject)row);
            matcher = pattern.matcher(string);
            string = matcher.replaceAll(outValue);
        }
        return string;
    }

    public static List<String> tokenize(TextIndex textIndex, String text) {
        boolean tokenize = textIndex.isTokenize();
        if (tokenize) {
            String wordSeparatorCharacterRE = textIndex.getWordSeparatorCharacterRE();
            Pattern pattern = RegExUtil.compile(wordSeparatorCharacterRE, (PMMLObject)textIndex);
            TextTokenizer tokenizer = new TextTokenizer(pattern);
            return tokenizer.tokenize(text);
        }
        throw new UnsupportedAttributeException((PMMLObject)textIndex, PMMLAttributes.TEXTINDEX_TOKENIZE, tokenize);
    }

    public static int termFrequency(TextIndex textIndex, List<String> textTokens, List<String> termTokens) {
        int maxFrequency;
        boolean bestHits;
        if (textTokens.isEmpty() || termTokens.isEmpty()) {
            return 0;
        }
        boolean caseSensitive = textIndex.isCaseSensitive();
        int maxLevenshteinDistance = textIndex.getMaxLevenshteinDistance();
        if (maxLevenshteinDistance < 0) {
            throw new InvalidAttributeException((PMMLObject)textIndex, PMMLAttributes.TEXTINDEX_MAXLEVENSHTEINDISTANCE, maxLevenshteinDistance);
        }
        TextIndex.CountHits countHits = textIndex.getCountHits();
        switch (countHits) {
            case BEST_HITS: {
                bestHits = true;
                break;
            }
            case ALL_HITS: {
                bestHits = false;
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)textIndex, (Enum<?>)countHits);
            }
        }
        TextIndex.LocalTermWeights localTermWeights = textIndex.getLocalTermWeights();
        switch (localTermWeights) {
            case BINARY: {
                maxFrequency = 1;
                break;
            }
            case TERM_FREQUENCY: 
            case LOGARITHMIC: {
                maxFrequency = Integer.MAX_VALUE;
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)textIndex, (Enum<?>)localTermWeights);
            }
        }
        try {
            return TextUtil.termFrequency(textTokens, termTokens, caseSensitive, maxLevenshteinDistance, bestHits, maxFrequency);
        }
        catch (PMMLException pe) {
            throw pe.ensureContext((PMMLObject)textIndex);
        }
    }

    static int termFrequency(List<String> textTokens, List<String> termTokens, boolean caseSensitive, int maxLevenshteinDistance, boolean bestHits, int maxFrequency) {
        int frequency = 0;
        int bestLevenshteinDistance = Integer.MAX_VALUE;
        int textSize = textTokens.size();
        int termSize = termTokens.size();
        int max = textSize - termSize;
        block0: for (int i = 0; i <= max; ++i) {
            int levenshteinDistance = 0;
            for (int j = 0; j < termSize; ++j) {
                int threshold = maxLevenshteinDistance - levenshteinDistance;
                String textToken = textTokens.get(i + j);
                String termToken = termTokens.get(j);
                if (threshold == 0) {
                    boolean equals = caseSensitive ? textToken.equals(termToken) : textToken.equalsIgnoreCase(termToken);
                    if (equals) continue;
                    continue block0;
                }
                int tokenLevenshteinDistance = LevenshteinDistanceUtil.limitedCompare(textToken, termToken, caseSensitive, threshold);
                if (tokenLevenshteinDistance < 0) continue block0;
                levenshteinDistance += tokenLevenshteinDistance;
            }
            if (bestHits) {
                if (levenshteinDistance < bestLevenshteinDistance) {
                    frequency = 1;
                    bestLevenshteinDistance = levenshteinDistance;
                } else {
                    if (levenshteinDistance != bestLevenshteinDistance) continue;
                    ++frequency;
                }
                if (bestLevenshteinDistance != 0 || frequency < maxFrequency) continue;
                return frequency;
            }
            if (++frequency < maxFrequency) continue;
            return frequency;
        }
        return Math.min(maxFrequency, frequency);
    }

    static class TermProcessor
    extends StringProcessor {
        TermProcessor(TextIndex textIndex, FieldValue value) {
            super(textIndex, value);
        }

        @Override
        public List<String> process() {
            TextIndex textIndex = this.getTextIndex();
            FieldValue value = this.getValue();
            Cache termTokenCache = (Cache)CacheUtil.getValue(textIndex, termTokenCaches, termTokenCacheLoader);
            List<String> tokens = (List<String>)termTokenCache.getIfPresent((Object)value);
            if (tokens == null) {
                String string = value.asString();
                tokens = TextUtil.tokenize(textIndex, string);
                termTokenCache.put((Object)value, tokens);
            }
            return tokens;
        }
    }

    static class TextProcessor
    extends StringProcessor {
        TextProcessor(TextIndex textIndex, FieldValue value) {
            super(textIndex, value);
        }

        @Override
        public List<String> process() {
            TextIndex textIndex = this.getTextIndex();
            FieldValue value = this.getValue();
            Cache textTokenCache = (Cache)CacheUtil.getValue(textIndex, textTokenCaches, textTokenCacheLoader);
            List<String> tokens = (List<String>)textTokenCache.getIfPresent((Object)value);
            if (tokens == null) {
                String string = TextUtil.normalize(textIndex, value.asString());
                tokens = TextUtil.tokenize(textIndex, string);
                textTokenCache.put((Object)value, tokens);
            }
            return tokens;
        }
    }

    static abstract class StringProcessor {
        private TextIndex textIndex = null;
        private FieldValue value = null;

        public StringProcessor(TextIndex textIndex, FieldValue value) {
            this.setTextIndex(Objects.requireNonNull(textIndex));
            this.setValue(Objects.requireNonNull(value));
        }

        public abstract List<String> process();

        public TextIndex getTextIndex() {
            return this.textIndex;
        }

        private void setTextIndex(TextIndex textIndex) {
            this.textIndex = textIndex;
        }

        public FieldValue getValue() {
            return this.value;
        }

        private void setValue(FieldValue value) {
            this.value = value;
        }
    }
}

