/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.tree;

import java.util.Collections;
import java.util.Set;
import org.dmg.pmml.DataType;
import org.dmg.pmml.tree.Node;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.HasConfidence;
import org.jpmml.evaluator.HasEntityId;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.Report;
import org.jpmml.evaluator.ReportUtil;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.tree.HasDecisionPath;
import org.jpmml.model.ToStringHelper;

public abstract class NodeScoreDistribution<V extends Number>
extends Classification<V>
implements HasEntityId,
HasEntityRegistry<Node>,
HasDecisionPath,
HasProbability,
HasConfidence {
    private Node node = null;
    private ValueMap<String, V> confidences = null;

    NodeScoreDistribution(ValueMap<String, V> probabilities, Node node) {
        super(Classification.Type.PROBABILITY, probabilities);
        this.setNode(node);
    }

    @Override
    protected void computeResult(DataType dataType) {
        Node node = this.getNode();
        Object result = TypeUtil.parseOrCast(dataType, node.getScore());
        this.setResult(result);
    }

    @Override
    protected ToStringHelper toStringHelper() {
        ValueMap<String, V> confidences = this.getConfidences();
        ToStringHelper helper = super.toStringHelper().add("entityId", (Object)this.getEntityId()).add(Classification.Type.CONFIDENCE.entryKey(), confidences != null ? confidences.entrySet() : Collections.emptySet());
        return helper;
    }

    @Override
    public String getEntityId() {
        Node node = this.getNode();
        return EntityUtil.getId(node, this);
    }

    @Override
    public Set<String> getCategories() {
        return this.keySet();
    }

    @Override
    public Double getProbability(String category) {
        return this.getValue(category);
    }

    @Override
    public Report getProbabilityReport(String category) {
        return this.getValueReport(category);
    }

    @Override
    public Double getConfidence(String category) {
        ValueMap<String, V> confidences = this.getConfidences();
        Value confidence = confidences != null ? (Value)confidences.get(category) : null;
        return Classification.Type.CONFIDENCE.getValue(confidence);
    }

    @Override
    public Report getConfidenceReport(String category) {
        ValueMap<String, V> confidences = this.getConfidences();
        Value confidence = confidences != null ? (Value)confidences.get(category) : null;
        return ReportUtil.getReport(confidence);
    }

    void putConfidence(String category, Value<V> confidence) {
        ValueMap<String, Value<V>> confidences = this.getConfidences();
        if (confidences == null) {
            confidences = new ValueMap();
            this.setConfidences(confidences);
        }
        confidences.put(category, confidence);
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    private void setNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        this.node = node;
    }

    private ValueMap<String, V> getConfidences() {
        return this.confidences;
    }

    private void setConfidences(ValueMap<String, V> confidences) {
        if (confidences == null) {
            throw new IllegalArgumentException();
        }
        this.confidences = confidences;
    }
}

