/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.HasDataType;
import org.dmg.pmml.HasExpression;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.HasOpType;
import org.dmg.pmml.HasValue;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TextIndex;
import org.jpmml.evaluator.DiscretizationUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.FieldValues;
import org.jpmml.evaluator.FunctionUtil;
import org.jpmml.evaluator.Functions;
import org.jpmml.evaluator.HasParsedValue;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.JavaExpression;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.NormalizationUtil;
import org.jpmml.evaluator.PMMLAttributes;
import org.jpmml.evaluator.PMMLException;
import org.jpmml.evaluator.TextUtil;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.UnsupportedElementException;
import org.jpmml.evaluator.XPathUtil;

public class ExpressionUtil {
    private ExpressionUtil() {
    }

    public static <E extends Expression> FieldName ensureField(E hasField) {
        FieldName name = ((HasFieldReference)hasField).getField();
        if (name == null) {
            throw new MissingAttributeException(MissingAttributeException.formatMessage(XPathUtil.formatElement(hasField.getClass()) + "@field"), (PMMLObject)hasField);
        }
        return name;
    }

    public static <E extends PMMLObject> Expression ensureExpression(E hasExpression) {
        Expression expression = ((HasExpression)hasExpression).getExpression();
        if (expression == null) {
            throw new MissingElementException(MissingElementException.formatMessage(XPathUtil.formatElement(hasExpression.getClass()) + "/<Expression>"), hasExpression);
        }
        return expression;
    }

    public static <E extends PMMLObject & HasExpression<E>> FieldValue evaluateTypedExpressionContainer(E hasTypedExpression, EvaluationContext context) {
        FieldValue value = ExpressionUtil.evaluateExpressionContainer(hasTypedExpression, context);
        return FieldValueUtil.refine(((HasDataType)hasTypedExpression).getDataType(), ((HasOpType)hasTypedExpression).getOpType(), value);
    }

    public static <E extends PMMLObject> FieldValue evaluateExpressionContainer(E hasExpression, EvaluationContext context) {
        return ExpressionUtil.evaluate(ExpressionUtil.ensureExpression(hasExpression), context);
    }

    public static FieldValue evaluate(Expression expression, EvaluationContext context) {
        try {
            return ExpressionUtil.evaluateExpression(expression, context);
        }
        catch (PMMLException pe) {
            throw pe.ensureContext((PMMLObject)expression);
        }
    }

    static FieldValue evaluateExpression(Expression expression, EvaluationContext context) {
        if (expression instanceof Constant) {
            return ExpressionUtil.evaluateConstant((Constant)expression);
        }
        if (expression instanceof FieldRef) {
            return ExpressionUtil.evaluateFieldRef((FieldRef)expression, context);
        }
        if (expression instanceof NormContinuous) {
            return ExpressionUtil.evaluateNormContinuous((NormContinuous)expression, context);
        }
        if (expression instanceof NormDiscrete) {
            return ExpressionUtil.evaluateNormDiscrete((NormDiscrete)expression, context);
        }
        if (expression instanceof Discretize) {
            return ExpressionUtil.evaluateDiscretize((Discretize)expression, context);
        }
        if (expression instanceof MapValues) {
            return ExpressionUtil.evaluateMapValues((MapValues)expression, context);
        }
        if (expression instanceof TextIndex) {
            return ExpressionUtil.evaluateTextIndex((TextIndex)expression, context);
        }
        if (expression instanceof Apply) {
            return ExpressionUtil.evaluateApply((Apply)expression, context);
        }
        if (expression instanceof Aggregate) {
            return ExpressionUtil.evaluateAggregate((Aggregate)expression, context);
        }
        if (expression instanceof JavaExpression) {
            return ExpressionUtil.evaluateJavaExpression((JavaExpression)expression, context);
        }
        throw new UnsupportedElementException((PMMLObject)expression);
    }

    public static FieldValue evaluateConstant(Constant constant) {
        DataType dataType = ExpressionUtil.getConstantDataType(constant);
        OpType opType = TypeUtil.getOpType(dataType);
        if (constant instanceof HasParsedValue) {
            HasParsedValue hasParsedValue = (HasParsedValue)constant;
            return hasParsedValue.getValue(dataType, opType);
        }
        return FieldValueUtil.create(dataType, opType, constant.getValue());
    }

    public static FieldValue evaluateFieldRef(FieldRef fieldRef, EvaluationContext context) {
        FieldValue value = context.evaluate(ExpressionUtil.ensureField(fieldRef));
        if (Objects.equals(FieldValues.MISSING_VALUE, value)) {
            return FieldValueUtil.create(DataType.STRING, OpType.CATEGORICAL, fieldRef.getMapMissingTo());
        }
        return value;
    }

    public static FieldValue evaluateNormContinuous(NormContinuous normContinuous, EvaluationContext context) {
        FieldValue value = context.evaluate(ExpressionUtil.ensureField(normContinuous));
        if (Objects.equals(FieldValues.MISSING_VALUE, value)) {
            return FieldValueUtil.create(DataType.DOUBLE, OpType.CONTINUOUS, normContinuous.getMapMissingTo());
        }
        return NormalizationUtil.normalize(normContinuous, value);
    }

    public static FieldValue evaluateNormDiscrete(NormDiscrete normDiscrete, EvaluationContext context) {
        FieldValue value = context.evaluate(ExpressionUtil.ensureField(normDiscrete));
        if (Objects.equals(FieldValues.MISSING_VALUE, value)) {
            return FieldValueUtil.create(DataType.DOUBLE, OpType.CATEGORICAL, normDiscrete.getMapMissingTo());
        }
        NormDiscrete.Method method = normDiscrete.getMethod();
        switch (method) {
            case INDICATOR: {
                boolean equals = value.equals((HasValue<?>)normDiscrete);
                return equals ? FieldValues.CATEGORICAL_DOUBLE_ONE : FieldValues.CATEGORICAL_DOUBLE_ZERO;
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)normDiscrete, (Enum<?>)method);
    }

    public static FieldValue evaluateDiscretize(Discretize discretize, EvaluationContext context) {
        FieldValue value = context.evaluate(ExpressionUtil.ensureField(discretize));
        if (Objects.equals(FieldValues.MISSING_VALUE, value)) {
            return FieldValueUtil.create(ExpressionUtil.getDataType(discretize, DataType.STRING), OpType.CATEGORICAL, discretize.getMapMissingTo());
        }
        return DiscretizationUtil.discretize(discretize, value);
    }

    public static FieldValue evaluateMapValues(MapValues mapValues, EvaluationContext context) {
        LinkedHashMap<String, FieldValue> values = new LinkedHashMap<String, FieldValue>();
        List fieldColumnPairs = mapValues.getFieldColumnPairs();
        for (FieldColumnPair fieldColumnPair : fieldColumnPairs) {
            FieldName name = fieldColumnPair.getField();
            if (name == null) {
                throw new MissingAttributeException((PMMLObject)fieldColumnPair, PMMLAttributes.FIELDCOLUMNPAIR_FIELD);
            }
            String column = fieldColumnPair.getColumn();
            if (column == null) {
                throw new MissingAttributeException((PMMLObject)fieldColumnPair, PMMLAttributes.FIELDCOLUMNPAIR_COLUMN);
            }
            FieldValue value = context.evaluate(name);
            if (Objects.equals(FieldValues.MISSING_VALUE, value)) {
                return FieldValueUtil.create(ExpressionUtil.getDataType(mapValues, DataType.STRING), OpType.CATEGORICAL, mapValues.getMapMissingTo());
            }
            values.put(column, value);
        }
        return DiscretizationUtil.mapValue(mapValues, values);
    }

    public static FieldValue evaluateTextIndex(TextIndex textIndex, EvaluationContext context) {
        FieldName textName = textIndex.getTextField();
        if (textName == null) {
            throw new MissingAttributeException((PMMLObject)textIndex, PMMLAttributes.TEXTINDEX_TEXTFIELD);
        }
        FieldValue textValue = context.evaluate(textName);
        FieldValue termValue = ExpressionUtil.evaluateExpressionContainer(textIndex, context);
        if (Objects.equals(FieldValues.MISSING_VALUE, textIndex) || Objects.equals(FieldValues.MISSING_VALUE, termValue)) {
            return FieldValues.MISSING_VALUE;
        }
        TextUtil.TextProcessor textProcessor = new TextUtil.TextProcessor(textIndex, textValue);
        List<String> textTokens = textProcessor.process();
        TextUtil.TermProcessor termProcessor = new TextUtil.TermProcessor(textIndex, termValue);
        List<String> termTokens = termProcessor.process();
        int termFrequency = TextUtil.termFrequency(textIndex, textTokens, termTokens);
        TextIndex.LocalTermWeights localTermWeights = textIndex.getLocalTermWeights();
        switch (localTermWeights) {
            case BINARY: 
            case TERM_FREQUENCY: {
                return FieldValueUtil.create(DataType.INTEGER, OpType.CONTINUOUS, termFrequency);
            }
            case LOGARITHMIC: {
                return FieldValueUtil.create(DataType.DOUBLE, OpType.CONTINUOUS, Math.log10(1.0 + (double)termFrequency));
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)textIndex, (Enum<?>)localTermWeights);
    }

    public static FieldValue evaluateApply(Apply apply, EvaluationContext context) {
        FieldValue result;
        String mapMissingTo = apply.getMapMissingTo();
        List expressions = apply.getExpressions();
        ArrayList<FieldValue> values = new ArrayList<FieldValue>(expressions.size());
        Iterator arguments = expressions.iterator();
        String function = apply.getFunction();
        if ("if".equals(function) && arguments.hasNext()) {
            FieldValue flag = ExpressionUtil.evaluate((Expression)arguments.next(), context);
            if (flag == null && mapMissingTo != null) {
                return FieldValueUtil.create(DataType.STRING, OpType.CATEGORICAL, mapMissingTo);
            }
            values.add(flag);
            if (flag == null) {
                if (arguments.hasNext()) {
                    arguments.next();
                    values.add(FieldValues.MISSING_VALUE);
                    if (arguments.hasNext()) {
                        arguments.next();
                        values.add(FieldValues.MISSING_VALUE);
                    }
                }
            } else if (flag.asBoolean().booleanValue()) {
                if (arguments.hasNext()) {
                    FieldValue trueValue = ExpressionUtil.evaluate((Expression)arguments.next(), context);
                    if (Objects.equals(FieldValues.MISSING_VALUE, trueValue) && mapMissingTo != null) {
                        return FieldValueUtil.create(DataType.STRING, OpType.CATEGORICAL, mapMissingTo);
                    }
                    values.add(trueValue);
                    if (arguments.hasNext()) {
                        arguments.next();
                        values.add(FieldValues.MISSING_VALUE);
                    }
                }
            } else if (arguments.hasNext()) {
                arguments.next();
                values.add(FieldValues.MISSING_VALUE);
                if (arguments.hasNext()) {
                    FieldValue falseValue = ExpressionUtil.evaluate((Expression)arguments.next(), context);
                    if (Objects.equals(FieldValues.MISSING_VALUE, falseValue) && mapMissingTo != null) {
                        return FieldValueUtil.create(DataType.STRING, OpType.CATEGORICAL, mapMissingTo);
                    }
                    values.add(falseValue);
                }
            }
        }
        while (arguments.hasNext()) {
            FieldValue value = ExpressionUtil.evaluate((Expression)arguments.next(), context);
            if (Objects.equals(FieldValues.MISSING_VALUE, value) && mapMissingTo != null) {
                return FieldValueUtil.create(DataType.STRING, OpType.CATEGORICAL, mapMissingTo);
            }
            values.add(value);
        }
        String defaultValue = apply.getDefaultValue();
        try {
            result = FunctionUtil.evaluate(apply, values, context);
        }
        catch (InvalidResultException ire) {
            InvalidValueTreatmentMethod invalidValueTreatmentMethod = apply.getInvalidValueTreatment();
            switch (invalidValueTreatmentMethod) {
                case RETURN_INVALID: {
                    throw new InvalidResultException("Function application yielded an invalid result", (PMMLObject)apply).initCause(ire);
                }
                case AS_IS: {
                    throw ire;
                }
                case AS_MISSING: {
                    return FieldValueUtil.create(DataType.STRING, OpType.CATEGORICAL, defaultValue);
                }
            }
            throw new UnsupportedAttributeException((PMMLObject)apply, (Enum<?>)invalidValueTreatmentMethod);
        }
        if (result == null && defaultValue != null) {
            return FieldValueUtil.create(DataType.STRING, OpType.CATEGORICAL, defaultValue);
        }
        return result;
    }

    public static FieldValue evaluateAggregate(Aggregate aggregate, EvaluationContext context) {
        FieldValue value = context.evaluate(ExpressionUtil.ensureField(aggregate));
        Collection values = FieldValueUtil.getValue(Collection.class, value);
        FieldName groupName = aggregate.getGroupField();
        if (groupName != null) {
            FieldValue groupValue = context.evaluate(groupName);
            TypeUtil.getDataType(FieldValueUtil.getValue(groupValue));
        }
        values = values.stream().filter(Objects::nonNull).collect(Collectors.toList());
        Aggregate.Function function = aggregate.getFunction();
        if (function == null) {
            throw new MissingAttributeException((PMMLObject)aggregate, PMMLAttributes.AGGREGATE_FUNCTION);
        }
        switch (function) {
            case COUNT: {
                return FieldValueUtil.create(DataType.INTEGER, OpType.CONTINUOUS, values.size());
            }
            case SUM: {
                return Functions.SUM.evaluate(FieldValueUtil.createAll(value.getDataType(), value.getOpType(), (List)values));
            }
            case AVERAGE: {
                return Functions.AVG.evaluate(FieldValueUtil.createAll(value.getDataType(), value.getOpType(), (List)values));
            }
            case MIN: {
                return FieldValueUtil.create(value.getDataType(), value.getOpType(), Collections.min((List)values));
            }
            case MAX: {
                return FieldValueUtil.create(value.getDataType(), value.getOpType(), Collections.max((List)values));
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)aggregate, (Enum<?>)function);
    }

    public static FieldValue evaluateJavaExpression(JavaExpression javaExpression, EvaluationContext context) {
        FieldValue value = javaExpression.evaluate(context);
        return value;
    }

    public static DataType getConstantDataType(Constant constant) {
        DataType dataType = constant.getDataType();
        if (dataType == null) {
            dataType = TypeUtil.getConstantDataType(constant.getValue());
        }
        return dataType;
    }

    public static <E extends Expression> DataType getDataType(E expression, DataType defaultDataType) {
        DataType dataType = ((HasDataType)expression).getDataType();
        if (dataType != null) {
            return dataType;
        }
        return defaultDataType;
    }
}

