/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.io.Serializable;
import java.util.Objects;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.association.AssociationModel;
import org.dmg.pmml.clustering.ClusteringModel;
import org.dmg.pmml.general_regression.GeneralRegressionModel;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.naive_bayes.NaiveBayesModel;
import org.dmg.pmml.nearest_neighbor.NearestNeighborModel;
import org.dmg.pmml.neural_network.NeuralNetwork;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.rule_set.RuleSetModel;
import org.dmg.pmml.scorecard.Scorecard;
import org.dmg.pmml.support_vector_machine.SupportVectorMachineModel;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.evaluator.JavaModel;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.PMMLUtil;
import org.jpmml.evaluator.UnsupportedElementException;
import org.jpmml.evaluator.ValueFactoryFactory;
import org.jpmml.evaluator.association.AssociationModelEvaluator;
import org.jpmml.evaluator.clustering.ClusteringModelEvaluator;
import org.jpmml.evaluator.general_regression.GeneralRegressionModelEvaluator;
import org.jpmml.evaluator.java.JavaModelEvaluator;
import org.jpmml.evaluator.mining.MiningModelEvaluator;
import org.jpmml.evaluator.naive_bayes.NaiveBayesModelEvaluator;
import org.jpmml.evaluator.nearest_neighbor.NearestNeighborModelEvaluator;
import org.jpmml.evaluator.neural_network.NeuralNetworkEvaluator;
import org.jpmml.evaluator.regression.RegressionModelEvaluator;
import org.jpmml.evaluator.rule_set.RuleSetModelEvaluator;
import org.jpmml.evaluator.scorecard.ScorecardEvaluator;
import org.jpmml.evaluator.support_vector_machine.SupportVectorMachineModelEvaluator;
import org.jpmml.evaluator.tree.TreeModelEvaluator;

public class ModelEvaluatorFactory
implements Serializable {
    private ValueFactoryFactory valueFactoryFactory = null;

    protected ModelEvaluatorFactory() {
    }

    public ModelEvaluator<? extends Model> newModelEvaluator(PMML pmml) {
        return this.newModelEvaluator(pmml, (String)null);
    }

    public ModelEvaluator<? extends Model> newModelEvaluator(PMML pmml, String modelName) {
        Model model = modelName != null ? PMMLUtil.findModel(pmml, object -> Objects.equals(object.getModelName(), modelName), "<Model>@modelName=" + modelName) : PMMLUtil.findModel(pmml, object -> object.isScorable(), "<Model>@isScorable=true");
        return this.newModelEvaluator(pmml, model);
    }

    public ModelEvaluator<? extends Model> newModelEvaluator(PMML pmml, Model model) {
        ModelEvaluator<? extends Model> modelEvaluator = this.createModelEvaluator(pmml, model);
        modelEvaluator.configure(this);
        return modelEvaluator;
    }

    private ModelEvaluator<? extends Model> createModelEvaluator(PMML pmml, Model model) {
        if (model instanceof AssociationModel) {
            return new AssociationModelEvaluator(pmml, (AssociationModel)model);
        }
        if (model instanceof ClusteringModel) {
            return new ClusteringModelEvaluator(pmml, (ClusteringModel)model);
        }
        if (model instanceof GeneralRegressionModel) {
            return new GeneralRegressionModelEvaluator(pmml, (GeneralRegressionModel)model);
        }
        if (model instanceof MiningModel) {
            return new MiningModelEvaluator(pmml, (MiningModel)model);
        }
        if (model instanceof NaiveBayesModel) {
            return new NaiveBayesModelEvaluator(pmml, (NaiveBayesModel)model);
        }
        if (model instanceof NearestNeighborModel) {
            return new NearestNeighborModelEvaluator(pmml, (NearestNeighborModel)model);
        }
        if (model instanceof NeuralNetwork) {
            return new NeuralNetworkEvaluator(pmml, (NeuralNetwork)model);
        }
        if (model instanceof RegressionModel) {
            return new RegressionModelEvaluator(pmml, (RegressionModel)model);
        }
        if (model instanceof RuleSetModel) {
            return new RuleSetModelEvaluator(pmml, (RuleSetModel)model);
        }
        if (model instanceof Scorecard) {
            return new ScorecardEvaluator(pmml, (Scorecard)model);
        }
        if (model instanceof SupportVectorMachineModel) {
            return new SupportVectorMachineModelEvaluator(pmml, (SupportVectorMachineModel)model);
        }
        if (model instanceof TreeModel) {
            return new TreeModelEvaluator(pmml, (TreeModel)model);
        }
        if (model instanceof JavaModel) {
            return new JavaModelEvaluator(pmml, (JavaModel)model);
        }
        throw new UnsupportedElementException((PMMLObject)model);
    }

    public ValueFactoryFactory getValueFactoryFactory() {
        return this.valueFactoryFactory;
    }

    public void setValueFactoryFactory(ValueFactoryFactory valueFactoryFactory) {
        this.valueFactoryFactory = valueFactoryFactory;
    }

    public static ModelEvaluatorFactory newInstance() {
        return new ModelEvaluatorFactory();
    }
}

