/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.functions;

import java.util.List;
import java.util.Objects;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValues;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.FunctionException;

public abstract class AbstractFunction
implements Function {
    private String name = null;

    public AbstractFunction(String name) {
        this.setName(Objects.requireNonNull(name));
    }

    protected void checkFixedArityArguments(List<FieldValue> arguments, int arity) {
        if (arguments.size() != arity) {
            throw new FunctionException(this, "Expected " + arity + " values, got " + arguments.size() + " values");
        }
    }

    protected void checkVariableArityArguments(List<FieldValue> arguments, int minArity) {
        if (arguments.size() < minArity) {
            throw new FunctionException(this, "Expected " + minArity + " or more values, got " + arguments.size() + " values");
        }
    }

    protected void checkVariableArityArguments(List<FieldValue> arguments, int minArity, int maxArity) {
        if (arguments.size() < minArity || arguments.size() > maxArity) {
            throw new FunctionException(this, "Expected " + minArity + " to " + maxArity + " values, got " + arguments.size() + " values");
        }
    }

    protected FieldValue getOptionalArgument(List<FieldValue> arguments, int index) {
        return this.getOptionalArgument(arguments, index, null);
    }

    protected FieldValue getOptionalArgument(List<FieldValue> arguments, int index, String alias) {
        FieldValue argument = arguments.get(index);
        return this.checkArgument(argument, index, alias);
    }

    protected FieldValue getRequiredArgument(List<FieldValue> arguments, int index) {
        return this.getRequiredArgument(arguments, index, null);
    }

    protected FieldValue getRequiredArgument(List<FieldValue> arguments, int index, String alias) {
        FieldValue argument = arguments.get(index);
        if (Objects.equals(FieldValues.MISSING_VALUE, argument)) {
            if (alias != null) {
                throw new FunctionException(this, "Missing '" + alias + "' value at position " + index);
            }
            throw new FunctionException(this, "Missing value at position " + index);
        }
        return this.checkArgument(argument, index, alias);
    }

    protected FieldValue checkArgument(FieldValue argument, int index, String alias) {
        return argument;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }
}

