/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Lists;
import com.google.common.collect.RangeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasDiscreteDomain;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MissingValueTreatmentMethod;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutlierTreatmentMethod;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Target;
import org.dmg.pmml.Value;
import org.jpmml.evaluator.CategoricalValue;
import org.jpmml.evaluator.ContinuousValue;
import org.jpmml.evaluator.FieldUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValues;
import org.jpmml.evaluator.HasParsedValueMapping;
import org.jpmml.evaluator.InvalidElementException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.MisplacedAttributeException;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.OrdinalValue;
import org.jpmml.evaluator.PMMLAttributes;
import org.jpmml.evaluator.PMMLException;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.XPathUtil;

public class FieldValueUtil {
    private FieldValueUtil() {
    }

    public static FieldValue prepareInputValue(Field<?> field, MiningField miningField, Object value) {
        if (Objects.equals(FieldValues.MISSING_VALUE, value) || value == null) {
            return FieldValueUtil.performMissingValueTreatment(field, miningField);
        }
        if (value instanceof Collection) {
            Collection rawValues = (Collection)value;
            ArrayList<Object> pmmlValues = new ArrayList<Object>(rawValues.size());
            for (Object rawValue : rawValues) {
                FieldValue fieldValue = FieldValueUtil.prepareScalarInputValue(field, miningField, rawValue);
                pmmlValues.add(FieldValueUtil.getValue(fieldValue));
            }
            return FieldValueUtil.createInputValue(field, miningField, pmmlValues);
        }
        return FieldValueUtil.prepareScalarInputValue(field, miningField, value);
    }

    public static FieldValue prepareResidualInputValue(DataField dataField, MiningField miningField, Object value) {
        return FieldValueUtil.prepareInputValue(dataField, miningField, value);
    }

    private static FieldValue prepareScalarInputValue(Field<?> field, MiningField miningField, Object value) {
        boolean compatible;
        try {
            value = FieldValueUtil.createInputValue(field, miningField, value);
            compatible = true;
        }
        catch (IllegalArgumentException | TypeCheckException e) {
            compatible = false;
        }
        Value.Property status = FieldValueUtil.getStatus(field, miningField, value, compatible);
        switch (status) {
            case VALID: {
                return FieldValueUtil.performValidValueTreatment(field, miningField, (FieldValue)value);
            }
            case INVALID: {
                return FieldValueUtil.performInvalidValueTreatment(field, miningField, value);
            }
            case MISSING: {
                return FieldValueUtil.performMissingValueTreatment(field, miningField);
            }
        }
        throw new IllegalArgumentException();
    }

    public static FieldValue performValidValueTreatment(Field<?> field, MiningField miningField, FieldValue value) {
        OutlierTreatmentMethod outlierTreatmentMethod = miningField.getOutlierTreatment();
        switch (outlierTreatmentMethod) {
            case AS_IS: {
                return FieldValueUtil.createInputValue(field, miningField, value);
            }
            case AS_MISSING_VALUES: 
            case AS_EXTREME_VALUES: {
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)miningField, (Enum<?>)outlierTreatmentMethod);
            }
        }
        Double lowValue = miningField.getLowValue();
        Double highValue = miningField.getHighValue();
        if (lowValue == null && highValue == null) {
            throw new MissingAttributeException((PMMLObject)miningField, PMMLAttributes.MININGFIELD_LOWVALUE);
        }
        if (lowValue != null && highValue != null && lowValue.compareTo(highValue) > 0) {
            throw new InvalidElementException((PMMLObject)miningField);
        }
        if (Objects.equals(FieldValues.MISSING_VALUE, value)) {
            throw new TypeCheckException(Number.class, null);
        }
        Number numberValue = value.asNumber();
        switch (outlierTreatmentMethod) {
            case AS_MISSING_VALUES: {
                if (lowValue != null && numberValue.doubleValue() < lowValue) {
                    return FieldValueUtil.createMissingInputValue(field, miningField);
                }
                if (highValue == null || !(numberValue.doubleValue() > highValue)) break;
                return FieldValueUtil.createMissingInputValue(field, miningField);
            }
            case AS_EXTREME_VALUES: {
                if (lowValue != null && numberValue.doubleValue() < lowValue) {
                    return FieldValueUtil.createInputValue(field, miningField, lowValue);
                }
                if (highValue == null || !(numberValue.doubleValue() > highValue)) break;
                return FieldValueUtil.createInputValue(field, miningField, highValue);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)miningField, (Enum<?>)outlierTreatmentMethod);
            }
        }
        return FieldValueUtil.createInputValue(field, miningField, value);
    }

    public static FieldValue performInvalidValueTreatment(Field<?> field, MiningField miningField, Object value) {
        InvalidValueTreatmentMethod invalidValueTreatmentMethod = miningField.getInvalidValueTreatment();
        String invalidValueReplacement = miningField.getInvalidValueReplacement();
        switch (invalidValueTreatmentMethod) {
            case AS_IS: {
                break;
            }
            case AS_MISSING: 
            case RETURN_INVALID: {
                if (invalidValueReplacement == null) break;
                throw new MisplacedAttributeException((PMMLObject)miningField, PMMLAttributes.MININGFIELD_INVALIDVALUEREPLACEMENT, invalidValueReplacement);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)miningField, (Enum<?>)invalidValueTreatmentMethod);
            }
        }
        switch (invalidValueTreatmentMethod) {
            case RETURN_INVALID: {
                throw new InvalidResultException("Field " + PMMLException.formatKey(field.getName()) + " cannot accept user input value " + PMMLException.formatValue(value), (PMMLObject)miningField);
            }
            case AS_IS: {
                if (invalidValueReplacement != null) {
                    return FieldValueUtil.createInputValue(field, miningField, invalidValueReplacement);
                }
                return FieldValueUtil.createInputValue(field, miningField, value);
            }
            case AS_MISSING: {
                return FieldValueUtil.createMissingInputValue(field, miningField);
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)miningField, (Enum<?>)invalidValueTreatmentMethod);
    }

    public static FieldValue performMissingValueTreatment(Field<?> field, MiningField miningField) {
        MissingValueTreatmentMethod missingValueTreatmentMethod = miningField.getMissingValueTreatment();
        String missingValueReplacement = miningField.getMissingValueReplacement();
        if (missingValueTreatmentMethod == null) {
            missingValueTreatmentMethod = MissingValueTreatmentMethod.AS_IS;
        }
        switch (missingValueTreatmentMethod) {
            case AS_IS: 
            case AS_MEAN: 
            case AS_MODE: 
            case AS_MEDIAN: 
            case AS_VALUE: {
                return FieldValueUtil.createMissingInputValue(field, miningField);
            }
            case RETURN_INVALID: {
                if (missingValueReplacement != null) {
                    throw new MisplacedAttributeException((PMMLObject)miningField, PMMLAttributes.MININGFIELD_MISSINGVALUEREPLACEMENT, missingValueReplacement);
                }
                throw new InvalidResultException("Field " + PMMLException.formatKey(field.getName()) + " requires user input value", (PMMLObject)miningField);
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)miningField, (Enum<?>)missingValueTreatmentMethod);
    }

    static OpType getOpType(Field<?> field, MiningField miningField) {
        OpType opType = field.getOpType();
        if (miningField != null) {
            opType = FieldValueUtil.firstNonNull(miningField.getOpType(), opType);
        }
        return opType;
    }

    static OpType getOpType(Field<?> field, MiningField miningField, Target target) {
        OpType opType = field.getOpType();
        if (miningField != null) {
            opType = FieldValueUtil.firstNonNull(miningField.getOpType(), opType);
            if (target != null) {
                opType = FieldValueUtil.firstNonNull(target.getOpType(), opType);
            }
        }
        return opType;
    }

    private static Value.Property getStatus(Field<?> field, MiningField miningField, Object value, boolean compatible) {
        if (field instanceof DataField) {
            DataField dataField = (DataField)field;
            return FieldValueUtil.getStatus(dataField, miningField, value, compatible);
        }
        return compatible ? Value.Property.VALID : Value.Property.INVALID;
    }

    private static Value.Property getStatus(DataField dataField, MiningField miningField, Object value, boolean compatible) {
        boolean hasValidSpace = false;
        if (dataField.hasValues()) {
            Value pmmlValue;
            DataType dataType = dataField.getDataType();
            if (dataType == null) {
                throw new MissingAttributeException((PMMLObject)dataField, PMMLAttributes.DATAFIELD_DATATYPE);
            }
            if (dataField instanceof HasParsedValueMapping) {
                HasParsedValueMapping hasParsedValueMapping = (HasParsedValueMapping)dataField;
                OpType opType = dataField.getOpType();
                if (opType == null) {
                    throw new MissingAttributeException((PMMLObject)dataField, PMMLAttributes.DATAFIELD_OPTYPE);
                }
                try {
                    FieldValue fieldValue = FieldValueUtil.createOrRefine(dataType, opType, value);
                    pmmlValue = (Value)fieldValue.getMapping(hasParsedValueMapping);
                    if (pmmlValue != null) {
                        return pmmlValue.getProperty();
                    }
                }
                catch (IllegalArgumentException | TypeCheckException fieldValue) {
                    // empty catch block
                }
            }
            List pmmlValues = dataField.getValues();
            int max = pmmlValues.size();
            block10: for (int i = 0; i < max; ++i) {
                boolean equals;
                pmmlValue = (Value)pmmlValues.get(i);
                String stringValue = pmmlValue.getValue();
                if (stringValue == null) {
                    throw new MissingAttributeException((PMMLObject)pmmlValue, PMMLAttributes.VALUE_VALUE);
                }
                Value.Property property = pmmlValue.getProperty();
                switch (property) {
                    case VALID: {
                        FieldValue fieldValue;
                        hasValidSpace = true;
                        if (!compatible) continue block10;
                        if (value instanceof FieldValue) {
                            fieldValue = (FieldValue)value;
                            equals = fieldValue.equalsString(stringValue);
                            break;
                        }
                        equals = FieldValueUtil.equals(dataType, value, stringValue);
                        break;
                    }
                    case INVALID: 
                    case MISSING: {
                        FieldValue fieldValue;
                        if (value instanceof FieldValue) {
                            fieldValue = (FieldValue)value;
                            equals = FieldValueUtil.equals(dataType, FieldValueUtil.getValue(fieldValue), stringValue);
                            break;
                        }
                        equals = FieldValueUtil.equals(dataType, value, stringValue);
                        break;
                    }
                    default: {
                        throw new UnsupportedAttributeException((PMMLObject)pmmlValue, (Enum<?>)property);
                    }
                }
                if (!equals) continue;
                return property;
            }
        }
        if (!compatible) {
            return Value.Property.INVALID;
        }
        if (dataField.hasIntervals()) {
            MiningField locatable = miningField;
            OpType opType = miningField.getOpType();
            if (opType == null) {
                locatable = dataField;
                opType = dataField.getOpType();
            }
            switch (opType) {
                case CONTINUOUS: {
                    RangeSet<Double> validRanges = FieldUtil.getValidRanges(dataField);
                    if (!(value instanceof FieldValue)) {
                        throw new IllegalArgumentException();
                    }
                    FieldValue fieldValue = (FieldValue)value;
                    Double doubleValue = fieldValue.asDouble();
                    return validRanges.contains((Comparable)doubleValue) ? Value.Property.VALID : Value.Property.INVALID;
                }
                case CATEGORICAL: 
                case ORDINAL: {
                    throw new InvalidElementException((PMMLObject)dataField);
                }
            }
            throw new UnsupportedAttributeException((PMMLObject)locatable, (Enum<?>)opType);
        }
        if (hasValidSpace) {
            return Value.Property.INVALID;
        }
        return Value.Property.VALID;
    }

    private static FieldValue createInputValue(Field<?> field, MiningField miningField, Object value) {
        if (Objects.equals(FieldValues.MISSING_VALUE, value) || value == null) {
            return FieldValues.MISSING_VALUE;
        }
        DataType dataType = field.getDataType();
        if (dataType == null) {
            throw new MissingAttributeException(MissingAttributeException.formatMessage(XPathUtil.formatElement(field.getClass()) + "@dataType"), (PMMLObject)field);
        }
        OpType opType = FieldValueUtil.getOpType(field, miningField);
        if (opType == null) {
            throw new MissingAttributeException(MissingAttributeException.formatMessage(XPathUtil.formatElement(field.getClass()) + "@optype"), (PMMLObject)field);
        }
        FieldValue fieldValue = FieldValueUtil.createOrRefine(dataType, opType, value);
        return FieldValueUtil.enhance(field, fieldValue);
    }

    private static FieldValue createMissingInputValue(Field<?> field, MiningField miningField) {
        String missingValueReplacement = miningField.getMissingValueReplacement();
        return FieldValueUtil.createInputValue(field, miningField, missingValueReplacement);
    }

    public static FieldValue create(Object value) {
        if (value == null) {
            return FieldValues.MISSING_VALUE;
        }
        DataType dataType = value instanceof Collection ? TypeUtil.getDataType((Collection)value) : TypeUtil.getDataType(value);
        OpType opType = TypeUtil.getOpType(dataType);
        return FieldValueUtil.createInternal(dataType, opType, value);
    }

    public static FieldValue create(Field<?> field, Object value) {
        if (value == null) {
            return FieldValues.MISSING_VALUE;
        }
        DataType dataType = field.getDataType();
        if (dataType == null) {
            dataType = value instanceof Collection ? TypeUtil.getDataType((Collection)value) : TypeUtil.getDataType(value);
        } else if (!(value instanceof Collection)) {
            value = TypeUtil.parseOrCast(dataType, value);
        }
        OpType opType = field.getOpType();
        if (opType == null) {
            opType = TypeUtil.getOpType(dataType);
        }
        FieldValue fieldValue = FieldValueUtil.createInternal(dataType, opType, value);
        return FieldValueUtil.enhance(field, fieldValue);
    }

    public static FieldValue create(DataType dataType, OpType opType, Object value) {
        if (value == null) {
            return FieldValues.MISSING_VALUE;
        }
        if (dataType == null || opType == null) {
            throw new IllegalArgumentException();
        }
        if (!(value instanceof Collection)) {
            value = TypeUtil.parseOrCast(dataType, value);
        }
        return FieldValueUtil.createInternal(dataType, opType, value);
    }

    public static List<FieldValue> createAll(DataType dataType, OpType opType, List<?> values) {
        return Lists.transform(values, value -> FieldValueUtil.create(dataType, opType, value));
    }

    public static FieldValue refine(Field<?> field, FieldValue value) {
        FieldValue result = FieldValueUtil.refine(field.getDataType(), field.getOpType(), value);
        if (result != value) {
            return FieldValueUtil.enhance(field, result);
        }
        return result;
    }

    public static FieldValue refine(DataType dataType, OpType opType, FieldValue value) {
        if (Objects.equals(FieldValues.MISSING_VALUE, value)) {
            return FieldValues.MISSING_VALUE;
        }
        DataType valueDataType = value.getDataType();
        OpType valueOpType = value.getOpType();
        DataType refinedDataType = FieldValueUtil.firstNonNull(dataType, valueDataType);
        OpType refinedOpType = FieldValueUtil.firstNonNull(opType, valueOpType);
        if (refinedDataType.equals((Object)valueDataType)) {
            if (refinedOpType.equals((Object)valueOpType)) {
                return value;
            }
            return FieldValueUtil.createInternal(refinedDataType, refinedOpType, value.getValue());
        }
        return FieldValueUtil.create(refinedDataType, refinedOpType, value.getValue());
    }

    private static FieldValue createOrRefine(DataType dataType, OpType opType, Object value) {
        if (value instanceof FieldValue) {
            FieldValue fieldValue = (FieldValue)value;
            return FieldValueUtil.refine(dataType, opType, fieldValue);
        }
        return FieldValueUtil.create(dataType, opType, value);
    }

    private static FieldValue enhance(Field<?> field, FieldValue value) {
        if (value instanceof OrdinalValue) {
            OrdinalValue ordinalValue = (OrdinalValue)value;
            List<?> ordering = null;
            if (field instanceof HasDiscreteDomain) {
                ordering = FieldUtil.getValidValues((Field)((HasDiscreteDomain)field));
            }
            ordinalValue.setOrdering(ordering);
        }
        return value;
    }

    private static FieldValue createInternal(DataType dataType, OpType opType, Object value) {
        switch (opType) {
            case CONTINUOUS: {
                return ContinuousValue.create(dataType, value);
            }
            case CATEGORICAL: {
                return CategoricalValue.create(dataType, value);
            }
            case ORDINAL: {
                return OrdinalValue.create(dataType, value);
            }
        }
        throw new IllegalArgumentException();
    }

    public static Object getValue(FieldValue value) {
        return value != null ? value.getValue() : null;
    }

    public static <V> V getValue(Class<? extends V> clazz, FieldValue value) {
        return TypeUtil.cast(clazz, FieldValueUtil.getValue(value));
    }

    public static Value getValidValue(TargetField targetField, Object value) {
        return FieldValueUtil.getValidValue(targetField.getDataField(), value);
    }

    public static Value getValidValue(DataField dataField, Object value) {
        if (value == null) {
            return null;
        }
        if (dataField.hasValues()) {
            DataType dataType = dataField.getDataType();
            if (dataType == null) {
                throw new MissingAttributeException((PMMLObject)dataField, PMMLAttributes.DATAFIELD_DATATYPE);
            }
            value = TypeUtil.parseOrCast(dataType, value);
            if (dataField instanceof HasParsedValueMapping) {
                HasParsedValueMapping hasParsedValueMapping = (HasParsedValueMapping)dataField;
                OpType opType = dataField.getOpType();
                if (opType == null) {
                    throw new MissingAttributeException((PMMLObject)dataField, PMMLAttributes.DATAFIELD_OPTYPE);
                }
                FieldValue fieldValue = FieldValueUtil.createInternal(dataType, opType, value);
                Value pmmlValue = (Value)fieldValue.getMapping(hasParsedValueMapping);
                if (pmmlValue != null && Value.Property.VALID.equals((Object)pmmlValue.getProperty())) {
                    return pmmlValue;
                }
                return null;
            }
            List pmmlValues = dataField.getValues();
            int max = pmmlValues.size();
            block4: for (int i = 0; i < max; ++i) {
                Value pmmlValue = (Value)pmmlValues.get(i);
                String stringValue = pmmlValue.getValue();
                if (stringValue == null) {
                    throw new MissingAttributeException((PMMLObject)pmmlValue, PMMLAttributes.VALUE_VALUE);
                }
                Value.Property property = pmmlValue.getProperty();
                switch (property) {
                    case VALID: {
                        boolean equals = FieldValueUtil.equals(dataType, value, stringValue);
                        if (!equals) continue block4;
                        return pmmlValue;
                    }
                    case INVALID: 
                    case MISSING: {
                        continue block4;
                    }
                    default: {
                        throw new UnsupportedAttributeException((PMMLObject)pmmlValue, (Enum<?>)property);
                    }
                }
            }
        }
        return null;
    }

    private static boolean equals(DataType dataType, Object value, String referenceValue) {
        try {
            return TypeUtil.parseOrCast(dataType, value).equals(TypeUtil.parse(dataType, referenceValue));
        }
        catch (IllegalArgumentException | TypeCheckException e) {
            try {
                return TypeUtil.parseOrCast(DataType.STRING, value).equals(referenceValue);
            }
            catch (TypeCheckException typeCheckException) {
                throw e;
            }
        }
    }

    private static <V> V firstNonNull(V value, V defaultValue) {
        if (value != null) {
            return value;
        }
        return defaultValue;
    }
}

