/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.functions;

import java.util.Objects;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValues;
import org.jpmml.evaluator.FunctionException;
import org.jpmml.evaluator.functions.AbstractFunction;

public abstract class AbstractNumericFunction
extends AbstractFunction {
    public AbstractNumericFunction(String name) {
        super(name);
    }

    @Override
    protected FieldValue checkArgument(FieldValue argument, int index, String alias) {
        if (Objects.equals(FieldValues.MISSING_VALUE, argument)) {
            return argument;
        }
        DataType dataType = argument.getDataType();
        switch (dataType) {
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: {
                break;
            }
            default: {
                if (alias != null) {
                    throw new FunctionException(this, "Expected a numeric '" + alias + "' value at position " + index + ", got " + dataType.value() + " value");
                }
                throw new FunctionException(this, "Expected a numeric value at position " + index + ", got " + dataType.value() + " value");
            }
        }
        return argument;
    }
}

