/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.mining;

import com.google.common.collect.ForwardingMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.mining.Segment;
import org.jpmml.evaluator.HasEntityId;
import org.jpmml.evaluator.HasResultFields;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.OutputField;
import org.jpmml.evaluator.TargetField;

public abstract class SegmentResult
extends ForwardingMap<FieldName, Object>
implements HasEntityId,
HasResultFields {
    private Segment segment = null;
    private Map<FieldName, ?> result = null;

    SegmentResult(Segment segment, Map<FieldName, ?> result) {
        this.setSegment(segment);
        this.setResult(result);
    }

    protected abstract ModelEvaluator<?> getModelEvaluator();

    public Map<FieldName, Object> delegate() {
        Map<FieldName, Object> result = this.getResult();
        return result;
    }

    @Override
    public List<TargetField> getTargetFields() {
        ModelEvaluator<?> modelEvaluator = this.getModelEvaluator();
        return modelEvaluator.getTargetFields();
    }

    @Override
    public List<OutputField> getOutputFields() {
        ModelEvaluator<?> modelEvaluator = this.getModelEvaluator();
        return modelEvaluator.getOutputFields();
    }

    public Object getTargetValue() {
        ModelEvaluator<?> modelEvaluator = this.getModelEvaluator();
        FieldName targetFieldName = modelEvaluator.getTargetFieldName();
        return this.get(targetFieldName);
    }

    public double getWeight() {
        Segment segment = this.getSegment();
        return segment.getWeight();
    }

    public Segment getSegment() {
        return this.segment;
    }

    private void setSegment(Segment segment) {
        this.segment = segment;
    }

    public Map<FieldName, ?> getResult() {
        return this.result;
    }

    private void setResult(Map<FieldName, ?> result) {
        this.result = result;
    }
}

