/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Arrays;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.jpmml.evaluator.DoubleVector;

public class ComplexDoubleVector
extends DoubleVector {
    private int size = 0;
    private double[] values = null;

    public ComplexDoubleVector(int capacity) {
        this.values = new double[capacity];
    }

    @Override
    public int size() {
        return this.size;
    }

    public DoubleVector add(double value) {
        return this.addInternal(value);
    }

    public DoubleVector add(Number value) {
        return this.addInternal(value.doubleValue());
    }

    public DoubleVector add(double coefficient, Number factor) {
        return this.addInternal(coefficient * factor.doubleValue());
    }

    private DoubleVector addInternal(double value) {
        this.values[this.size] = value;
        ++this.size;
        return this;
    }

    @Override
    public double doubleValue(int index) {
        if (this.size <= index) {
            throw new IndexOutOfBoundsException();
        }
        return this.values[index];
    }

    @Override
    public double doubleSum() {
        double[] values = this.values;
        double result = 0.0;
        int max = this.size;
        for (int i = 0; i < max; ++i) {
            result += values[i];
        }
        return result;
    }

    @Override
    public double doubleMax() {
        if (this.size == 0) {
            throw new IllegalStateException();
        }
        double[] values = this.values;
        double result = values[0];
        int max = this.size;
        for (int i = 1; i < max; ++i) {
            result = Math.max(result, values[i]);
        }
        return result;
    }

    @Override
    public double doubleMedian() {
        return this.doublePercentile(50);
    }

    @Override
    public double doublePercentile(int percentile) {
        if (this.size == 0) {
            throw new IllegalStateException();
        }
        double[] data = new double[this.size];
        System.arraycopy(this.values, 0, data, 0, data.length);
        Arrays.sort(data);
        Percentile statistic = new Percentile();
        statistic.setData(data);
        return statistic.evaluate((double)percentile);
    }
}

