/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.io.Serializable;
import org.jpmml.evaluator.Configuration;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.evaluator.ValueFactoryFactory;

public class ConfigurationBuilder
implements Cloneable,
Serializable {
    private ModelEvaluatorFactory modelEvaluatorFactory = null;
    private ValueFactoryFactory valueFactoryFactory = null;

    public ConfigurationBuilder clone() {
        try {
            return (ConfigurationBuilder)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse);
        }
    }

    public Configuration build() {
        Configuration configuration = new Configuration();
        ModelEvaluatorFactory modelEvaluatorFactory = this.getModelEvaluatorFactory();
        if (modelEvaluatorFactory == null) {
            modelEvaluatorFactory = ModelEvaluatorFactory.newInstance();
        }
        configuration.setModelEvaluatorFactory(modelEvaluatorFactory);
        ValueFactoryFactory valueFactoryFactory = this.getValueFactoryFactory();
        if (valueFactoryFactory == null) {
            valueFactoryFactory = ValueFactoryFactory.newInstance();
        }
        configuration.setValueFactoryFactory(valueFactoryFactory);
        return configuration;
    }

    public ModelEvaluatorFactory getModelEvaluatorFactory() {
        return this.modelEvaluatorFactory;
    }

    public ConfigurationBuilder setModelEvaluatorFactory(ModelEvaluatorFactory modelEvaluatorFactory) {
        this.modelEvaluatorFactory = modelEvaluatorFactory;
        return this;
    }

    public ValueFactoryFactory getValueFactoryFactory() {
        return this.valueFactoryFactory;
    }

    public ConfigurationBuilder setValueFactoryFactory(ValueFactoryFactory valueFactoryFactory) {
        this.valueFactoryFactory = valueFactoryFactory;
        return this;
    }
}

