/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collection;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValues;
import org.jpmml.evaluator.TypeInfo;
import org.jpmml.evaluator.TypeUtil;

public class FieldValueUtil {
    private FieldValueUtil() {
    }

    public static FieldValue createOrCast(DataType dataType, OpType opType, Object value) {
        if (value instanceof FieldValue) {
            FieldValue fieldValue = (FieldValue)value;
            return fieldValue.cast(dataType, opType);
        }
        return FieldValueUtil.create(dataType, opType, value);
    }

    public static FieldValue createOrCast(TypeInfo typeInfo, Object value) {
        if (value instanceof FieldValue) {
            FieldValue fieldValue = (FieldValue)value;
            return fieldValue.cast(typeInfo);
        }
        return FieldValueUtil.create(typeInfo, value);
    }

    public static FieldValue create(Object value) {
        DataType dataType;
        if (value == null) {
            return FieldValues.MISSING_VALUE;
        }
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            dataType = TypeUtil.getDataType(values);
        } else {
            dataType = TypeUtil.getDataType(value);
        }
        OpType opType = TypeUtil.getOpType(dataType);
        return FieldValue.create(dataType, opType, value);
    }

    public static FieldValue create(DataType dataType, OpType opType, Object value) {
        if (value == null) {
            return FieldValues.MISSING_VALUE;
        }
        return FieldValue.create(dataType, opType, value);
    }

    public static FieldValue create(TypeInfo typeInfo, Object value) {
        if (value == null) {
            return FieldValues.MISSING_VALUE;
        }
        return FieldValue.create(typeInfo, value);
    }

    public static Object getValue(FieldValue value) {
        return value != null ? value.getValue() : null;
    }

    public static <V> V getValue(Class<? extends V> clazz, FieldValue value) {
        return TypeUtil.cast(clazz, FieldValueUtil.getValue(value));
    }
}

