/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ParameterField;
import org.jpmml.evaluator.DefineFunctionEvaluationContext;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.FunctionRegistry;
import org.jpmml.evaluator.Functions;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.PMMLAttributes;
import org.jpmml.evaluator.PMMLException;
import org.jpmml.evaluator.functions.AbstractFunction;
import org.jpmml.evaluator.functions.AbstractNumericFunction;

public class FunctionUtil {
    private static final Map<String, Function> builtInFunctions;

    private FunctionUtil() {
    }

    public static FieldValue evaluate(Apply apply, List<FieldValue> values, EvaluationContext context) {
        String function = apply.getFunction();
        if (function == null) {
            throw new MissingAttributeException((PMMLObject)apply, PMMLAttributes.APPLY_FUNCTION);
        }
        Function builtInFunction = FunctionUtil.getFunction(function);
        if (builtInFunction != null) {
            return builtInFunction.evaluate(values);
        }
        Function userDefinedFunction = FunctionRegistry.getFunction(function);
        if (userDefinedFunction != null) {
            return userDefinedFunction.evaluate(values);
        }
        DefineFunction defineFunction = context.getDefineFunction(function);
        if (defineFunction != null) {
            return FunctionUtil.evaluate(defineFunction, values, context);
        }
        throw new EvaluationException("Function " + PMMLException.formatKey(function) + " is not defined", (PMMLObject)apply);
    }

    public static FieldValue evaluate(DefineFunction defineFunction, List<FieldValue> values, EvaluationContext context) {
        List parameterFields = defineFunction.getParameterFields();
        if (parameterFields.size() != values.size()) {
            throw new EvaluationException("Function " + PMMLException.formatKey(defineFunction.getName()) + " expects " + parameterFields.size() + " arguments, got " + values.size() + " arguments");
        }
        DefineFunctionEvaluationContext functionContext = new DefineFunctionEvaluationContext(defineFunction, context);
        for (int i = 0; i < parameterFields.size(); ++i) {
            ParameterField parameterField = (ParameterField)parameterFields.get(i);
            FieldValue value = values.get(i);
            FieldName name = parameterField.getName();
            if (name == null) {
                throw new MissingAttributeException((PMMLObject)parameterField, PMMLAttributes.PARAMETERFIELD_NAME);
            }
            value = value.cast(parameterField.getDataType(), parameterField.getOpType());
            functionContext.declare(name, value);
        }
        return ExpressionUtil.evaluateTypedExpressionContainer(defineFunction, functionContext);
    }

    public static Function getFunction(String name) {
        return builtInFunctions.get(name);
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        List<AbstractFunction> functions = Arrays.asList(Functions.PLUS, Functions.MINUS, Functions.MULTIPLY, Functions.DIVIDE, Functions.MIN, Functions.MAX, Functions.AVG, Functions.SUM, Functions.PRODUCT, Functions.LOG10, Functions.LN, Functions.EXP, Functions.SQRT, Functions.ABS, Functions.POW, Functions.THRESHOLD, Functions.FLOOR, Functions.CEIL, Functions.ROUND, Functions.IS_MISSING, Functions.IS_NOT_MISSING, Functions.EQUAL, Functions.NOT_EQUAL, Functions.LESS_THAN, Functions.LESS_OR_EQUAL, Functions.GREATER_THAN, Functions.GREATER_OR_EQUAL, Functions.AND, Functions.OR, Functions.NOT, Functions.IS_IN, Functions.IS_NOT_IN, Functions.IF, Functions.UPPERCASE, Functions.LOWERCASE, Functions.SUBSTRING, Functions.TRIM_BLANKS, Functions.CONCAT, Functions.REPLACE, Functions.MATCHES, Functions.FORMAT_NUMBER, Functions.FORMAT_DATETIME, Functions.DATE_DAYS_SINCE_YEAR, Functions.DATE_SECONDS_SINCE_MIDNIGHT, Functions.DATE_SECONDS_SINCE_YEAR);
        for (Function function : functions) {
            builder.put((Object)function.getName(), (Object)function);
        }
        List<AbstractNumericFunction> extensionFunctions = Arrays.asList(Functions.MODULO, Functions.LN1P, Functions.EXPM1, Functions.RINT, Functions.HYPOT, Functions.SIN, Functions.COS, Functions.TAN, Functions.ASIN, Functions.ACOS, Functions.ATAN, Functions.ATAN2, Functions.SINH, Functions.COSH, Functions.TANH);
        for (Function function : extensionFunctions) {
            builder.put((Object)function.getName(), (Object)function);
        }
        builtInFunctions = builder.build();
    }
}

