/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.rank.Max;
import org.apache.commons.math3.stat.descriptive.rank.Min;
import org.apache.commons.math3.stat.descriptive.summary.Product;
import org.apache.commons.math3.stat.descriptive.summary.Sum;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.DaysSinceDate;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.FieldValues;
import org.jpmml.evaluator.FunctionException;
import org.jpmml.evaluator.NaNResultException;
import org.jpmml.evaluator.Numbers;
import org.jpmml.evaluator.RegExUtil;
import org.jpmml.evaluator.SecondsSinceDate;
import org.jpmml.evaluator.SecondsSinceMidnight;
import org.jpmml.evaluator.TypeInfos;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.functions.AbstractFunction;
import org.jpmml.evaluator.functions.AbstractNumericFunction;
import org.jpmml.evaluator.functions.AggregateFunction;
import org.jpmml.evaluator.functions.ArithmeticFunction;
import org.jpmml.evaluator.functions.BinaryBooleanFunction;
import org.jpmml.evaluator.functions.ComparisonFunction;
import org.jpmml.evaluator.functions.EqualityFunction;
import org.jpmml.evaluator.functions.FpMathFunction;
import org.jpmml.evaluator.functions.MathFunction;
import org.jpmml.evaluator.functions.StringFunction;
import org.jpmml.evaluator.functions.TrigonometricFunction;
import org.jpmml.evaluator.functions.UnaryBooleanFunction;
import org.jpmml.evaluator.functions.ValueFunction;
import org.jpmml.evaluator.functions.ValueListFunction;

public interface Functions {
    public static final ArithmeticFunction PLUS = new ArithmeticFunction("+"){

        @Override
        public Double evaluate(Number left, Number right) {
            return left.doubleValue() + right.doubleValue();
        }
    };
    public static final ArithmeticFunction MINUS = new ArithmeticFunction("-"){

        @Override
        public Double evaluate(Number left, Number right) {
            return left.doubleValue() - right.doubleValue();
        }
    };
    public static final ArithmeticFunction MULTIPLY = new ArithmeticFunction("*"){

        @Override
        public Double evaluate(Number left, Number right) {
            return left.doubleValue() * right.doubleValue();
        }
    };
    public static final ArithmeticFunction DIVIDE = new ArithmeticFunction("/"){

        @Override
        public Number evaluate(Number left, Number right) {
            if (left instanceof Integer && right instanceof Integer) {
                return left.intValue() / right.intValue();
            }
            return left.doubleValue() / right.doubleValue();
        }
    };
    public static final ArithmeticFunction MODULO = new ArithmeticFunction("x-modulo"){

        @Override
        public Number evaluate(Number left, Number right) {
            if (left instanceof Integer && right instanceof Integer) {
                return left.intValue() % right.intValue();
            }
            return left.doubleValue() % right.doubleValue();
        }
    };
    public static final AggregateFunction MIN = new AggregateFunction("min"){

        public Min createStatistic() {
            return new Min();
        }
    };
    public static final AggregateFunction MAX = new AggregateFunction("max"){

        public Max createStatistic() {
            return new Max();
        }
    };
    public static final AggregateFunction AVG = new AggregateFunction("avg"){

        public Mean createStatistic() {
            return new Mean();
        }

        @Override
        public DataType getResultDataType(DataType dataType) {
            if (DataType.INTEGER.equals((Object)dataType)) {
                return DataType.DOUBLE;
            }
            return dataType;
        }
    };
    public static final AggregateFunction SUM = new AggregateFunction("sum"){

        public Sum createStatistic() {
            return new Sum();
        }
    };
    public static final AggregateFunction PRODUCT = new AggregateFunction("product"){

        public Product createStatistic() {
            return new Product();
        }
    };
    public static final FpMathFunction LOG10 = new FpMathFunction("log10"){

        @Override
        public Double evaluate(Number value) {
            return Math.log10(value.doubleValue());
        }
    };
    public static final FpMathFunction LN = new FpMathFunction("ln"){

        @Override
        public Double evaluate(Number value) {
            return Math.log(value.doubleValue());
        }
    };
    public static final FpMathFunction LN1P = new FpMathFunction("x-ln1p"){

        @Override
        public Double evaluate(Number value) {
            return Math.log1p(value.doubleValue());
        }
    };
    public static final FpMathFunction EXP = new FpMathFunction("exp"){

        @Override
        public Double evaluate(Number value) {
            return Math.exp(value.doubleValue());
        }
    };
    public static final FpMathFunction EXPM1 = new FpMathFunction("x-expm1"){

        @Override
        public Double evaluate(Number value) {
            return Math.expm1(value.doubleValue());
        }
    };
    public static final FpMathFunction SQRT = new FpMathFunction("sqrt"){

        @Override
        public Double evaluate(Number value) {
            return Math.sqrt(value.doubleValue());
        }
    };
    public static final MathFunction ABS = new MathFunction("abs"){

        @Override
        public Number evaluate(Number value) {
            if (value instanceof Float) {
                return Float.valueOf(Math.abs(value.floatValue()));
            }
            return Math.abs(value.doubleValue());
        }
    };
    public static final AbstractNumericFunction POW = new AbstractNumericFunction("pow"){

        @Override
        public FieldValue evaluate(List<FieldValue> arguments) {
            this.checkFixedArityArguments(arguments, 2);
            return this.evaluate(this.getRequiredArgument(arguments, 0), this.getRequiredArgument(arguments, 1));
        }

        private FieldValue evaluate(FieldValue left, FieldValue right) {
            DataType dataType = TypeUtil.getCommonDataType(left.getDataType(), right.getDataType());
            Double result = Math.pow(left.asNumber().doubleValue(), right.asNumber().doubleValue());
            return FieldValueUtil.create(dataType, OpType.CONTINUOUS, result);
        }
    };
    public static final AbstractNumericFunction THRESHOLD = new AbstractNumericFunction("threshold"){

        @Override
        public FieldValue evaluate(List<FieldValue> arguments) {
            this.checkFixedArityArguments(arguments, 2);
            return this.evaluate(this.getRequiredArgument(arguments, 0), this.getRequiredArgument(arguments, 1));
        }

        private FieldValue evaluate(FieldValue left, FieldValue right) {
            DataType dataType = TypeUtil.getCommonDataType(left.getDataType(), right.getDataType());
            Integer result = left.asNumber().doubleValue() > right.asNumber().doubleValue() ? Numbers.INTEGER_ONE : Numbers.INTEGER_ZERO;
            return FieldValueUtil.create(dataType, OpType.CONTINUOUS, result);
        }
    };
    public static final MathFunction FLOOR = new MathFunction("floor"){

        @Override
        public Number evaluate(Number number) {
            return Math.floor(number.doubleValue());
        }
    };
    public static final MathFunction CEIL = new MathFunction("ceil"){

        @Override
        public Number evaluate(Number number) {
            return Math.ceil(number.doubleValue());
        }
    };
    public static final MathFunction ROUND = new MathFunction("round"){

        @Override
        public Number evaluate(Number number) {
            if (number instanceof Float) {
                Math.round(number.floatValue());
            }
            return Math.round(number.doubleValue());
        }
    };
    public static final MathFunction RINT = new MathFunction("x-rint"){

        @Override
        public Number evaluate(Number number) {
            return Math.rint(number.doubleValue());
        }
    };
    public static final ValueFunction IS_MISSING = new ValueFunction("isMissing"){

        @Override
        public Boolean evaluate(boolean isMissing) {
            return isMissing;
        }
    };
    public static final ValueFunction IS_NOT_MISSING = new ValueFunction("isNotMissing"){

        @Override
        public Boolean evaluate(boolean isMissing) {
            return !isMissing;
        }
    };
    public static final EqualityFunction EQUAL = new EqualityFunction("equal"){

        @Override
        public Boolean evaluate(boolean equals) {
            return equals;
        }
    };
    public static final EqualityFunction NOT_EQUAL = new EqualityFunction("notEqual"){

        @Override
        public Boolean evaluate(boolean equals) {
            return !equals;
        }
    };
    public static final ComparisonFunction LESS_THAN = new ComparisonFunction("lessThan"){

        @Override
        public Boolean evaluate(int order) {
            return order < 0;
        }
    };
    public static final ComparisonFunction LESS_OR_EQUAL = new ComparisonFunction("lessOrEqual"){

        @Override
        public Boolean evaluate(int order) {
            return order <= 0;
        }
    };
    public static final ComparisonFunction GREATER_THAN = new ComparisonFunction("greaterThan"){

        @Override
        public Boolean evaluate(int order) {
            return order > 0;
        }
    };
    public static final ComparisonFunction GREATER_OR_EQUAL = new ComparisonFunction("greaterOrEqual"){

        @Override
        public Boolean evaluate(int order) {
            return order >= 0;
        }
    };
    public static final BinaryBooleanFunction AND = new BinaryBooleanFunction("and"){

        @Override
        public Boolean evaluate(Boolean left, Boolean right) {
            return left & right;
        }
    };
    public static final BinaryBooleanFunction OR = new BinaryBooleanFunction("or"){

        @Override
        public Boolean evaluate(Boolean left, Boolean right) {
            return left | right;
        }
    };
    public static final UnaryBooleanFunction NOT = new UnaryBooleanFunction("not"){

        @Override
        public Boolean evaluate(Boolean value) {
            return value == false;
        }
    };
    public static final ValueListFunction IS_IN = new ValueListFunction("isIn"){

        @Override
        public Boolean evaluate(boolean isIn) {
            return isIn;
        }
    };
    public static final ValueListFunction IS_NOT_IN = new ValueListFunction("isNotIn"){

        @Override
        public Boolean evaluate(boolean isIn) {
            return !isIn;
        }
    };
    public static final AbstractFunction IF = new AbstractFunction("if"){

        @Override
        public FieldValue evaluate(List<FieldValue> arguments) {
            this.checkVariableArityArguments(arguments, 2, 3);
            Boolean flag = this.getRequiredArgument(arguments, 0).asBoolean();
            if (flag.booleanValue()) {
                return this.getOptionalArgument(arguments, 1);
            }
            if (arguments.size() > 2) {
                return this.getOptionalArgument(arguments, 2);
            }
            return FieldValues.MISSING_VALUE;
        }
    };
    public static final StringFunction UPPERCASE = new StringFunction("uppercase"){

        @Override
        public String evaluate(String value) {
            return value.toUpperCase();
        }
    };
    public static final StringFunction LOWERCASE = new StringFunction("lowercase"){

        @Override
        public String evaluate(String value) {
            return value.toLowerCase();
        }
    };
    public static final AbstractFunction SUBSTRING = new AbstractFunction("substring"){

        @Override
        public FieldValue evaluate(List<FieldValue> arguments) {
            this.checkFixedArityArguments(arguments, 3);
            String string = this.getRequiredArgument(arguments, 0, "input").asString();
            int position = this.getRequiredArgument(arguments, 1, "startPos").asInteger();
            if (position < 1) {
                throw new FunctionException(this, "Invalid 'startPos' value " + position + ". Must be equal or greater than 1");
            }
            int javaPosition = Math.min(position - 1, string.length());
            int length = this.getRequiredArgument(arguments, 2, "length").asInteger();
            if (length < 0) {
                throw new FunctionException(this, "Invalid 'length' value " + length);
            }
            int javaLength = Math.min(length, string.length() - javaPosition);
            String result = string.substring(javaPosition, javaPosition + javaLength);
            return FieldValueUtil.create(TypeInfos.CATEGORICAL_STRING, result);
        }
    };
    public static final StringFunction TRIM_BLANKS = new StringFunction("trimBlanks"){

        @Override
        public String evaluate(String value) {
            return value.trim();
        }
    };
    public static final AbstractFunction CONCAT = new AbstractFunction("concat"){

        @Override
        public FieldValue evaluate(List<FieldValue> arguments) {
            this.checkVariableArityArguments(arguments, 2);
            String result = arguments.stream().filter(Objects::nonNull).map(value -> (String)TypeUtil.cast(DataType.STRING, value.getValue())).collect(Collectors.joining());
            return FieldValueUtil.create(TypeInfos.CATEGORICAL_STRING, result);
        }
    };
    public static final AbstractFunction REPLACE = new AbstractFunction("replace"){

        @Override
        public FieldValue evaluate(List<FieldValue> arguments) {
            this.checkFixedArityArguments(arguments, 3);
            String input = this.getRequiredArgument(arguments, 0, "input").asString();
            String regex = this.getRequiredArgument(arguments, 1, "pattern").asString();
            Pattern pattern = RegExUtil.compile(regex, null);
            Matcher matcher = pattern.matcher(input);
            String replacement = this.getRequiredArgument(arguments, 2, "replacement").asString();
            String result = matcher.replaceAll(replacement);
            return FieldValueUtil.create(TypeInfos.CATEGORICAL_STRING, result);
        }
    };
    public static final AbstractFunction MATCHES = new AbstractFunction("matches"){

        @Override
        public FieldValue evaluate(List<FieldValue> arguments) {
            this.checkFixedArityArguments(arguments, 2);
            String input = this.getRequiredArgument(arguments, 0, "input").asString();
            String pattern = this.getRequiredArgument(arguments, 1, "pattern").asString();
            Matcher matcher = Pattern.compile(pattern).matcher(input);
            Boolean result = matcher.find();
            return FieldValueUtil.create(TypeInfos.CATEGORICAL_BOOLEAN, result);
        }
    };
    public static final AbstractFunction FORMAT_NUMBER = new AbstractFunction("formatNumber"){

        @Override
        public FieldValue evaluate(List<FieldValue> arguments) {
            String result;
            this.checkFixedArityArguments(arguments, 2);
            Number number = this.getRequiredArgument(arguments, 0, "input").asNumber();
            String pattern = this.getRequiredArgument(arguments, 1, "pattern").asString();
            try {
                result = String.format(pattern, number);
            }
            catch (IllegalFormatException ife) {
                throw new FunctionException(this, "Invalid 'pattern' value").initCause(ife);
            }
            return FieldValueUtil.create(TypeInfos.CATEGORICAL_STRING, result);
        }
    };
    public static final AbstractFunction FORMAT_DATETIME = new AbstractFunction("formatDatetime"){

        @Override
        public FieldValue evaluate(List<FieldValue> arguments) {
            String result;
            this.checkFixedArityArguments(arguments, 2);
            ZonedDateTime zonedDateTime = this.getRequiredArgument(arguments, 0, "input").asZonedDateTime(ZoneId.systemDefault());
            Date date = Date.from(zonedDateTime.toInstant());
            String pattern = this.translatePattern(this.getRequiredArgument(arguments, 1, "pattern").asString());
            try {
                result = String.format(pattern, date);
            }
            catch (IllegalFormatException ife) {
                throw new FunctionException(this, "Invalid 'pattern' value").initCause(ife);
            }
            return FieldValueUtil.create(TypeInfos.CATEGORICAL_STRING, result);
        }

        private String translatePattern(String pattern) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                sb.append(c);
                if (c != '%' || i >= pattern.length() - 1 || pattern.charAt(i + 1) == '%') continue;
                sb.append("1$t");
            }
            return sb.toString();
        }
    };
    public static final AbstractFunction DATE_DAYS_SINCE_YEAR = new AbstractFunction("dateDaysSinceYear"){

        @Override
        public FieldValue evaluate(List<FieldValue> arguments) {
            this.checkFixedArityArguments(arguments, 2);
            LocalDate instant = this.getRequiredArgument(arguments, 0, "input").asLocalDate();
            int year = this.getRequiredArgument(arguments, 1, "referenceYear").asInteger();
            DaysSinceDate period = new DaysSinceDate(LocalDate.of(year, 1, 1), instant);
            return FieldValueUtil.create(TypeInfos.CONTINUOUS_INTEGER, period.intValue());
        }
    };
    public static final AbstractFunction DATE_SECONDS_SINCE_MIDNIGHT = new AbstractFunction("dateSecondsSinceMidnight"){

        @Override
        public FieldValue evaluate(List<FieldValue> arguments) {
            this.checkFixedArityArguments(arguments, 1);
            LocalTime instant = this.getRequiredArgument(arguments, 0, "input").asLocalTime();
            SecondsSinceMidnight period = new SecondsSinceMidnight(instant.toSecondOfDay());
            return FieldValueUtil.create(TypeInfos.CONTINUOUS_INTEGER, period.intValue());
        }
    };
    public static final AbstractFunction DATE_SECONDS_SINCE_YEAR = new AbstractFunction("dateSecondsSinceYear"){

        @Override
        public FieldValue evaluate(List<FieldValue> arguments) {
            this.checkFixedArityArguments(arguments, 2);
            LocalDateTime instant = this.getRequiredArgument(arguments, 0, "input").asLocalDateTime();
            int year = this.getRequiredArgument(arguments, 1, "referenceYear").asInteger();
            SecondsSinceDate period = new SecondsSinceDate(LocalDate.of(year, 1, 1), instant);
            return FieldValueUtil.create(TypeInfos.CONTINUOUS_INTEGER, period.intValue());
        }
    };
    public static final AbstractNumericFunction HYPOT = new AbstractNumericFunction("x-hypot"){

        @Override
        public FieldValue evaluate(List<FieldValue> arguments) {
            this.checkFixedArityArguments(arguments, 2);
            Number x = this.getRequiredArgument(arguments, 0).asNumber();
            Number y = this.getRequiredArgument(arguments, 1).asNumber();
            Double result = Math.hypot(x.doubleValue(), y.doubleValue());
            return FieldValueUtil.create(TypeInfos.CONTINUOUS_DOUBLE, result);
        }
    };
    public static final TrigonometricFunction SIN = new TrigonometricFunction("x-sin"){

        @Override
        public Double evaluate(Number value) {
            return Math.sin(value.doubleValue());
        }
    };
    public static final TrigonometricFunction COS = new TrigonometricFunction("x-cos"){

        @Override
        public Double evaluate(Number value) {
            return Math.cos(value.doubleValue());
        }
    };
    public static final TrigonometricFunction TAN = new TrigonometricFunction("x-tan"){

        @Override
        public Double evaluate(Number value) {
            return Math.tan(value.doubleValue());
        }
    };
    public static final TrigonometricFunction ASIN = new TrigonometricFunction("x-asin"){

        @Override
        public Double evaluate(Number value) {
            return Math.asin(value.doubleValue());
        }
    };
    public static final TrigonometricFunction ACOS = new TrigonometricFunction("x-acos"){

        @Override
        public Double evaluate(Number value) {
            return Math.acos(value.doubleValue());
        }
    };
    public static final TrigonometricFunction ATAN = new TrigonometricFunction("x-atan"){

        @Override
        public Double evaluate(Number value) {
            return Math.atan(value.doubleValue());
        }
    };
    public static final AbstractNumericFunction ATAN2 = new AbstractNumericFunction("x-atan2"){

        @Override
        public FieldValue evaluate(List<FieldValue> arguments) {
            this.checkFixedArityArguments(arguments, 2);
            Number y = this.getRequiredArgument(arguments, 0).asNumber();
            Number x = this.getRequiredArgument(arguments, 1).asNumber();
            Double result = Math.atan2(y.doubleValue(), x.doubleValue());
            if (result.isNaN()) {
                throw new NaNResultException();
            }
            return FieldValueUtil.create(TypeInfos.CONTINUOUS_DOUBLE, result);
        }
    };
    public static final TrigonometricFunction SINH = new TrigonometricFunction("x-sinh"){

        @Override
        public Double evaluate(Number value) {
            return Math.sinh(value.doubleValue());
        }
    };
    public static final TrigonometricFunction COSH = new TrigonometricFunction("x-cosh"){

        @Override
        public Double evaluate(Number value) {
            return Math.cosh(value.doubleValue());
        }
    };
    public static final TrigonometricFunction TANH = new TrigonometricFunction("x-tanh"){

        @Override
        public Double evaluate(Number value) {
            return Math.tanh(value.doubleValue());
        }
    };
}

