/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Value;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.HasParsedValueMapping;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.PMMLAttributes;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedAttributeException;

public class TargetFieldUtil {
    private TargetFieldUtil() {
    }

    public static Value getValidValue(DataField dataField, Object value) {
        if (value == null) {
            return null;
        }
        if (dataField.hasValues()) {
            DataType dataType = dataField.getDataType();
            if (dataType == null) {
                throw new MissingAttributeException((PMMLObject)dataField, PMMLAttributes.DATAFIELD_DATATYPE);
            }
            if (dataField instanceof HasParsedValueMapping) {
                HasParsedValueMapping hasParsedValueMapping = (HasParsedValueMapping)dataField;
                OpType opType = dataField.getOpType();
                if (opType == null) {
                    throw new MissingAttributeException((PMMLObject)dataField, PMMLAttributes.DATAFIELD_OPTYPE);
                }
                FieldValue fieldValue = FieldValueUtil.create(dataType, opType, value);
                Value pmmlValue = (Value)fieldValue.getMapping(hasParsedValueMapping);
                if (pmmlValue != null && Value.Property.VALID.equals((Object)pmmlValue.getProperty())) {
                    return pmmlValue;
                }
                return null;
            }
            value = TypeUtil.parseOrCast(dataType, value);
            List pmmlValues = dataField.getValues();
            int max = pmmlValues.size();
            block4: for (int i = 0; i < max; ++i) {
                Value pmmlValue = (Value)pmmlValues.get(i);
                String stringValue = pmmlValue.getValue();
                if (stringValue == null) {
                    throw new MissingAttributeException((PMMLObject)pmmlValue, PMMLAttributes.VALUE_VALUE);
                }
                Value.Property property = pmmlValue.getProperty();
                switch (property) {
                    case VALID: {
                        boolean equals = TypeUtil.equals(dataType, value, stringValue);
                        if (!equals) continue block4;
                        return pmmlValue;
                    }
                    case INVALID: 
                    case MISSING: {
                        continue block4;
                    }
                    default: {
                        throw new UnsupportedAttributeException((PMMLObject)pmmlValue, (Enum<?>)property);
                    }
                }
            }
        }
        return null;
    }
}

