/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.clustering;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Array;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Distance;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.Measure;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Similarity;
import org.dmg.pmml.Target;
import org.dmg.pmml.Targets;
import org.dmg.pmml.clustering.CenterFields;
import org.dmg.pmml.clustering.Cluster;
import org.dmg.pmml.clustering.ClusteringField;
import org.dmg.pmml.clustering.ClusteringModel;
import org.dmg.pmml.clustering.MissingValueWeights;
import org.jpmml.evaluator.ArrayUtil;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.InvalidAttributeException;
import org.jpmml.evaluator.InvalidElementException;
import org.jpmml.evaluator.MeasureUtil;
import org.jpmml.evaluator.MisplacedElementException;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.PMMLAttributes;
import org.jpmml.evaluator.PMMLElements;
import org.jpmml.evaluator.PMMLUtil;
import org.jpmml.evaluator.TypeInfos;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.UnsupportedElementException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.clustering.ClusterAffinityDistribution;

public class ClusteringModelEvaluator
extends ModelEvaluator<ClusteringModel>
implements HasEntityRegistry<Cluster> {
    private transient BiMap<String, Cluster> entityRegistry = null;
    private static final LoadingCache<Cluster, List<FieldValue>> clusterValueCache = CacheUtil.buildLoadingCache(new CacheLoader<Cluster, List<FieldValue>>(){

        public List<FieldValue> load(Cluster cluster) {
            Array array = cluster.getArray();
            List<? extends Number> values = ArrayUtil.asNumberList(array);
            return ImmutableList.copyOf((Collection)Lists.transform(values, value -> FieldValueUtil.create(TypeInfos.CONTINUOUS_DOUBLE, value)));
        }
    });
    private static final LoadingCache<Cluster, BitSet> clusterFlagCache = CacheUtil.buildLoadingCache(new CacheLoader<Cluster, BitSet>(){

        public BitSet load(Cluster cluster) {
            List values = (List)CacheUtil.getValue(cluster, clusterValueCache);
            return MeasureUtil.toBitSet(values);
        }
    });
    private static final LoadingCache<ClusteringModel, BiMap<String, Cluster>> entityCache = CacheUtil.buildLoadingCache(new CacheLoader<ClusteringModel, BiMap<String, Cluster>>(){

        public BiMap<String, Cluster> load(ClusteringModel clusteringModel) {
            return EntityUtil.buildBiMap(clusteringModel.getClusters());
        }
    });

    public ClusteringModelEvaluator(PMML pmml) {
        this(pmml, PMMLUtil.findModel(pmml, ClusteringModel.class));
    }

    public ClusteringModelEvaluator(PMML pmml, ClusteringModel clusteringModel) {
        super(pmml, clusteringModel);
        ComparisonMeasure comparisonMeasure = clusteringModel.getComparisonMeasure();
        if (comparisonMeasure == null) {
            throw new MissingElementException((PMMLObject)clusteringModel, PMMLElements.CLUSTERINGMODEL_COMPARISONMEASURE);
        }
        ClusteringModel.ModelClass modelClass = clusteringModel.getModelClass();
        switch (modelClass) {
            case CENTER_BASED: {
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)clusteringModel, (Enum<?>)modelClass);
            }
        }
        CenterFields centerFields = clusteringModel.getCenterFields();
        if (centerFields != null) {
            throw new UnsupportedElementException((PMMLObject)centerFields);
        }
        if (!clusteringModel.hasClusteringFields()) {
            throw new MissingElementException((PMMLObject)clusteringModel, PMMLElements.CLUSTERINGMODEL_CLUSTERINGFIELDS);
        }
        if (!clusteringModel.hasClusters()) {
            throw new MissingElementException((PMMLObject)clusteringModel, PMMLElements.CLUSTERINGMODEL_CLUSTERS);
        }
        Targets targets = clusteringModel.getTargets();
        if (targets != null) {
            throw new MisplacedElementException((PMMLObject)targets);
        }
    }

    @Override
    public String getSummary() {
        return "Clustering model";
    }

    @Override
    public Target getTarget(FieldName name) {
        return null;
    }

    @Override
    public BiMap<String, Cluster> getEntityRegistry() {
        if (this.entityRegistry == null) {
            this.entityRegistry = this.getValue(entityCache);
        }
        return this.entityRegistry;
    }

    @Override
    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        Map<FieldName, ClusterAffinityDistribution<?>> predictions;
        ValueFactory<?> valueFactory;
        ClusteringModel clusteringModel = (ClusteringModel)this.ensureScorableModel();
        MathContext mathContext = clusteringModel.getMathContext();
        switch (mathContext) {
            case FLOAT: 
            case DOUBLE: {
                valueFactory = this.ensureValueFactory();
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)clusteringModel, (Enum<?>)mathContext);
            }
        }
        MiningFunction miningFunction = clusteringModel.getMiningFunction();
        switch (miningFunction) {
            case CLUSTERING: {
                predictions = this.evaluateClustering(valueFactory, context);
                break;
            }
            case ASSOCIATION_RULES: 
            case SEQUENCES: 
            case CLASSIFICATION: 
            case REGRESSION: 
            case TIME_SERIES: 
            case MIXED: {
                throw new InvalidAttributeException((PMMLObject)clusteringModel, (Enum<?>)miningFunction);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)clusteringModel, (Enum<?>)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private <V extends Number> Map<FieldName, ClusterAffinityDistribution<V>> evaluateClustering(ValueFactory<V> valueFactory, EvaluationContext context) {
        ClusterAffinityDistribution<V> result;
        ClusteringModel clusteringModel = (ClusteringModel)this.getModel();
        ComparisonMeasure comparisonMeasure = clusteringModel.getComparisonMeasure();
        List<ClusteringField> clusteringFields = this.getCenterClusteringFields();
        ArrayList<FieldValue> values = new ArrayList<FieldValue>(clusteringFields.size());
        int max = clusteringFields.size();
        for (int i = 0; i < max; ++i) {
            ClusteringField clusteringField = clusteringFields.get(i);
            FieldName name = clusteringField.getField();
            if (name == null) {
                throw new MissingAttributeException((PMMLObject)clusteringField, PMMLAttributes.CLUSTERINGFIELD_FIELD);
            }
            FieldValue value = context.evaluate(name);
            values.add(value);
        }
        Measure measure = MeasureUtil.ensureMeasure(comparisonMeasure);
        if (measure instanceof Similarity) {
            result = this.evaluateSimilarity(valueFactory, comparisonMeasure, clusteringFields, values);
        } else if (measure instanceof Distance) {
            result = this.evaluateDistance(valueFactory, comparisonMeasure, clusteringFields, values);
        } else {
            throw new UnsupportedElementException((PMMLObject)measure);
        }
        result.computeResult(DataType.STRING);
        return Collections.singletonMap(this.getTargetFieldName(), result);
    }

    private <V extends Number> ClusterAffinityDistribution<V> evaluateSimilarity(ValueFactory<V> valueFactory, ComparisonMeasure comparisonMeasure, List<ClusteringField> clusteringFields, List<FieldValue> values) {
        ClusteringModel clusteringModel = (ClusteringModel)this.getModel();
        List clusters = clusteringModel.getClusters();
        ClusterAffinityDistribution<V> result = this.createClusterAffinityDistribution(Classification.Type.SIMILARITY, clusters);
        BitSet flags = MeasureUtil.toBitSet(values);
        for (Cluster cluster : clusters) {
            BitSet clusterFlags = CacheUtil.getValue(cluster, clusterFlagCache);
            if (flags.size() != clusterFlags.size()) {
                throw new InvalidElementException((PMMLObject)cluster);
            }
            Value<V> similarity = MeasureUtil.evaluateSimilarity(valueFactory, comparisonMeasure, clusteringFields, flags, clusterFlags);
            result.put(cluster, similarity);
        }
        return result;
    }

    private <V extends Number> ClusterAffinityDistribution<V> evaluateDistance(ValueFactory<V> valueFactory, ComparisonMeasure comparisonMeasure, List<ClusteringField> clusteringFields, List<FieldValue> values) {
        Value<V> adjustment;
        ClusteringModel clusteringModel = (ClusteringModel)this.getModel();
        List clusters = clusteringModel.getClusters();
        MissingValueWeights missingValueWeights = clusteringModel.getMissingValueWeights();
        if (missingValueWeights != null) {
            Array array = missingValueWeights.getArray();
            List<? extends Number> adjustmentValues = ArrayUtil.asNumberList(array);
            if (values.size() != adjustmentValues.size()) {
                throw new InvalidElementException((PMMLObject)missingValueWeights);
            }
            adjustment = MeasureUtil.calculateAdjustment(valueFactory, values, adjustmentValues);
        } else {
            adjustment = MeasureUtil.calculateAdjustment(valueFactory, values);
        }
        ClusterAffinityDistribution<V> result = this.createClusterAffinityDistribution(Classification.Type.DISTANCE, clusters);
        for (Cluster cluster : clusters) {
            List<FieldValue> clusterValues = CacheUtil.getValue(cluster, clusterValueCache);
            if (values.size() != clusterValues.size()) {
                throw new InvalidElementException((PMMLObject)cluster);
            }
            Value<V> distance = MeasureUtil.evaluateDistance(valueFactory, comparisonMeasure, clusteringFields, values, clusterValues, adjustment);
            result.put(cluster, distance);
        }
        return result;
    }

    private List<ClusteringField> getCenterClusteringFields() {
        ClusteringModel clusteringModel = (ClusteringModel)this.getModel();
        List clusteringFields = clusteringModel.getClusteringFields();
        ArrayList<ClusteringField> result = new ArrayList<ClusteringField>(clusteringFields.size());
        int max = clusteringFields.size();
        block4: for (int i = 0; i < max; ++i) {
            ClusteringField clusteringField = (ClusteringField)clusteringFields.get(i);
            ClusteringField.CenterField centerField = clusteringField.getCenterField();
            switch (centerField) {
                case TRUE: {
                    result.add(clusteringField);
                    continue block4;
                }
                case FALSE: {
                    continue block4;
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)clusteringField, (Enum<?>)centerField);
                }
            }
        }
        return result;
    }

    private <V extends Number> ClusterAffinityDistribution<V> createClusterAffinityDistribution(Classification.Type type, List<Cluster> clusters) {
        ClusterAffinityDistribution result = new ClusterAffinityDistribution<V>(type, new ValueMap(2 * clusters.size())){

            @Override
            public BiMap<String, Cluster> getEntityRegistry() {
                return ClusteringModelEvaluator.this.getEntityRegistry();
            }
        };
        return result;
    }
}

