/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.mining;

import com.google.common.collect.BiMap;
import java.util.HashMap;
import java.util.Map;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.mining.Segment;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.mining.MiningModelEvaluator;
import org.jpmml.evaluator.mining.SegmentResult;

public class MiningModelEvaluationContext
extends ModelEvaluationContext {
    private Map<String, SegmentResult> results = null;
    private Map<FieldName, OutputField> outputFields = null;

    public MiningModelEvaluationContext(MiningModelEvaluator miningModelEvaluator) {
        this(miningModelEvaluator, (MiningModelEvaluationContext)null);
    }

    public MiningModelEvaluationContext(MiningModelEvaluator miningModelEvaluator, MiningModelEvaluationContext parent) {
        super(miningModelEvaluator, parent);
        BiMap<String, Segment> entityRegistry = miningModelEvaluator.getEntityRegistry();
        this.results = new HashMap<String, SegmentResult>(2 * entityRegistry.size());
    }

    @Override
    public void reset(boolean clearValues) {
        super.reset(clearValues);
        if (!this.results.isEmpty()) {
            this.results.clear();
        }
        if (this.outputFields != null && !this.outputFields.isEmpty()) {
            this.outputFields.clear();
        }
    }

    public MiningModelEvaluator getModelEvaluator() {
        return (MiningModelEvaluator)super.getModelEvaluator();
    }

    public SegmentResult getResult(String id) {
        return this.results.get(id);
    }

    void putResult(String id, SegmentResult result) {
        this.results.put(id, result);
    }

    public OutputField getOutputField(FieldName name) {
        if (this.outputFields == null) {
            return null;
        }
        return this.outputFields.get(name);
    }

    void putOutputField(OutputField outputField) {
        this.putOutputField(outputField.getName(), outputField);
    }

    void putOutputField(FieldName name, OutputField outputField) {
        if (this.outputFields == null) {
            this.outputFields = new HashMap<FieldName, OutputField>();
        }
        this.outputFields.put(name, outputField);
    }

    public DerivedField getLocalDerivedField(FieldName name) {
        MiningModelEvaluator modelEvaluator = this.getModelEvaluator();
        return modelEvaluator.getLocalDerivedField(name);
    }
}

