/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.nearest_neighbor;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Distance;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.Measure;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Similarity;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.nearest_neighbor.InstanceField;
import org.dmg.pmml.nearest_neighbor.InstanceFields;
import org.dmg.pmml.nearest_neighbor.KNNInput;
import org.dmg.pmml.nearest_neighbor.KNNInputs;
import org.dmg.pmml.nearest_neighbor.NearestNeighborModel;
import org.dmg.pmml.nearest_neighbor.TrainingInstances;
import org.jpmml.evaluator.AffinityDistribution;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.FieldValues;
import org.jpmml.evaluator.InlineTableUtil;
import org.jpmml.evaluator.InputFieldUtil;
import org.jpmml.evaluator.InvalidAttributeException;
import org.jpmml.evaluator.InvalidElementException;
import org.jpmml.evaluator.InvisibleFieldException;
import org.jpmml.evaluator.MeasureUtil;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.MissingValueException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.PMMLAttributes;
import org.jpmml.evaluator.PMMLElements;
import org.jpmml.evaluator.PMMLUtil;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TypeInfo;
import org.jpmml.evaluator.TypeInfos;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.UnsupportedElementException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueAggregator;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.VoteAggregator;
import org.jpmml.model.visitors.FieldReferenceFinder;

public class NearestNeighborModelEvaluator
extends ModelEvaluator<NearestNeighborModel> {
    private transient Table<Integer, FieldName, FieldValue> trainingInstances = null;
    private transient Map<Integer, BitSet> instanceFlags = null;
    private transient Map<Integer, List<FieldValue>> instanceValues = null;
    private static final Cache<NearestNeighborModel, Table<Integer, FieldName, FieldValue>> trainingInstanceCache = CacheUtil.buildCache();
    private static final Cache<NearestNeighborModel, Map<Integer, BitSet>> instanceFlagCache = CacheUtil.buildCache();
    private static final Cache<NearestNeighborModel, Map<Integer, List<FieldValue>>> instanceValueCache = CacheUtil.buildCache();

    public NearestNeighborModelEvaluator(PMML pmml) {
        this(pmml, PMMLUtil.findModel(pmml, NearestNeighborModel.class));
    }

    public NearestNeighborModelEvaluator(PMML pmml, NearestNeighborModel nearestNeighborModel) {
        super(pmml, nearestNeighborModel);
        ComparisonMeasure comparisoonMeasure = nearestNeighborModel.getComparisonMeasure();
        if (comparisoonMeasure == null) {
            throw new MissingElementException((PMMLObject)nearestNeighborModel, PMMLElements.NEARESTNEIGHBORMODEL_COMPARISONMEASURE);
        }
        TrainingInstances trainingInstances = nearestNeighborModel.getTrainingInstances();
        if (trainingInstances == null) {
            throw new MissingElementException((PMMLObject)nearestNeighborModel, PMMLElements.NEARESTNEIGHBORMODEL_TRAININGINSTANCES);
        }
        InstanceFields instanceFields = trainingInstances.getInstanceFields();
        if (instanceFields == null) {
            throw new MissingElementException((PMMLObject)trainingInstances, PMMLElements.TRAININGINSTANCES_INSTANCEFIELDS);
        }
        if (!instanceFields.hasInstanceFields()) {
            throw new MissingElementException((PMMLObject)instanceFields, PMMLElements.INSTANCEFIELDS_INSTANCEFIELDS);
        }
        KNNInputs knnInputs = nearestNeighborModel.getKNNInputs();
        if (knnInputs == null) {
            throw new MissingElementException((PMMLObject)nearestNeighborModel, PMMLElements.NEARESTNEIGHBORMODEL_KNNINPUTS);
        }
        if (!knnInputs.hasKNNInputs()) {
            throw new MissingElementException((PMMLObject)knnInputs, PMMLElements.KNNINPUTS_KNNINPUTS);
        }
    }

    @Override
    public String getSummary() {
        return "k-Nearest neighbors model";
    }

    @Override
    protected DataField getDataField() {
        MiningFunction miningFunction = this.getMiningFunction();
        switch (miningFunction) {
            case REGRESSION: 
            case CLASSIFICATION: 
            case MIXED: {
                return null;
            }
        }
        return super.getDataField();
    }

    @Override
    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        Map<FieldName, AffinityDistribution<?>> predictions;
        ValueFactory<?> valueFactory;
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)this.ensureScorableModel();
        MathContext mathContext = nearestNeighborModel.getMathContext();
        switch (mathContext) {
            case FLOAT: 
            case DOUBLE: {
                valueFactory = this.ensureValueFactory();
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)nearestNeighborModel, (Enum<?>)mathContext);
            }
        }
        MiningFunction miningFunction = nearestNeighborModel.getMiningFunction();
        switch (miningFunction) {
            case REGRESSION: 
            case CLASSIFICATION: 
            case MIXED: {
                predictions = this.evaluateMixed(valueFactory, context);
                break;
            }
            case CLUSTERING: {
                predictions = this.evaluateClustering(valueFactory, context);
                break;
            }
            case ASSOCIATION_RULES: 
            case SEQUENCES: 
            case TIME_SERIES: {
                throw new InvalidAttributeException((PMMLObject)nearestNeighborModel, (Enum<?>)miningFunction);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)nearestNeighborModel, (Enum<?>)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private <V extends Number> Map<FieldName, AffinityDistribution<V>> evaluateMixed(ValueFactory<V> valueFactory, EvaluationContext context) {
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)this.getModel();
        Table<Integer, FieldName, FieldValue> table = this.getTrainingInstances();
        List<InstanceResult<V>> instanceResults = this.evaluateInstanceRows(valueFactory, context);
        Ordering ordering = Ordering.natural().reverse();
        List<InstanceResult<V>> nearestInstanceResults = ordering.sortedCopy(instanceResults);
        int numberOfNeighbors = nearestNeighborModel.getNumberOfNeighbors();
        nearestInstanceResults = nearestInstanceResults.subList(0, numberOfNeighbors);
        Function<Integer, String> function = new Function<Integer, String>(){

            public String apply(Integer row) {
                return row.toString();
            }
        };
        FieldName instanceIdVariable = nearestNeighborModel.getInstanceIdVariable();
        if (instanceIdVariable != null) {
            function = this.createIdentifierResolver(instanceIdVariable, table);
        }
        LinkedHashMap<FieldName, AffinityDistribution<AffinityDistribution<V>>> results = new LinkedHashMap<FieldName, AffinityDistribution<AffinityDistribution<V>>>();
        List<TargetField> targetFields = this.getTargetFields();
        for (TargetField targetField : targetFields) {
            Object value;
            FieldName name = targetField.getName();
            OpType opType = targetField.getOpType();
            switch (opType) {
                case CONTINUOUS: {
                    value = this.calculateContinuousTarget(valueFactory, name, nearestInstanceResults, table);
                    break;
                }
                case CATEGORICAL: {
                    value = this.calculateCategoricalTarget(valueFactory, name, nearestInstanceResults, table);
                    break;
                }
                default: {
                    throw new InvalidElementException((PMMLObject)nearestNeighborModel);
                }
            }
            value = TypeUtil.parseOrCast(targetField.getDataType(), value);
            AffinityDistribution<V> result = this.createAffinityDistribution(instanceResults, function, value);
            results.put(name, result);
        }
        return results;
    }

    private <V extends Number> Map<FieldName, AffinityDistribution<V>> evaluateClustering(ValueFactory<V> valueFactory, EvaluationContext context) {
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)this.getModel();
        Table<Integer, FieldName, FieldValue> table = this.getTrainingInstances();
        List<InstanceResult<V>> instanceResults = this.evaluateInstanceRows(valueFactory, context);
        FieldName instanceIdVariable = nearestNeighborModel.getInstanceIdVariable();
        if (instanceIdVariable == null) {
            throw new MissingAttributeException((PMMLObject)nearestNeighborModel, PMMLAttributes.NEARESTNEIGHBORMODEL_INSTANCEIDVARIABLE);
        }
        Function<Integer, String> function = this.createIdentifierResolver(instanceIdVariable, table);
        AffinityDistribution<V> result = this.createAffinityDistribution(instanceResults, function, null);
        return Collections.singletonMap(this.getTargetFieldName(), result);
    }

    private <V extends Number> List<InstanceResult<V>> evaluateInstanceRows(ValueFactory<V> valueFactory, EvaluationContext context) {
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)this.getModel();
        ComparisonMeasure comparisonMeasure = nearestNeighborModel.getComparisonMeasure();
        ArrayList<FieldValue> values = new ArrayList<FieldValue>();
        KNNInputs knnInputs = nearestNeighborModel.getKNNInputs();
        for (KNNInput knnInput : knnInputs) {
            FieldName name = knnInput.getField();
            if (name == null) {
                throw new MissingAttributeException((PMMLObject)knnInput, PMMLAttributes.KNNINPUT_FIELD);
            }
            FieldValue value = context.evaluate(name);
            values.add(value);
        }
        Measure measure = MeasureUtil.ensureMeasure(comparisonMeasure);
        if (measure instanceof Similarity) {
            return this.evaluateSimilarity(valueFactory, comparisonMeasure, knnInputs.getKNNInputs(), values);
        }
        if (measure instanceof Distance) {
            return this.evaluateDistance(valueFactory, comparisonMeasure, knnInputs.getKNNInputs(), values);
        }
        throw new UnsupportedElementException((PMMLObject)measure);
    }

    private <V extends Number> List<InstanceResult<V>> evaluateSimilarity(ValueFactory<V> valueFactory, ComparisonMeasure comparisonMeasure, List<KNNInput> knnInputs, List<FieldValue> values) {
        BitSet flags = MeasureUtil.toBitSet(values);
        Map<Integer, BitSet> flagMap = this.getInstanceFlags();
        ArrayList<InstanceResult<V>> result = new ArrayList<InstanceResult<V>>(flagMap.size());
        Set<Integer> rowKeys = flagMap.keySet();
        for (Integer rowKey : rowKeys) {
            BitSet instanceFlags = flagMap.get(rowKey);
            Value<V> similarity = MeasureUtil.evaluateSimilarity(valueFactory, comparisonMeasure, knnInputs, flags, instanceFlags);
            result.add(new InstanceResult.Similarity(rowKey, similarity));
        }
        return result;
    }

    private <V extends Number> List<InstanceResult<V>> evaluateDistance(ValueFactory<V> valueFactory, ComparisonMeasure comparisonMeasure, List<KNNInput> knnInputs, List<FieldValue> values) {
        Map<Integer, List<FieldValue>> valueMap = this.getInstanceValues();
        ArrayList<InstanceResult<V>> result = new ArrayList<InstanceResult<V>>(valueMap.size());
        Value<V> adjustment = MeasureUtil.calculateAdjustment(valueFactory, values);
        Set<Integer> rowKeys = valueMap.keySet();
        for (Integer rowKey : rowKeys) {
            List<FieldValue> instanceValues = valueMap.get(rowKey);
            Value<V> distance = MeasureUtil.evaluateDistance(valueFactory, comparisonMeasure, knnInputs, values, instanceValues, adjustment);
            result.add(new InstanceResult.Distance(rowKey, distance));
        }
        return result;
    }

    private <V extends Number> V calculateContinuousTarget(ValueFactory<V> valueFactory, FieldName name, List<InstanceResult<V>> instanceResults, Table<Integer, FieldName, FieldValue> table) {
        ValueAggregator<V> aggregator;
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)this.getModel();
        NearestNeighborModel.ContinuousScoringMethod continuousScoringMethod = nearestNeighborModel.getContinuousScoringMethod();
        switch (continuousScoringMethod) {
            case AVERAGE: {
                aggregator = new ValueAggregator<V>(valueFactory.newVector(0));
                break;
            }
            case WEIGHTED_AVERAGE: {
                aggregator = new ValueAggregator<V>(valueFactory.newVector(0), valueFactory.newVector(0), valueFactory.newVector(0));
                break;
            }
            case MEDIAN: {
                aggregator = new ValueAggregator<V>(valueFactory.newVector(instanceResults.size()));
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)nearestNeighborModel, (Enum<?>)continuousScoringMethod);
            }
        }
        block14: for (InstanceResult<V> instanceResult : instanceResults) {
            FieldValue value = (FieldValue)table.get((Object)instanceResult.getId(), (Object)name);
            if (Objects.equals(FieldValues.MISSING_VALUE, value)) {
                throw new MissingValueException(name);
            }
            Number number = value.asNumber();
            switch (continuousScoringMethod) {
                case AVERAGE: 
                case MEDIAN: {
                    aggregator.add(number);
                    continue block14;
                }
                case WEIGHTED_AVERAGE: {
                    InstanceResult.Distance distance = TypeUtil.cast(InstanceResult.Distance.class, instanceResult);
                    Value weight = distance.getWeight(nearestNeighborModel.getThreshold());
                    aggregator.add(number, weight.doubleValue());
                    continue block14;
                }
            }
            throw new UnsupportedAttributeException((PMMLObject)nearestNeighborModel, (Enum<?>)continuousScoringMethod);
        }
        switch (continuousScoringMethod) {
            case AVERAGE: {
                return aggregator.average().getValue();
            }
            case WEIGHTED_AVERAGE: {
                return aggregator.weightedAverage().getValue();
            }
            case MEDIAN: {
                return aggregator.median().getValue();
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)nearestNeighborModel, (Enum<?>)continuousScoringMethod);
    }

    private <V extends Number> Object calculateCategoricalTarget(final ValueFactory<V> valueFactory, FieldName name, List<InstanceResult<V>> instanceResults, Table<Integer, FieldName, FieldValue> table) {
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)this.getModel();
        VoteAggregator aggregator = new VoteAggregator<Object, V>(){

            @Override
            public ValueFactory<V> getValueFactory() {
                return valueFactory;
            }
        };
        NearestNeighborModel.CategoricalScoringMethod categoricalScoringMethod = nearestNeighborModel.getCategoricalScoringMethod();
        block4: for (InstanceResult<V> instanceResult : instanceResults) {
            FieldValue value = (FieldValue)table.get((Object)instanceResult.getId(), (Object)name);
            if (Objects.equals(FieldValues.MISSING_VALUE, value)) {
                throw new MissingValueException(name);
            }
            Object object = value.getValue();
            switch (categoricalScoringMethod) {
                case MAJORITY_VOTE: {
                    aggregator.add(object);
                    continue block4;
                }
                case WEIGHTED_MAJORITY_VOTE: {
                    InstanceResult.Distance distance = TypeUtil.cast(InstanceResult.Distance.class, instanceResult);
                    Value weight = distance.getWeight(nearestNeighborModel.getThreshold());
                    aggregator.add(object, weight.doubleValue());
                    continue block4;
                }
            }
            throw new UnsupportedAttributeException((PMMLObject)nearestNeighborModel, (Enum<?>)categoricalScoringMethod);
        }
        Set winners = aggregator.getWinners();
        if (winners.size() > 1) {
            LinkedHashMultiset multiset = LinkedHashMultiset.create();
            Map column = table.column((Object)name);
            multiset.addAll(Collections2.transform(column.values(), FieldValue::getValue));
            aggregator.clear();
            for (Object winner : winners) {
                aggregator.add(winner, multiset.count(winner));
            }
            winners = aggregator.getWinners();
            if (winners.size() > 1) {
                return Collections.min(winners);
            }
        }
        return Iterables.getFirst(winners, null);
    }

    private Function<Integer, String> createIdentifierResolver(final FieldName name, final Table<Integer, FieldName, FieldValue> table) {
        Function<Integer, String> function = new Function<Integer, String>(){

            public String apply(Integer row) {
                FieldValue value = (FieldValue)table.get((Object)row, (Object)name);
                if (Objects.equals(FieldValues.MISSING_VALUE, value)) {
                    throw new MissingValueException(name);
                }
                return value.asString();
            }
        };
        return function;
    }

    private <V extends Number> AffinityDistribution<V> createAffinityDistribution(List<InstanceResult<V>> instanceResults, Function<Integer, String> function, Object result) {
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)this.getModel();
        ComparisonMeasure comparisonMeasure = nearestNeighborModel.getComparisonMeasure();
        ValueMap<Object, Value<V>> values = new ValueMap<Object, Value<V>>(2 * instanceResults.size());
        for (InstanceResult<V> instanceResult : instanceResults) {
            values.put(function.apply((Object)instanceResult.getId()), instanceResult.getValue());
        }
        Measure measure = MeasureUtil.ensureMeasure(comparisonMeasure);
        if (measure instanceof Similarity) {
            return new AffinityDistribution(Classification.Type.SIMILARITY, values, result);
        }
        if (measure instanceof Distance) {
            return new AffinityDistribution(Classification.Type.DISTANCE, values, result);
        }
        throw new UnsupportedElementException((PMMLObject)measure);
    }

    private Table<Integer, FieldName, FieldValue> getTrainingInstances() {
        if (this.trainingInstances == null) {
            this.trainingInstances = this.getValue(trainingInstanceCache, NearestNeighborModelEvaluator.createTrainingInstanceLoader(this));
        }
        return this.trainingInstances;
    }

    private static Callable<Table<Integer, FieldName, FieldValue>> createTrainingInstanceLoader(final NearestNeighborModelEvaluator modelEvaluator) {
        return new Callable<Table<Integer, FieldName, FieldValue>>(){

            @Override
            public Table<Integer, FieldName, FieldValue> call() {
                return NearestNeighborModelEvaluator.parseTrainingInstances(modelEvaluator);
            }
        };
    }

    private static Table<Integer, FieldName, FieldValue> parseTrainingInstances(NearestNeighborModelEvaluator modelEvaluator) {
        Iterator field;
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)modelEvaluator.getModel();
        FieldName instanceIdVariable = nearestNeighborModel.getInstanceIdVariable();
        HashSet<FieldName> fieldNames = new HashSet<FieldName>();
        FieldReferenceFinder variableFinder = new FieldReferenceFinder();
        variableFinder.applyTo((Visitable)nearestNeighborModel);
        fieldNames.addAll(variableFinder.getFieldNames());
        List<TargetField> targetFields = modelEvaluator.getTargetFields();
        for (TargetField targetField : targetFields) {
            fieldNames.add(targetField.getName());
        }
        TrainingInstances trainingInstances = nearestNeighborModel.getTrainingInstances();
        ArrayList<FieldLoader> fieldLoaders = new ArrayList<FieldLoader>();
        InstanceFields instanceFields = trainingInstances.getInstanceFields();
        for (InstanceField instanceField : instanceFields) {
            FieldName name = instanceField.getField();
            if (name == null) {
                throw new MissingAttributeException((PMMLObject)instanceField, PMMLAttributes.INSTANCEFIELD_FIELD);
            }
            String column = instanceField.getColumn();
            if (instanceIdVariable != null && instanceIdVariable.equals((Object)name)) {
                fieldLoaders.add(new IdentifierLoader(name, column));
                continue;
            }
            if (!fieldNames.contains(name)) continue;
            field = modelEvaluator.resolveField(name);
            if (field == null) {
                throw new MissingFieldException(name, (PMMLObject)instanceField);
            }
            if (field instanceof DataField) {
                DataField dataField = (DataField)field;
                MiningField miningField = modelEvaluator.getMiningField(name);
                if (miningField == null) {
                    throw new InvisibleFieldException(name, (PMMLObject)instanceField);
                }
                fieldLoaders.add(new DataFieldLoader(name, column, dataField, miningField));
                continue;
            }
            if (field instanceof DerivedField) {
                DerivedField derivedField = (DerivedField)field;
                fieldLoaders.add(new DerivedFieldLoader(name, column, derivedField));
                continue;
            }
            throw new InvalidAttributeException((PMMLObject)instanceField, PMMLAttributes.INSTANCEFIELD_FIELD, name);
        }
        HashBasedTable result = HashBasedTable.create();
        InlineTable inlineTable = InlineTableUtil.getInlineTable(trainingInstances);
        if (inlineTable != null) {
            Table<Integer, String, String> table = InlineTableUtil.getContent(inlineTable);
            Set rowKeys = table.rowKeySet();
            field = rowKeys.iterator();
            while (field.hasNext()) {
                Integer rowKey = (Integer)field.next();
                Map rowValues = table.row((Object)rowKey);
                for (FieldLoader fieldLoader : fieldLoaders) {
                    result.put((Object)rowKey, (Object)fieldLoader.getName(), (Object)fieldLoader.load(rowValues));
                }
            }
        }
        KNNInputs knnInputs = nearestNeighborModel.getKNNInputs();
        for (KNNInput knnInput : knnInputs) {
            FieldName name = knnInput.getField();
            DerivedField derivedField = modelEvaluator.resolveDerivedField(name);
            if (derivedField == null) continue;
            Set rowKeys = result.rowKeySet();
            for (Integer rowKey : rowKeys) {
                Map rowValues = result.row((Object)rowKey);
                if (rowValues.containsKey(name)) continue;
                ModelEvaluationContext context = new ModelEvaluationContext(modelEvaluator);
                context.declareAll(rowValues);
                FieldValue value = ExpressionUtil.evaluateTypedExpressionContainer(derivedField, context);
                result.put((Object)rowKey, (Object)name, (Object)value);
            }
        }
        int numberOfNeighbors = nearestNeighborModel.getNumberOfNeighbors();
        if (numberOfNeighbors < 0 || result.size() < numberOfNeighbors) {
            throw new InvalidAttributeException((PMMLObject)nearestNeighborModel, PMMLAttributes.NEARESTNEIGHBORMODEL_NUMBEROFNEIGHBORS, numberOfNeighbors);
        }
        return result;
    }

    private Map<Integer, BitSet> getInstanceFlags() {
        if (this.instanceFlags == null) {
            this.instanceFlags = this.getValue(instanceFlagCache, NearestNeighborModelEvaluator.createInstanceFlagLoader(this));
        }
        return this.instanceFlags;
    }

    private static Callable<Map<Integer, BitSet>> createInstanceFlagLoader(final NearestNeighborModelEvaluator modelEvaluator) {
        return new Callable<Map<Integer, BitSet>>(){

            @Override
            public Map<Integer, BitSet> call() {
                return NearestNeighborModelEvaluator.loadInstanceFlags(modelEvaluator);
            }
        };
    }

    private static Map<Integer, BitSet> loadInstanceFlags(NearestNeighborModelEvaluator modelEvaluator) {
        LinkedHashMap<Integer, BitSet> result = new LinkedHashMap<Integer, BitSet>();
        Map<Integer, List<FieldValue>> valueMap = modelEvaluator.getValue(instanceValueCache, NearestNeighborModelEvaluator.createInstanceValueLoader(modelEvaluator));
        Maps.EntryTransformer<Integer, List<FieldValue>, BitSet> transformer = new Maps.EntryTransformer<Integer, List<FieldValue>, BitSet>(){

            public BitSet transformEntry(Integer key, List<FieldValue> value) {
                return MeasureUtil.toBitSet(value);
            }
        };
        result.putAll(Maps.transformEntries(valueMap, (Maps.EntryTransformer)transformer));
        return result;
    }

    private Map<Integer, List<FieldValue>> getInstanceValues() {
        if (this.instanceValues == null) {
            this.instanceValues = this.getValue(instanceValueCache, NearestNeighborModelEvaluator.createInstanceValueLoader(this));
        }
        return this.instanceValues;
    }

    private static Callable<Map<Integer, List<FieldValue>>> createInstanceValueLoader(final NearestNeighborModelEvaluator modelEvaluator) {
        return new Callable<Map<Integer, List<FieldValue>>>(){

            @Override
            public Map<Integer, List<FieldValue>> call() {
                return NearestNeighborModelEvaluator.loadInstanceValues(modelEvaluator);
            }
        };
    }

    private static Map<Integer, List<FieldValue>> loadInstanceValues(NearestNeighborModelEvaluator modelEvaluator) {
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)modelEvaluator.getModel();
        LinkedHashMap<Integer, List<FieldValue>> result = new LinkedHashMap<Integer, List<FieldValue>>();
        Table<Integer, FieldName, FieldValue> table = modelEvaluator.getValue(trainingInstanceCache, NearestNeighborModelEvaluator.createTrainingInstanceLoader(modelEvaluator));
        KNNInputs knnInputs = nearestNeighborModel.getKNNInputs();
        ImmutableSortedSet rowKeys = ImmutableSortedSet.copyOf((Collection)table.rowKeySet());
        for (Integer rowKey : rowKeys) {
            ArrayList<FieldValue> values = new ArrayList<FieldValue>();
            Map rowValues = table.row((Object)rowKey);
            for (KNNInput knnInput : knnInputs) {
                FieldValue value = (FieldValue)rowValues.get(knnInput.getField());
                values.add(value);
            }
            result.put(rowKey, values);
        }
        return result;
    }

    private static abstract class InstanceResult<V extends Number>
    implements Comparable<InstanceResult<V>> {
        private Integer id = null;
        private Value<V> value = null;

        private InstanceResult(Integer id, Value<V> value) {
            this.setId(id);
            this.setValue(value);
        }

        public Integer getId() {
            return this.id;
        }

        private void setId(Integer id) {
            this.id = id;
        }

        public Value<V> getValue() {
            return this.value;
        }

        private void setValue(Value<V> value) {
            this.value = value;
        }

        private static class Distance<V extends Number>
        extends InstanceResult<V> {
            private Distance(Integer id, Value<V> value) {
                super(id, value);
            }

            @Override
            public int compareTo(InstanceResult<V> that) {
                if (that instanceof Distance) {
                    return Classification.Type.DISTANCE.compareValues(this.getValue(), that.getValue());
                }
                throw new ClassCastException();
            }

            public Value<V> getWeight(double threshold) {
                Value value = this.getValue();
                value = value.copy();
                if (threshold != 0.0) {
                    value.add(threshold);
                }
                return value.reciprocal();
            }
        }

        private static class Similarity<V extends Number>
        extends InstanceResult<V> {
            private Similarity(Integer id, Value<V> value) {
                super(id, value);
            }

            @Override
            public int compareTo(InstanceResult<V> that) {
                if (that instanceof Similarity) {
                    return Classification.Type.SIMILARITY.compareValues(this.getValue(), that.getValue());
                }
                throw new ClassCastException();
            }
        }
    }

    private static class DerivedFieldLoader
    extends FieldLoader {
        private DerivedField derivedField = null;

        private DerivedFieldLoader(FieldName name, String column, DerivedField derivedField) {
            super(name, column);
            this.setDerivedField(derivedField);
        }

        @Override
        public FieldValue prepare(String value) {
            final DerivedField derivedField = this.getDerivedField();
            TypeInfo typeInfo = new TypeInfo(){

                @Override
                public DataType getDataType() {
                    DataType dataType = derivedField.getDataType();
                    if (dataType == null) {
                        throw new MissingAttributeException((PMMLObject)derivedField, PMMLAttributes.DERIVEDFIELD_DATATYPE);
                    }
                    return dataType;
                }

                @Override
                public OpType getOpType() {
                    OpType opType = derivedField.getOpType();
                    if (opType == null) {
                        throw new MissingAttributeException((PMMLObject)derivedField, PMMLAttributes.DERIVEDFIELD_OPTYPE);
                    }
                    return opType;
                }

                @Override
                public List<?> getOrdering() {
                    List<?> ordering = FieldUtil.getValidValues(derivedField);
                    return ordering;
                }
            };
            return FieldValueUtil.create(typeInfo, value);
        }

        public DerivedField getDerivedField() {
            return this.derivedField;
        }

        private void setDerivedField(DerivedField derivedField) {
            this.derivedField = derivedField;
        }
    }

    private static class DataFieldLoader
    extends FieldLoader {
        private DataField dataField = null;
        private MiningField miningField = null;

        private DataFieldLoader(FieldName name, String column, DataField dataField, MiningField miningField) {
            super(name, column);
            this.setDataField(dataField);
            this.setMiningField(miningField);
        }

        @Override
        public FieldValue prepare(String value) {
            return InputFieldUtil.prepareInputValue(this.getDataField(), this.getMiningField(), value);
        }

        public DataField getDataField() {
            return this.dataField;
        }

        private void setDataField(DataField dataField) {
            this.dataField = dataField;
        }

        public MiningField getMiningField() {
            return this.miningField;
        }

        private void setMiningField(MiningField miningField) {
            this.miningField = miningField;
        }
    }

    private static class IdentifierLoader
    extends FieldLoader {
        private IdentifierLoader(FieldName name, String column) {
            super(name, column);
        }

        @Override
        public FieldValue prepare(String value) {
            return FieldValueUtil.create(TypeInfos.CATEGORICAL_STRING, value);
        }
    }

    private static abstract class FieldLoader {
        private FieldName name = null;
        private String column = null;

        private FieldLoader(FieldName name, String column) {
            this.setName(name);
            this.setColumn(column);
        }

        public abstract FieldValue prepare(String var1);

        public FieldValue load(Map<String, String> values) {
            String value = values.get(this.getColumn());
            return this.prepare(value);
        }

        public FieldName getName() {
            return this.name;
        }

        private void setName(FieldName name) {
            this.name = name;
        }

        public String getColumn() {
            return this.column;
        }

        private void setColumn(String column) {
            this.column = column;
        }
    }
}

