/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.Cache;
import com.google.common.collect.Table;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Row;
import org.dmg.pmml.TextIndex;
import org.dmg.pmml.TextIndexNormalization;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.InlineTableUtil;
import org.jpmml.evaluator.InvalidAttributeException;
import org.jpmml.evaluator.InvalidElementException;
import org.jpmml.evaluator.LevenshteinDistanceUtil;
import org.jpmml.evaluator.MisplacedAttributeException;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.PMMLException;
import org.jpmml.evaluator.RegExUtil;
import org.jpmml.evaluator.Strings;
import org.jpmml.evaluator.TextMatcher;
import org.jpmml.evaluator.TextSplitter;
import org.jpmml.evaluator.TextTokenizer;
import org.jpmml.evaluator.UnsupportedAttributeException;

public class TextUtil {
    private static final Cache<TextIndex, Cache<String, List<String>>> textTokenCaches = CacheUtil.buildCache();
    private static final Callable<Cache<String, List<String>>> textTokenCacheLoader = new Callable<Cache<String, List<String>>>(){

        @Override
        public Cache<String, List<String>> call() {
            return CacheUtil.buildCache();
        }
    };
    private static final Cache<TextIndex, Cache<String, List<String>>> termTokenCaches = CacheUtil.buildCache();
    private static final Callable<Cache<String, List<String>>> termTokenCacheLoader = new Callable<Cache<String, List<String>>>(){

        @Override
        public Cache<String, List<String>> call() {
            return CacheUtil.buildCache();
        }
    };

    private TextUtil() {
    }

    public static String normalize(TextIndex textIndex, String string) {
        if (textIndex.hasTextIndexNormalizations()) {
            List textIndexNormalizations = textIndex.getTextIndexNormalizations();
            for (TextIndexNormalization textIndexNormalization : textIndexNormalizations) {
                string = TextUtil.normalize(textIndex, textIndexNormalization, string);
            }
        }
        return string;
    }

    public static String normalize(TextIndex textIndex, TextIndexNormalization textIndexNormalization, String string) {
        InlineTable inlineTable;
        Integer maxLevenshteinDistance;
        Boolean caseSensitive;
        TextTokenizer tokenizer = null;
        Boolean tokenize = textIndexNormalization.isTokenize();
        if (tokenize == null) {
            tokenize = textIndex.isTokenize();
        }
        if (tokenize.booleanValue()) {
            tokenizer = TextUtil.createTextTokenizer(textIndex, textIndexNormalization);
        }
        if ((caseSensitive = textIndexNormalization.isCaseSensitive()) == null) {
            caseSensitive = textIndex.isCaseSensitive();
        }
        if ((maxLevenshteinDistance = textIndexNormalization.getMaxLevenshteinDistance()) == null) {
            maxLevenshteinDistance = textIndex.getMaxLevenshteinDistance();
            if (maxLevenshteinDistance < 0) {
                throw new InvalidAttributeException((PMMLObject)textIndex, PMMLAttributes.TEXTINDEX_MAXLEVENSHTEINDISTANCE, maxLevenshteinDistance);
            }
        } else if (maxLevenshteinDistance < 0) {
            throw new InvalidAttributeException((PMMLObject)textIndexNormalization, PMMLAttributes.TEXTINDEXNORMALIZATION_MAXLEVENSHTEINDISTANCE, maxLevenshteinDistance);
        }
        if ((inlineTable = InlineTableUtil.getInlineTable(textIndexNormalization)) != null) {
            String normalizedString;
            String inField = textIndexNormalization.getInField();
            String outField = textIndexNormalization.getOutField();
            String regexField = textIndexNormalization.getRegexField();
            while (true) {
                try {
                    normalizedString = TextUtil.normalize(inlineTable, inField, outField, regexField, string, tokenizer, caseSensitive, maxLevenshteinDistance);
                }
                catch (PMMLException pe) {
                    throw pe.ensureContext((PMMLObject)textIndexNormalization);
                }
                if (!textIndexNormalization.isRecursive() || normalizedString.equals(string)) break;
                string = normalizedString;
            }
            return normalizedString;
        }
        return string;
    }

    static String normalize(InlineTable inlineTable, String inColumn, String outColumn, String regexColumn, String string, TextTokenizer tokenizer, boolean caseSensitive, int maxLevenshteinDistance) {
        Table<Integer, String, Object> table = InlineTableUtil.getContent(inlineTable);
        int regexFlags = caseSensitive ? 0 : 66;
        List rows = inlineTable.getRows();
        for (int i = 0; i < rows.size(); ++i) {
            Matcher matcher;
            Pattern pattern;
            Row row = (Row)rows.get(i);
            Integer rowKey = i + 1;
            String inValue = (String)table.get((Object)rowKey, (Object)inColumn);
            if (inValue == null) {
                throw new InvalidElementException("Cell " + PMMLException.formatKey(inColumn) + " is not defined", (PMMLObject)row);
            }
            String outValue = (String)table.get((Object)rowKey, (Object)outColumn);
            if (outValue == null) {
                throw new InvalidElementException("Cell " + PMMLException.formatKey(outColumn) + " is not defined", (PMMLObject)row);
            }
            String regexValue = (String)table.get((Object)rowKey, (Object)regexColumn);
            boolean regex = "true".equalsIgnoreCase(regexValue);
            if (regex) {
                pattern = RegExUtil.compile(inValue, regexFlags, (PMMLObject)row);
                matcher = pattern.matcher(string);
                string = matcher.replaceAll(outValue);
                continue;
            }
            pattern = RegExUtil.compile(Pattern.quote(inValue), regexFlags, (PMMLObject)row);
            matcher = pattern.matcher(string);
            string = matcher.replaceAll(outValue);
        }
        return string;
    }

    public static List<String> tokenize(TextIndex textIndex, String text) {
        boolean tokenize = textIndex.isTokenize();
        if (tokenize) {
            TextTokenizer tokenizer = TextUtil.createTextTokenizer(textIndex, null);
            return tokenizer.tokenize(text);
        }
        throw new UnsupportedAttributeException((PMMLObject)textIndex, PMMLAttributes.TEXTINDEX_TOKENIZE, tokenize);
    }

    public static int termFrequency(TextIndex textIndex, List<String> textTokens, List<String> termTokens) {
        int maxFrequency;
        boolean bestHits;
        if (textTokens.isEmpty() || termTokens.isEmpty()) {
            return 0;
        }
        boolean caseSensitive = textIndex.isCaseSensitive();
        int maxLevenshteinDistance = textIndex.getMaxLevenshteinDistance();
        if (maxLevenshteinDistance < 0) {
            throw new InvalidAttributeException((PMMLObject)textIndex, PMMLAttributes.TEXTINDEX_MAXLEVENSHTEINDISTANCE, maxLevenshteinDistance);
        }
        TextIndex.CountHits countHits = textIndex.getCountHits();
        switch (countHits) {
            case BEST_HITS: {
                bestHits = true;
                break;
            }
            case ALL_HITS: {
                bestHits = false;
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)textIndex, (Enum<?>)countHits);
            }
        }
        TextIndex.LocalTermWeights localTermWeights = textIndex.getLocalTermWeights();
        switch (localTermWeights) {
            case BINARY: {
                maxFrequency = 1;
                break;
            }
            case TERM_FREQUENCY: 
            case LOGARITHMIC: {
                maxFrequency = Integer.MAX_VALUE;
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)textIndex, (Enum<?>)localTermWeights);
            }
        }
        try {
            return TextUtil.termFrequency(textTokens, termTokens, caseSensitive, maxLevenshteinDistance, bestHits, maxFrequency);
        }
        catch (PMMLException pe) {
            throw pe.ensureContext((PMMLObject)textIndex);
        }
    }

    public static Map<List<String>, Integer> termFrequencyTable(TextIndex textIndex, List<String> textTokens, Set<List<String>> termTokenSet, int maxLength) {
        boolean caseSensitive = textIndex.isCaseSensitive();
        int maxLevenshteinDistance = textIndex.getMaxLevenshteinDistance();
        if (maxLevenshteinDistance < 0) {
            throw new InvalidAttributeException((PMMLObject)textIndex, PMMLAttributes.TEXTINDEX_MAXLEVENSHTEINDISTANCE, maxLevenshteinDistance);
        }
        return TextUtil.termFrequencyTable(textTokens, termTokenSet, caseSensitive, maxLevenshteinDistance, maxLength);
    }

    public static boolean matches(TextIndex textIndex, List<String> leftTokens, List<String> rightTokens) {
        boolean caseSensitive = textIndex.isCaseSensitive();
        int maxLevenshteinDistance = textIndex.getMaxLevenshteinDistance();
        if (maxLevenshteinDistance < 0) {
            throw new InvalidAttributeException((PMMLObject)textIndex, PMMLAttributes.TEXTINDEX_MAXLEVENSHTEINDISTANCE, maxLevenshteinDistance);
        }
        return TextUtil.matches(leftTokens, rightTokens, caseSensitive, maxLevenshteinDistance);
    }

    static int termFrequency(List<String> textTokens, List<String> termTokens, boolean caseSensitive, int maxLevenshteinDistance, boolean bestHits, int maxFrequency) {
        int frequency = 0;
        int bestLevenshteinDistance = Integer.MAX_VALUE;
        int textSize = textTokens.size();
        int termSize = termTokens.size();
        int max = textSize - termSize;
        block0: for (int i = 0; i <= max; ++i) {
            int levenshteinDistance = 0;
            for (int j = 0; j < termSize; ++j) {
                int threshold = maxLevenshteinDistance - levenshteinDistance;
                String textToken = textTokens.get(i + j);
                String termToken = termTokens.get(j);
                if (threshold == 0) {
                    boolean equals = caseSensitive ? textToken.equals(termToken) : textToken.equalsIgnoreCase(termToken);
                    if (equals) continue;
                    continue block0;
                }
                int tokenLevenshteinDistance = LevenshteinDistanceUtil.limitedCompare(textToken, termToken, caseSensitive, threshold);
                if (tokenLevenshteinDistance < 0) continue block0;
                levenshteinDistance += tokenLevenshteinDistance;
            }
            if (bestHits) {
                if (levenshteinDistance < bestLevenshteinDistance) {
                    frequency = 1;
                    bestLevenshteinDistance = levenshteinDistance;
                } else {
                    if (levenshteinDistance != bestLevenshteinDistance) continue;
                    ++frequency;
                }
                if (bestLevenshteinDistance != 0 || frequency < maxFrequency) continue;
                return frequency;
            }
            if (++frequency < maxFrequency) continue;
            return frequency;
        }
        return Math.min(maxFrequency, frequency);
    }

    static Map<List<String>, Integer> termFrequencyTable(List<String> textTokens, Set<List<String>> termTokenSet, boolean caseSensitive, int maxLevenshteinDistance, int maxLength) {
        LinkedHashMap<List<String>, Integer> result = new LinkedHashMap<List<String>, Integer>();
        int max = textTokens.size();
        for (int i = 0; i < max; ++i) {
            for (int length = 1; length <= maxLength && i + length <= max; ++length) {
                List<String> tokens = textTokens.subList(i, i + length);
                if (caseSensitive && maxLevenshteinDistance == 0) {
                    boolean matches = termTokenSet.contains(tokens);
                    if (!matches) continue;
                    Integer count = (Integer)result.get(tokens);
                    result.put(tokens, count != null ? count + 1 : 1);
                    continue;
                }
                for (List<String> termTokens : termTokenSet) {
                    if (!TextUtil.matches(tokens, termTokens, caseSensitive, maxLevenshteinDistance)) continue;
                    Integer count = (Integer)result.get(termTokens);
                    result.put(termTokens, count != null ? count + 1 : 1);
                }
            }
        }
        return result;
    }

    static boolean matches(List<String> leftTokens, List<String> rightTokens, boolean caseSensitive, int maxLevenshteinDistance) {
        if (leftTokens.size() != rightTokens.size()) {
            return false;
        }
        int levenshteinDistance = 0;
        int max = leftTokens.size();
        for (int i = 0; i < max; ++i) {
            int threshold = maxLevenshteinDistance - levenshteinDistance;
            String leftToken = leftTokens.get(i);
            String rightToken = rightTokens.get(i);
            if (threshold == 0) {
                boolean equals = caseSensitive ? leftToken.equals(rightToken) : leftToken.equalsIgnoreCase(rightToken);
                if (equals) continue;
                return false;
            }
            int tokenLevenshteinDistance = LevenshteinDistanceUtil.limitedCompare(leftToken, rightToken, caseSensitive, threshold);
            if (tokenLevenshteinDistance < 0) {
                return false;
            }
            levenshteinDistance += tokenLevenshteinDistance;
        }
        return true;
    }

    private static TextTokenizer createTextTokenizer(TextIndex textIndex, TextIndexNormalization textIndexNormalization) {
        String wordSeparatorCharacterRE;
        String wordRE;
        if (textIndexNormalization != null) {
            wordRE = textIndexNormalization.getWordRE();
            wordSeparatorCharacterRE = textIndexNormalization.getWordSeparatorCharacterRE();
            if (wordRE != null) {
                if (wordSeparatorCharacterRE != null) {
                    throw new MisplacedAttributeException((PMMLObject)textIndexNormalization, PMMLAttributes.TEXTINDEXNORMALIZATION_WORDSEPARATORCHARACTERRE, wordSeparatorCharacterRE);
                }
                return TextUtil.createTextMatcher(textIndex, textIndexNormalization);
            }
            if (wordSeparatorCharacterRE != null) {
                return TextUtil.createTextSplitter(textIndex, textIndexNormalization);
            }
        }
        wordRE = textIndex.getWordRE();
        wordSeparatorCharacterRE = textIndex.getWordSeparatorCharacterRE();
        if (wordRE != null) {
            if (wordSeparatorCharacterRE != null) {
                throw new MisplacedAttributeException((PMMLObject)textIndex, PMMLAttributes.TEXTINDEX_WORDSEPARATORCHARACTERRE, wordSeparatorCharacterRE);
            }
            return TextUtil.createTextMatcher(textIndex, null);
        }
        return TextUtil.createTextSplitter(textIndex, null);
    }

    private static TextSplitter createTextSplitter(TextIndex textIndex, TextIndexNormalization textIndexNormalization) {
        String wordSeparatorCharacterRE;
        if (textIndexNormalization != null && (wordSeparatorCharacterRE = textIndexNormalization.getWordSeparatorCharacterRE()) != null) {
            return new TextSplitter(wordSeparatorCharacterRE, (PMMLObject)textIndexNormalization);
        }
        wordSeparatorCharacterRE = textIndex.getWordSeparatorCharacterRE();
        return new TextSplitter(wordSeparatorCharacterRE, (PMMLObject)textIndex);
    }

    private static TextMatcher createTextMatcher(TextIndex textIndex, TextIndexNormalization textIndexNormalization) {
        String wordRE;
        if (textIndexNormalization != null && (wordRE = textIndexNormalization.getWordRE()) != null) {
            return new TextMatcher(wordRE, (PMMLObject)textIndexNormalization);
        }
        wordRE = textIndex.getWordRE();
        if (wordRE == null) {
            throw new MissingAttributeException((PMMLObject)textIndex, PMMLAttributes.TEXTINDEX_WORDRE);
        }
        return new TextMatcher(wordRE, (PMMLObject)textIndex);
    }

    static class TermProcessor
    extends StringProcessor {
        TermProcessor(TextIndex textIndex, String value) {
            super(textIndex, value);
        }

        @Override
        public List<String> process() {
            TextIndex textIndex = this.getTextIndex();
            String value = this.getValue();
            Cache termTokenCache = (Cache)CacheUtil.getValue(textIndex, termTokenCaches, termTokenCacheLoader);
            List<String> tokens = (List<String>)termTokenCache.getIfPresent((Object)value);
            if (tokens == null) {
                tokens = TextUtil.tokenize(textIndex, value);
                termTokenCache.put((Object)value, tokens);
            }
            return tokens;
        }
    }

    static class TextProcessor
    extends StringProcessor {
        TextProcessor(TextIndex textIndex, String value) {
            super(textIndex, value);
        }

        @Override
        public List<String> process() {
            TextIndex textIndex = this.getTextIndex();
            String value = this.getValue();
            Cache textTokenCache = (Cache)CacheUtil.getValue(textIndex, textTokenCaches, textTokenCacheLoader);
            List<String> tokens = (List<String>)textTokenCache.getIfPresent((Object)value);
            if (tokens == null) {
                String string = TextUtil.normalize(textIndex, value);
                tokens = TextUtil.tokenize(textIndex, string);
                textTokenCache.put((Object)value, tokens);
            }
            return tokens;
        }
    }

    static abstract class StringProcessor {
        private TextIndex textIndex = null;
        private String value = null;

        public StringProcessor(TextIndex textIndex, String value) {
            this.setTextIndex(Objects.requireNonNull(textIndex));
            this.setValue((String)Strings.INTERNER.intern((Object)Objects.requireNonNull(value)));
        }

        public abstract List<String> process();

        public TextIndex getTextIndex() {
            return this.textIndex;
        }

        private void setTextIndex(TextIndex textIndex) {
            this.textIndex = textIndex;
        }

        public String getValue() {
            return this.value;
        }

        private void setValue(String value) {
            this.value = value;
        }
    }
}

