/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Table;
import com.google.common.collect.TreeRangeMap;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.DiscretizeBin;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.Interval;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLElements;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InlineTableUtil;
import org.jpmml.evaluator.InvalidElementException;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.NumberUtil;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedAttributeException;

public class DiscretizationUtil {
    private static final LoadingCache<Discretize, RangeMap<Double, Object>> binRangeCache = CacheUtil.buildLoadingCache(new CacheLoader<Discretize, RangeMap<Double, Object>>(){

        public RangeMap<Double, Object> load(Discretize discretize) {
            return ImmutableRangeMap.copyOf((RangeMap)DiscretizationUtil.parseDiscretize(discretize));
        }
    });
    private static final LoadingCache<InlineTable, Map<String, RowFilter>> rowFilterCache = CacheUtil.buildLoadingCache(new CacheLoader<InlineTable, Map<String, RowFilter>>(){

        public Map<String, RowFilter> load(InlineTable inlineTable) {
            return ImmutableMap.copyOf((Map)DiscretizationUtil.parseInlineTable(inlineTable));
        }
    });

    private DiscretizationUtil() {
    }

    public static FieldValue discretize(Discretize discretize, FieldValue value) {
        Object result = DiscretizationUtil.discretize(discretize, value.asDouble());
        return FieldValueUtil.create(discretize.getDataType(DataType.STRING), OpType.CATEGORICAL, result);
    }

    public static Object discretize(Discretize discretize, Double value) {
        RangeMap<Double, Object> binRanges = CacheUtil.getValue(discretize, binRangeCache);
        Map.Entry entry = binRanges.getEntry((Comparable)value);
        if (entry != null) {
            return entry.getValue();
        }
        return discretize.getDefaultValue();
    }

    public static FieldValue mapValue(MapValues mapValues, Map<String, FieldValue> values) {
        Map<String, Object> row;
        String outputColumn = mapValues.getOutputColumn();
        if (outputColumn == null) {
            throw new MissingAttributeException((PMMLObject)mapValues, PMMLAttributes.MAPVALUES_OUTPUTCOLUMN);
        }
        DataType dataType = mapValues.getDataType(DataType.STRING);
        InlineTable inlineTable = InlineTableUtil.getInlineTable(mapValues);
        if (inlineTable != null && (row = DiscretizationUtil.match(inlineTable, values)) != null) {
            Object result = row.get(outputColumn);
            if (result == null) {
                throw new InvalidElementException((PMMLObject)inlineTable);
            }
            return FieldValueUtil.create(dataType, OpType.CATEGORICAL, result);
        }
        return FieldValueUtil.create(dataType, OpType.CATEGORICAL, mapValues.getDefaultValue());
    }

    public static Range<Double> toRange(Interval interval) {
        Double leftMargin = NumberUtil.asDouble(interval.getLeftMargin());
        Double rightMargin = NumberUtil.asDouble(interval.getRightMargin());
        if (leftMargin == null && rightMargin == null) {
            throw new MissingAttributeException((PMMLObject)interval, PMMLAttributes.INTERVAL_LEFTMARGIN);
        }
        if (leftMargin != null && rightMargin != null && NumberUtil.compare(leftMargin, rightMargin) > 0) {
            throw new InvalidElementException((PMMLObject)interval);
        }
        Interval.Closure closure = interval.getClosure();
        if (closure == null) {
            throw new MissingAttributeException((PMMLObject)interval, PMMLAttributes.INTERVAL_CLOSURE);
        }
        switch (closure) {
            case OPEN_OPEN: {
                if (leftMargin == null) {
                    return Range.lessThan((Comparable)rightMargin);
                }
                if (rightMargin == null) {
                    return Range.greaterThan((Comparable)leftMargin);
                }
                return Range.open((Comparable)leftMargin, (Comparable)rightMargin);
            }
            case OPEN_CLOSED: {
                if (leftMargin == null) {
                    return Range.atMost((Comparable)rightMargin);
                }
                if (rightMargin == null) {
                    return Range.greaterThan((Comparable)leftMargin);
                }
                return Range.openClosed((Comparable)leftMargin, (Comparable)rightMargin);
            }
            case CLOSED_OPEN: {
                if (leftMargin == null) {
                    return Range.lessThan((Comparable)rightMargin);
                }
                if (rightMargin == null) {
                    return Range.atLeast((Comparable)leftMargin);
                }
                return Range.closedOpen((Comparable)leftMargin, (Comparable)rightMargin);
            }
            case CLOSED_CLOSED: {
                if (leftMargin == null) {
                    return Range.atMost((Comparable)rightMargin);
                }
                if (rightMargin == null) {
                    return Range.atLeast((Comparable)leftMargin);
                }
                return Range.closed((Comparable)leftMargin, (Comparable)rightMargin);
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)interval, (Enum<?>)closure);
    }

    private static Map<String, Object> match(InlineTable inlineTable, Map<String, FieldValue> values) {
        Map<String, RowFilter> rowFilters = CacheUtil.getValue(inlineTable, rowFilterCache);
        Set rows = null;
        Set<Map.Entry<String, FieldValue>> entries = values.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            FieldValue value = (FieldValue)entry.getValue();
            RowFilter rowFilter = rowFilters.get(key);
            if (rowFilter == null) {
                throw new InvalidElementException((PMMLObject)inlineTable);
            }
            SetMultimap<Object, Integer> valueRowsMap = rowFilter.getValueRowsMap(value.getDataType());
            Set valueRows = valueRowsMap.get(FieldValueUtil.getValue(value));
            if (valueRows != null && !valueRows.isEmpty()) {
                if (rows == null) {
                    rows = entries.size() > 1 ? new HashSet(valueRows) : valueRows;
                } else {
                    rows.retainAll(valueRows);
                }
                if (!rows.isEmpty()) continue;
                return null;
            }
            return null;
        }
        if (rows != null && !rows.isEmpty()) {
            Table<Integer, String, Object> content = InlineTableUtil.getContent(inlineTable);
            if (rows.size() != 1) {
                throw new InvalidElementException((PMMLObject)inlineTable);
            }
            Integer n = (Integer)Iterables.getOnlyElement((Iterable)rows);
            return content.row((Object)n);
        }
        return null;
    }

    private static RangeMap<Double, Object> parseDiscretize(Discretize discretize) {
        TreeRangeMap result = TreeRangeMap.create();
        List discretizeBins = discretize.getDiscretizeBins();
        for (DiscretizeBin discretizeBin : discretizeBins) {
            Interval interval = discretizeBin.getInterval();
            if (interval == null) {
                throw new MissingElementException((PMMLObject)discretizeBin, PMMLElements.DISCRETIZEBIN_INTERVAL);
            }
            Range<Double> range = DiscretizationUtil.toRange(interval);
            Object binValue = discretizeBin.getBinValue();
            if (binValue == null) {
                throw new MissingAttributeException((PMMLObject)discretizeBin, PMMLAttributes.DISCRETIZEBIN_BINVALUE);
            }
            result.put(range, binValue);
        }
        return result;
    }

    private static Map<String, RowFilter> parseInlineTable(InlineTable inlineTable) {
        LinkedHashMap<String, RowFilter> result = new LinkedHashMap<String, RowFilter>();
        Table<Integer, String, Object> table = InlineTableUtil.getContent(inlineTable);
        Set columns = table.columnKeySet();
        for (String column : columns) {
            Map columnValues = table.column((Object)column);
            RowFilter rowFilter = new RowFilter(columnValues);
            result.put(column, rowFilter);
        }
        return result;
    }

    private static class RowFilter {
        private Map<Integer, Object> columnValues = null;
        private Map<DataType, SetMultimap<Object, Integer>> valueRowsMap = new EnumMap<DataType, SetMultimap<Object, Integer>>(DataType.class);

        private RowFilter(Map<Integer, Object> columnValues) {
            this.setColumnValues(columnValues);
        }

        public SetMultimap<Object, Integer> getValueRowsMap(DataType dataType) {
            ImmutableSetMultimap result = this.valueRowsMap.get(dataType);
            if (result == null) {
                result = ImmutableSetMultimap.copyOf(this.parseColumnValues(dataType));
                this.valueRowsMap.put(dataType, (SetMultimap<Object, Integer>)result);
            }
            return result;
        }

        private SetMultimap<Object, Integer> parseColumnValues(DataType dataType) {
            Map<Integer, Object> columnValues = this.getColumnValues();
            HashMultimap result = HashMultimap.create();
            Set<Map.Entry<Integer, Object>> entries = columnValues.entrySet();
            for (Map.Entry entry : entries) {
                Object value = TypeUtil.parseOrCast(dataType, entry.getValue());
                Integer row = (Integer)entry.getKey();
                result.put(value, (Object)row);
            }
            return result;
        }

        public Map<Integer, Object> getColumnValues() {
            return this.columnValues;
        }

        private void setColumnValues(Map<Integer, Object> columnValues) {
            this.columnValues = columnValues;
        }
    }
}

