/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.RegExUtil;
import org.jpmml.evaluator.TextTokenizer;

public class TextMatcher
extends TextTokenizer {
    public TextMatcher(String wordRE, PMMLObject context) {
        this(RegExUtil.compile(wordRE, context));
    }

    public TextMatcher(Pattern pattern) {
        super(pattern);
    }

    @Override
    public List<String> tokenize(String string) {
        Pattern pattern = this.getPattern();
        if ("".equals(string)) {
            return Collections.emptyList();
        }
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return Collections.emptyList();
        }
        ArrayList<String> tokens = new ArrayList<String>(Math.max(string.length() / 4, 16));
        do {
            tokens.add(matcher.group());
        } while (matcher.find());
        return tokens;
    }
}

