/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Value;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedAttributeException;

public class TargetFieldUtil {
    private TargetFieldUtil() {
    }

    public static Value getValidValue(DataField dataField, Object value) {
        if (value == null) {
            return null;
        }
        if (dataField.hasValues()) {
            DataType dataType = dataField.getDataType();
            if (dataType == null) {
                throw new MissingAttributeException((PMMLObject)dataField, PMMLAttributes.DATAFIELD_DATATYPE);
            }
            value = TypeUtil.parseOrCast(dataType, value);
            List pmmlValues = dataField.getValues();
            int max = pmmlValues.size();
            block4: for (int i = 0; i < max; ++i) {
                Value pmmlValue = (Value)pmmlValues.get(i);
                Object simpleValue = pmmlValue.getValue();
                if (simpleValue == null) {
                    throw new MissingAttributeException((PMMLObject)pmmlValue, PMMLAttributes.VALUE_VALUE);
                }
                Value.Property property = pmmlValue.getProperty();
                switch (property) {
                    case VALID: {
                        boolean equals = TypeUtil.equals(dataType, value, simpleValue);
                        if (!equals) continue block4;
                        return pmmlValue;
                    }
                    case INVALID: 
                    case MISSING: {
                        continue block4;
                    }
                    default: {
                        throw new UnsupportedAttributeException((PMMLObject)pmmlValue, (Enum<?>)property);
                    }
                }
            }
        }
        return null;
    }
}

