/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.primitives.Longs;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import org.jpmml.evaluator.ComplexPeriod;

public class SecondsSinceDate
extends ComplexPeriod<SecondsSinceDate> {
    private long seconds = 0L;

    public SecondsSinceDate(LocalDate epoch, LocalDateTime dateTime) {
        this(epoch, ChronoUnit.SECONDS.between(epoch.atStartOfDay(), dateTime));
    }

    public SecondsSinceDate(LocalDate epoch, long seconds) {
        super(epoch);
        this.setSeconds(seconds);
    }

    @Override
    public long longValue() {
        return this.getSeconds();
    }

    @Override
    public int compareTo(SecondsSinceDate that) {
        if (!this.getEpoch().equals(that.getEpoch())) {
            throw new ClassCastException();
        }
        return Long.compare(this.getSeconds(), that.getSeconds());
    }

    public int hashCode() {
        return 31 * this.getEpoch().hashCode() + Longs.hashCode((long)this.getSeconds());
    }

    public boolean equals(Object object) {
        if (object instanceof SecondsSinceDate) {
            SecondsSinceDate that = (SecondsSinceDate)object;
            return this.getEpoch().equals(that.getEpoch()) && this.getSeconds() == that.getSeconds();
        }
        return false;
    }

    public long getSeconds() {
        return this.seconds;
    }

    private void setSeconds(long seconds) {
        this.seconds = seconds;
    }
}

