/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import org.jpmml.evaluator.NotImplementedException;
import org.jpmml.evaluator.UndefinedResultException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.Vector;

public class ValueAggregator<V extends Number> {
    private Vector<V> values = null;
    private Vector<V> weights = null;
    private Vector<V> weightedValues = null;

    protected ValueAggregator(Vector<V> values) {
        this(values, null, null);
    }

    protected ValueAggregator(Vector<V> values, Vector<V> weights) {
        this(values, weights, null);
    }

    protected ValueAggregator(Vector<V> values, Vector<V> weights, Vector<V> weightedValues) {
        this.values = values;
        this.weights = weights;
        this.weightedValues = weightedValues;
    }

    public void add(Number value) {
        if (this.weights != null || this.weightedValues != null) {
            throw new IllegalStateException();
        }
        this.values.add(value);
    }

    public void add(Number value, Number weight) {
        if (this.weights == null) {
            throw new IllegalStateException();
        }
        if (weight.doubleValue() < 0.0) {
            throw new IllegalArgumentException();
        }
        this.values.add(value);
        this.weights.add(weight);
        if (this.weightedValues != null) {
            if (weight.doubleValue() != 1.0) {
                this.weightedValues.add(weight, value);
            } else {
                this.weightedValues.add(value);
            }
        }
    }

    public Value<V> average() {
        if (this.weights != null) {
            throw new IllegalStateException();
        }
        int size = this.values.size();
        if (size == 0) {
            throw new UndefinedResultException();
        }
        return this.values.sum().divide(size);
    }

    public Value<V> weightedAverage() {
        if (this.weights == null || this.weightedValues == null) {
            throw new IllegalStateException();
        }
        int size = this.weightedValues.size();
        if (size == 0) {
            throw new UndefinedResultException();
        }
        Value<V> weightSum = this.weights.sum();
        if (weightSum.isZero()) {
            throw new UndefinedResultException();
        }
        return this.weightedValues.sum().divide(weightSum);
    }

    public Value<V> sum() {
        if (this.weights != null) {
            throw new IllegalStateException();
        }
        return this.values.sum();
    }

    public Value<V> weightedSum() {
        if (this.weights == null || this.weightedValues == null) {
            throw new IllegalArgumentException();
        }
        return this.weightedValues.sum();
    }

    public Value<V> median() {
        if (this.weights != null) {
            throw new IllegalStateException();
        }
        int size = this.values.size();
        if (size == 0) {
            throw new UndefinedResultException();
        }
        return this.values.median();
    }

    public Value<V> weightedMedian() {
        if (this.weights == null) {
            throw new IllegalStateException();
        }
        int size = this.values.size();
        if (size == 0) {
            throw new UndefinedResultException();
        }
        ArrayList<Entry> entries = new ArrayList<Entry>(size);
        for (int i = 0; i < size; ++i) {
            Entry entry = new Entry(this.values.get(i), this.weights.get(i));
            entries.add(entry);
        }
        Collections.sort(entries);
        double weightSumThreshold = 0.5 * this.weights.sum().doubleValue();
        double weightSum = 0.0;
        for (Entry entry : entries) {
            if (!((weightSum += entry.weight.doubleValue()) >= weightSumThreshold)) continue;
            return entry.value;
        }
        throw new NotImplementedException();
    }

    public static class WeightedMedian<V extends Number>
    extends ValueAggregator<V> {
        public WeightedMedian(ValueFactory<V> valueFactory, int capacity) {
            super(valueFactory.newVector(capacity), valueFactory.newVector(capacity));
        }
    }

    public static class Median<V extends Number>
    extends ValueAggregator<V> {
        public Median(ValueFactory<V> valueFactory, int capacity) {
            super(valueFactory.newVector(capacity));
        }
    }

    public static class WeightedUnivariateStatistic<V extends Number>
    extends ValueAggregator<V> {
        public WeightedUnivariateStatistic(ValueFactory<V> valueFactory) {
            super(valueFactory.newVector(0), valueFactory.newVector(0), valueFactory.newVector(0));
        }
    }

    public static class UnivariateStatistic<V extends Number>
    extends ValueAggregator<V> {
        public UnivariateStatistic(ValueFactory<V> valueFactory) {
            super(valueFactory.newVector(0));
        }
    }

    private class Entry
    implements Comparable<Entry> {
        private Value<V> value;
        private Value<V> weight;

        private Entry(Value<V> value, Value<V> weight) {
            this.value = value;
            this.weight = weight;
        }

        @Override
        public int compareTo(Entry that) {
            return this.value.compareTo(that.value);
        }
    }
}

