/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InputFieldUtil;
import org.jpmml.evaluator.InvisibleFieldException;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.mining.MiningModelEvaluationContext;
import org.jpmml.model.UnsupportedAttributeException;

public class ModelEvaluationContext
extends EvaluationContext {
    private ModelEvaluator<?> modelEvaluator = null;
    private MiningModelEvaluationContext parent = null;
    private Map<String, ?> arguments = Collections.emptyMap();

    public ModelEvaluationContext(ModelEvaluator<?> modelEvaluator) {
        super(modelEvaluator.getNumberOfVisibleFields());
        this.setModelEvaluator(modelEvaluator);
    }

    @Override
    public void reset(boolean clearValues) {
        super.reset(clearValues);
        this.arguments = Collections.emptyMap();
    }

    @Override
    protected FieldValue prepare(String name, Object value) {
        ModelEvaluator<?> modelEvaluator = this.getModelEvaluator();
        DataField dataField = modelEvaluator.getDataField(name);
        if (dataField == null) {
            throw new MissingFieldException(name);
        }
        MiningField miningField = modelEvaluator.getMiningField(name);
        if (miningField == null) {
            throw new InvisibleFieldException(name);
        }
        MiningField.UsageType usageType = miningField.getUsageType();
        switch (usageType) {
            case ACTIVE: 
            case SUPPLEMENTARY: 
            case GROUP: 
            case ORDER: {
                return InputFieldUtil.prepareInputValue(dataField, miningField, value);
            }
            case PREDICTED: 
            case TARGET: {
                return InputFieldUtil.prepareResidualInputValue(dataField, miningField, value);
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)miningField, (Enum)usageType);
    }

    @Override
    protected FieldValue resolve(String name) {
        ModelEvaluator<?> modelEvaluator = this.getModelEvaluator();
        MiningModelEvaluationContext parent = this.getParent();
        MiningField miningField = modelEvaluator.getMiningField(name);
        if (miningField == null) {
            DerivedField localDerivedField = modelEvaluator.getLocalDerivedField(name);
            if (localDerivedField != null) {
                FieldValue value = ExpressionUtil.evaluate(localDerivedField, (EvaluationContext)this);
                return this.declare(name, value);
            }
            DerivedField derivedField = modelEvaluator.getDerivedField(name);
            if (derivedField != null) {
                FieldValue value = parent != null && modelEvaluator.isParentCompatible() ? parent.evaluate(name) : ExpressionUtil.evaluate(derivedField, (EvaluationContext)this);
                return this.declare(name, value);
            }
        } else {
            Field<?> field;
            DataField dataField = modelEvaluator.getDataField(name);
            if (dataField != null) {
                Map<String, ?> arguments = this.getArguments();
                if (parent != null) {
                    FieldValue value = parent.evaluate(name);
                    return this.declare(name, ModelEvaluationContext.inheritOrPrepareInputValue(dataField, miningField, value));
                }
                Object value = arguments.get(name);
                return this.declare(name, value);
            }
            if (parent != null && (field = ModelEvaluationContext.resolveField(name, parent)) != null) {
                FieldValue value = parent.evaluate(name);
                return this.declare(name, ModelEvaluationContext.inheritOrPrepareInputValue(field, miningField, value));
            }
        }
        throw new MissingFieldException(name);
    }

    @Override
    protected DefineFunction getDefineFunction(String name) {
        ModelEvaluator<?> modelEvaluator = this.getModelEvaluator();
        DefineFunction defineFunction = modelEvaluator.getDefineFunction(name);
        return defineFunction;
    }

    public ModelEvaluator<?> getModelEvaluator() {
        return this.modelEvaluator;
    }

    public void setModelEvaluator(ModelEvaluator<?> modelEvaluator) {
        this.modelEvaluator = Objects.requireNonNull(modelEvaluator);
    }

    public MiningModelEvaluationContext getParent() {
        return this.parent;
    }

    public void setParent(MiningModelEvaluationContext parent) {
        this.parent = parent;
    }

    public Map<String, ?> getArguments() {
        return this.arguments;
    }

    public void setArguments(Map<String, ?> arguments) {
        this.arguments = Objects.requireNonNull(arguments);
    }

    private static Field<?> resolveField(String name, MiningModelEvaluationContext context) {
        while (context != null) {
            OutputField outputField = context.getOutputField(name);
            if (outputField != null) {
                return outputField;
            }
            DerivedField localDerivedField = context.getLocalDerivedField(name);
            if (localDerivedField != null) {
                return localDerivedField;
            }
            context = context.getParent();
        }
        return null;
    }

    private static FieldValue inheritOrPrepareInputValue(Field<?> field, MiningField miningField, FieldValue value) {
        if (InputFieldUtil.isDefault(field, miningField)) {
            return value;
        }
        return InputFieldUtil.prepareInputValue(field, miningField, FieldValueUtil.getValue(value));
    }
}

