/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.mining;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.dmg.pmml.DataType;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.True;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.PMMLAttributes;
import org.dmg.pmml.mining.Segment;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.mining.VariableWeight;
import org.jpmml.evaluator.Configuration;
import org.jpmml.evaluator.DefaultDataField;
import org.jpmml.evaluator.DuplicateFieldValueException;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.MissingFieldValueException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.evaluator.OutputField;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.PMMLUtil;
import org.jpmml.evaluator.PredicateUtil;
import org.jpmml.evaluator.SyntheticTargetField;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.ValueUtil;
import org.jpmml.evaluator.mining.AggregateProbabilityDistribution;
import org.jpmml.evaluator.mining.AggregateScore;
import org.jpmml.evaluator.mining.AggregateVoteDistribution;
import org.jpmml.evaluator.mining.MiningModelEvaluationContext;
import org.jpmml.evaluator.mining.MiningModelUtil;
import org.jpmml.evaluator.mining.SegmentResult;
import org.jpmml.evaluator.mining.SegmentationResult;
import org.jpmml.model.InvalidAttributeException;
import org.jpmml.model.InvalidElementException;
import org.jpmml.model.PMMLException;
import org.jpmml.model.UnsupportedAttributeException;
import org.jpmml.model.UnsupportedElementException;
import org.jpmml.model.UnsupportedElementListException;
import org.jpmml.model.XPathUtil;

public class MiningModelEvaluator
extends ModelEvaluator<MiningModel>
implements HasEntityRegistry<Segment> {
    private BiMap<String, Segment> entityRegistry = ImmutableBiMap.of();
    private Map<String, Set<ResultFeature>> segmentResultFeatures = Collections.emptyMap();
    private ConcurrentMap<String, ModelEvaluator<?>> segmentModelEvaluators = new ConcurrentHashMap();

    private MiningModelEvaluator() {
    }

    public MiningModelEvaluator(PMML pmml) {
        this(pmml, PMMLUtil.findModel(pmml, MiningModel.class));
    }

    public MiningModelEvaluator(PMML pmml, MiningModel miningModel) {
        super(pmml, miningModel);
        if (miningModel.hasEmbeddedModels()) {
            List embeddedModels = miningModel.getEmbeddedModels();
            throw new UnsupportedElementListException(embeddedModels);
        }
        Segmentation segmentation = miningModel.requireSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.requireMultipleModelMethod();
        List segments = segmentation.requireSegments();
        this.entityRegistry = ImmutableBiMap.copyOf(EntityUtil.buildBiMap(segments));
        for (Segment segment : segments) {
            VariableWeight variableWeight = segment.getVariableWeight();
            if (variableWeight == null) continue;
            throw new UnsupportedElementException((PMMLObject)variableWeight);
        }
        LocalTransformations localTransformations = segmentation.getLocalTransformations();
        if (localTransformations != null) {
            throw new UnsupportedElementException((PMMLObject)localTransformations);
        }
        Output output = miningModel.getOutput();
        if (output != null && output.hasOutputFields()) {
            this.segmentResultFeatures = ImmutableMap.copyOf(MiningModelEvaluator.toImmutableSetMap(MiningModelEvaluator.collectSegmentResultFeatures(output)));
        }
    }

    protected Set<ResultFeature> getSegmentResultFeatures(String segmentId) {
        return this.segmentResultFeatures.get(segmentId);
    }

    @Override
    public void configure(Configuration configuration) {
        super.configure(configuration);
        this.segmentModelEvaluators.clear();
    }

    @Override
    public String getSummary() {
        return "Ensemble model";
    }

    @Override
    public DefaultDataField getDefaultDataField() {
        MiningModel miningModel = (MiningModel)this.getModel();
        Segmentation segmentation = miningModel.requireSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.requireMultipleModelMethod();
        switch (multipleModelMethod) {
            case SELECT_FIRST: 
            case SELECT_ALL: 
            case MODEL_CHAIN: 
            case MULTI_MODEL_CHAIN: {
                return null;
            }
        }
        return super.getDefaultDataField();
    }

    @Override
    public boolean isPure() {
        return false;
    }

    @Override
    public String getTargetName() {
        List<TargetField> targetFields = super.getTargetFields();
        if (targetFields.isEmpty()) {
            return Evaluator.DEFAULT_TARGET_NAME;
        }
        return super.getTargetName();
    }

    @Override
    public BiMap<String, Segment> getEntityRegistry() {
        return this.entityRegistry;
    }

    @Override
    protected List<OutputField> createOutputFields() {
        List<OutputField> outputFields = super.createOutputFields();
        List<OutputField> nestedOutputFields = this.createNestedOutputFields();
        if (!nestedOutputFields.isEmpty()) {
            outputFields.addAll(0, nestedOutputFields);
        }
        return outputFields;
    }

    @Override
    protected int getNumberOfVisibleFields() {
        return -1;
    }

    @Override
    public ModelEvaluationContext createEvaluationContext() {
        return new MiningModelEvaluationContext(this);
    }

    public SegmentationResult evaluateInternal(ModelEvaluationContext context) {
        return (SegmentationResult)((Object)super.evaluateInternal((MiningModelEvaluationContext)context));
    }

    protected <V extends Number> SegmentationResult evaluateRegression(ValueFactory<V> valueFactory, EvaluationContext context) {
        final List<SegmentResult> segmentResults = this.evaluateSegmentation((MiningModelEvaluationContext)context);
        SegmentationResult segmentationResult = new SegmentationResult(this.evaluateRegressionInternal(valueFactory, segmentResults, context)){

            @Override
            public BiMap<String, Segment> getEntityRegistry() {
                return MiningModelEvaluator.this.getEntityRegistry();
            }

            public List<SegmentResult> getSegmentResults() {
                return segmentResults;
            }
        };
        return segmentationResult;
    }

    private <V extends Number> Map<String, ?> evaluateRegressionInternal(ValueFactory<V> valueFactory, final List<SegmentResult> segmentResults, EvaluationContext context) {
        AggregateScore result;
        MiningModel miningModel = (MiningModel)this.getModel();
        if (MiningModelEvaluator.isEmpty(segmentResults)) {
            return TargetUtil.evaluateRegressionDefault(valueFactory, this.getTargetFields());
        }
        Segmentation segmentation = miningModel.requireSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.requireMultipleModelMethod();
        Segmentation.MissingPredictionTreatment missingPredictionTreatment = segmentation.getMissingPredictionTreatment();
        Number missingThreshold = segmentation.getMissingThreshold();
        if (missingThreshold.doubleValue() < 0.0 || missingThreshold.doubleValue() > 1.0) {
            throw new InvalidAttributeException((PMMLObject)segmentation, PMMLAttributes.SEGMENTATION_MISSINGTHRESHOLD, (Object)missingThreshold);
        }
        switch (multipleModelMethod) {
            case SELECT_FIRST: {
                return this.selectFirst(segmentResults);
            }
            case SELECT_ALL: {
                return this.selectAll(segmentResults);
            }
            case MODEL_CHAIN: {
                return this.modelChain(segmentResults);
            }
            case MULTI_MODEL_CHAIN: {
                return this.multiModelChain(segmentResults);
            }
        }
        TargetField targetField = this.getTargetField();
        switch (multipleModelMethod) {
            case AVERAGE: 
            case WEIGHTED_AVERAGE: 
            case MEDIAN: 
            case WEIGHTED_MEDIAN: 
            case SUM: 
            case WEIGHTED_SUM: {
                Value<V> value = MiningModelUtil.aggregateValues(valueFactory, multipleModelMethod, missingPredictionTreatment, missingThreshold, segmentResults);
                if (value == null) {
                    return TargetUtil.evaluateRegressionDefault(valueFactory, targetField);
                }
                value = TargetUtil.evaluateRegressionInternal(targetField, value);
                result = new AggregateScore<V>(value){

                    @Override
                    public Collection<? extends SegmentResult> getSegmentResults() {
                        return segmentResults;
                    }
                };
                break;
            }
            case MAJORITY_VOTE: 
            case WEIGHTED_MAJORITY_VOTE: 
            case MAX: {
                throw new InvalidAttributeException((PMMLObject)segmentation, (Enum)multipleModelMethod);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)segmentation, (Enum)multipleModelMethod);
            }
        }
        return TargetUtil.evaluateRegression(targetField, result);
    }

    protected <V extends Number> SegmentationResult evaluateClassification(ValueFactory<V> valueFactory, EvaluationContext context) {
        final List<SegmentResult> segmentResults = this.evaluateSegmentation((MiningModelEvaluationContext)context);
        SegmentationResult segmentationResult = new SegmentationResult(this.evaluateClassificationInternal(valueFactory, segmentResults, context)){

            @Override
            public BiMap<String, Segment> getEntityRegistry() {
                return MiningModelEvaluator.this.getEntityRegistry();
            }

            public List<SegmentResult> getSegmentResults() {
                return segmentResults;
            }
        };
        return segmentationResult;
    }

    private <V extends Number> Map<String, ?> evaluateClassificationInternal(ValueFactory<V> valueFactory, final List<SegmentResult> segmentResults, EvaluationContext context) {
        AggregateProbabilityDistribution result;
        MiningModel miningModel = (MiningModel)this.getModel();
        if (MiningModelEvaluator.isEmpty(segmentResults)) {
            return TargetUtil.evaluateClassificationDefault(valueFactory, this.getTargetFields());
        }
        Segmentation segmentation = miningModel.requireSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.requireMultipleModelMethod();
        Segmentation.MissingPredictionTreatment missingPredictionTreatment = segmentation.getMissingPredictionTreatment();
        Number missingThreshold = segmentation.getMissingThreshold();
        if (missingThreshold.doubleValue() < 0.0 || missingThreshold.doubleValue() > 1.0) {
            throw new InvalidAttributeException((PMMLObject)segmentation, PMMLAttributes.SEGMENTATION_MISSINGTHRESHOLD, (Object)missingThreshold);
        }
        switch (multipleModelMethod) {
            case SELECT_FIRST: {
                return this.selectFirst(segmentResults);
            }
            case SELECT_ALL: {
                return this.selectAll(segmentResults);
            }
            case MODEL_CHAIN: {
                return this.modelChain(segmentResults);
            }
            case MULTI_MODEL_CHAIN: {
                return this.multiModelChain(segmentResults);
            }
        }
        TargetField targetField = this.getTargetField();
        switch (multipleModelMethod) {
            case MAJORITY_VOTE: 
            case WEIGHTED_MAJORITY_VOTE: {
                ValueMap<Object, V> values = MiningModelUtil.aggregateVotes(valueFactory, multipleModelMethod, missingPredictionTreatment, missingThreshold, segmentResults);
                if (values == null) {
                    return TargetUtil.evaluateClassificationDefault(valueFactory, targetField);
                }
                ValueUtil.normalizeSimpleMax(values);
                result = new AggregateProbabilityDistribution<V>(values){

                    @Override
                    public Collection<? extends SegmentResult> getSegmentResults() {
                        return segmentResults;
                    }
                };
                break;
            }
            case AVERAGE: 
            case WEIGHTED_AVERAGE: 
            case MEDIAN: 
            case MAX: {
                List<Object> targetCategories = targetField.getCategories();
                if (targetCategories != null && targetCategories.size() < 2) {
                    throw new InvalidElementException((PMMLObject)miningModel);
                }
                ValueMap<Object, V> values = MiningModelUtil.aggregateProbabilities(valueFactory, multipleModelMethod, missingPredictionTreatment, missingThreshold, targetCategories, segmentResults);
                if (values == null) {
                    return TargetUtil.evaluateClassificationDefault(valueFactory, targetField);
                }
                result = new AggregateProbabilityDistribution<V>(values){

                    @Override
                    public Collection<? extends SegmentResult> getSegmentResults() {
                        return segmentResults;
                    }
                };
                break;
            }
            case WEIGHTED_MEDIAN: 
            case SUM: 
            case WEIGHTED_SUM: {
                throw new InvalidAttributeException((PMMLObject)segmentation, (Enum)multipleModelMethod);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)segmentation, (Enum)multipleModelMethod);
            }
        }
        return TargetUtil.evaluateClassification(targetField, result);
    }

    protected <V extends Number> SegmentationResult evaluateClustering(ValueFactory<V> valueFactory, EvaluationContext context) {
        final List<SegmentResult> segmentResults = this.evaluateSegmentation((MiningModelEvaluationContext)context);
        SegmentationResult segmentationResult = new SegmentationResult(this.evaluateClusteringInternal(valueFactory, segmentResults, context)){

            @Override
            public BiMap<String, Segment> getEntityRegistry() {
                return MiningModelEvaluator.this.getEntityRegistry();
            }

            public List<SegmentResult> getSegmentResults() {
                return segmentResults;
            }
        };
        return segmentationResult;
    }

    private <V extends Number> Map<String, ?> evaluateClusteringInternal(ValueFactory<V> valueFactory, final List<SegmentResult> segmentResults, EvaluationContext context) {
        AggregateVoteDistribution result;
        MiningModel miningModel = (MiningModel)this.getModel();
        if (MiningModelEvaluator.isEmpty(segmentResults)) {
            return TargetUtil.evaluateDefault(this.getTargetFields());
        }
        Segmentation segmentation = miningModel.requireSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.requireMultipleModelMethod();
        Segmentation.MissingPredictionTreatment missingPredictionTreatment = segmentation.getMissingPredictionTreatment();
        Number missingThreshold = segmentation.getMissingThreshold();
        if (missingThreshold.doubleValue() < 0.0 || missingThreshold.doubleValue() > 1.0) {
            throw new InvalidAttributeException((PMMLObject)segmentation, PMMLAttributes.SEGMENTATION_MISSINGTHRESHOLD, (Object)missingThreshold);
        }
        switch (multipleModelMethod) {
            case SELECT_FIRST: {
                return this.selectFirst(segmentResults);
            }
            case SELECT_ALL: {
                return this.selectAll(segmentResults);
            }
            case MODEL_CHAIN: {
                return this.modelChain(segmentResults);
            }
            case MULTI_MODEL_CHAIN: {
                return this.multiModelChain(segmentResults);
            }
        }
        switch (multipleModelMethod) {
            case MAJORITY_VOTE: 
            case WEIGHTED_MAJORITY_VOTE: {
                ValueMap<Object, V> values = MiningModelUtil.aggregateVotes(valueFactory, multipleModelMethod, missingPredictionTreatment, missingThreshold, segmentResults);
                if (values == null) {
                    return Collections.singletonMap(this.getTargetName(), null);
                }
                result = new AggregateVoteDistribution<V>(values){

                    @Override
                    public Collection<? extends SegmentResult> getSegmentResults() {
                        return segmentResults;
                    }
                };
                break;
            }
            case AVERAGE: 
            case WEIGHTED_AVERAGE: 
            case MEDIAN: 
            case WEIGHTED_MEDIAN: 
            case SUM: 
            case WEIGHTED_SUM: 
            case MAX: {
                throw new InvalidAttributeException((PMMLObject)segmentation, (Enum)multipleModelMethod);
            }
            case SELECT_FIRST: 
            case SELECT_ALL: 
            case MODEL_CHAIN: 
            case MULTI_MODEL_CHAIN: {
                throw new InvalidAttributeException((PMMLObject)segmentation, (Enum)multipleModelMethod);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)segmentation, (Enum)multipleModelMethod);
            }
        }
        result.computeResult(DataType.STRING);
        return Collections.singletonMap(this.getTargetName(), result);
    }

    protected <V extends Number> SegmentationResult evaluateAssociationRules(ValueFactory<V> valueFactory, EvaluationContext context) {
        return this.evaluateAny(valueFactory, context);
    }

    protected <V extends Number> SegmentationResult evaluateMixed(ValueFactory<V> valueFactory, EvaluationContext context) {
        return this.evaluateAny(valueFactory, context);
    }

    private <V extends Number> SegmentationResult evaluateAny(ValueFactory<V> valueFactory, EvaluationContext context) {
        final List<SegmentResult> segmentResults = this.evaluateSegmentation((MiningModelEvaluationContext)context);
        SegmentationResult segmentationResult = new SegmentationResult(this.evaluateAnyInternal(valueFactory, segmentResults, context)){

            @Override
            public BiMap<String, Segment> getEntityRegistry() {
                return MiningModelEvaluator.this.getEntityRegistry();
            }

            public List<SegmentResult> getSegmentResults() {
                return segmentResults;
            }
        };
        return segmentationResult;
    }

    private <V extends Number> Map<String, ?> evaluateAnyInternal(ValueFactory<V> valueFactory, List<SegmentResult> segmentResults, EvaluationContext context) {
        MiningModel miningModel = (MiningModel)this.getModel();
        if (MiningModelEvaluator.isEmpty(segmentResults)) {
            return TargetUtil.evaluateDefault(this.getTargetFields());
        }
        Segmentation segmentation = miningModel.requireSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.requireMultipleModelMethod();
        Segmentation.MissingPredictionTreatment missingPredictionTreatment = segmentation.getMissingPredictionTreatment();
        switch (multipleModelMethod) {
            case SELECT_FIRST: {
                return this.selectFirst(segmentResults);
            }
            case SELECT_ALL: {
                return this.selectAll(segmentResults);
            }
            case MODEL_CHAIN: {
                return this.modelChain(segmentResults);
            }
            case MULTI_MODEL_CHAIN: {
                return this.multiModelChain(segmentResults);
            }
            case AVERAGE: 
            case WEIGHTED_AVERAGE: 
            case MEDIAN: 
            case WEIGHTED_MEDIAN: 
            case SUM: 
            case WEIGHTED_SUM: 
            case MAJORITY_VOTE: 
            case WEIGHTED_MAJORITY_VOTE: 
            case MAX: {
                throw new InvalidAttributeException((PMMLObject)segmentation, (Enum)multipleModelMethod);
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)segmentation, (Enum)multipleModelMethod);
    }

    protected SegmentationResult evaluateOutput(Map<String, ?> predictions, ModelEvaluationContext context) {
        SegmentationResult segmentationResult = (SegmentationResult)((Object)predictions);
        segmentationResult.setResults(OutputUtil.evaluate(segmentationResult.getResults(), context));
        return segmentationResult;
    }

    protected SegmentationResult processResults(Map<String, ?> results) {
        SegmentationResult segmentationResult = (SegmentationResult)((Object)results);
        segmentationResult.setResults(super.processResults(segmentationResult.getResults()));
        return segmentationResult;
    }

    private List<SegmentResult> evaluateSegmentation(MiningModelEvaluationContext context) {
        MiningModel miningModel = (MiningModel)this.getModel();
        BiMap<String, Segment> entityRegistry = this.getEntityRegistry();
        MiningFunction miningFunction = miningModel.requireMiningFunction();
        Segmentation segmentation = miningModel.requireSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.requireMultipleModelMethod();
        Segmentation.MissingPredictionTreatment missingPredictionTreatment = segmentation.getMissingPredictionTreatment();
        LinkedHashSet<String> resultNames = null;
        Model lastModel = null;
        ModelEvaluationContext miningModelContext = null;
        ModelEvaluationContext modelContext = null;
        List segments = segmentation.requireSegments();
        ArrayList<SegmentResult> segmentResults = new ArrayList<SegmentResult>(segments.size());
        int max = segments.size();
        for (int i = 0; i < max; ++i) {
            Map<String, ?> results;
            ModelEvaluationContext segmentContext;
            Segment segment = (Segment)segments.get(i);
            Boolean status = PredicateUtil.evaluatePredicateContainer(segment, context);
            if (status == null || !status.booleanValue()) continue;
            Model model = segment.requireModel();
            switch (multipleModelMethod) {
                case MODEL_CHAIN: {
                    break;
                }
                default: {
                    MiningModelEvaluator.checkMiningFunction(model, miningFunction);
                }
            }
            final String segmentId = EntityUtil.getId(segment, entityRegistry);
            final ModelEvaluator<?> segmentModelEvaluator = this.ensureSegmentModelEvaluator(segmentId, model);
            if (segmentModelEvaluator instanceof MiningModelEvaluator) {
                if (miningModelContext == null) {
                    miningModelContext = (MiningModelEvaluationContext)segmentModelEvaluator.createEvaluationContext();
                    miningModelContext.setParent(context);
                } else {
                    miningModelContext.setModelEvaluator(segmentModelEvaluator);
                }
                segmentContext = miningModelContext;
            } else {
                if (modelContext == null) {
                    modelContext = segmentModelEvaluator.createEvaluationContext();
                    modelContext.setParent(context);
                } else {
                    modelContext.setModelEvaluator(segmentModelEvaluator);
                }
                segmentContext = modelContext;
            }
            try {
                results = segmentModelEvaluator.evaluateInternal(segmentContext);
            }
            catch (PMMLException pe) {
                throw pe.ensureContext((PMMLObject)segment);
            }
            SegmentResult segmentResult = new SegmentResult(segment, results){

                @Override
                public String getEntityId() {
                    return segmentId;
                }

                @Override
                protected ModelEvaluator<?> getModelEvaluator() {
                    return segmentModelEvaluator;
                }
            };
            context.putResult(segmentId, segmentResult);
            List<String> segmentWarnings = segmentContext.getWarnings();
            if (!segmentWarnings.isEmpty()) {
                for (String segmentWarning : segmentWarnings) {
                    context.addWarning(segmentWarning);
                }
            }
            boolean skipSegment = false;
            block5 : switch (missingPredictionTreatment) {
                case RETURN_MISSING: {
                    boolean hasMissingTargetValues = segmentResult.hasMissingTargetValues();
                    if (!hasMissingTargetValues) break;
                    return null;
                }
                case SKIP_SEGMENT: {
                    switch (multipleModelMethod) {
                        case SELECT_FIRST: {
                            skipSegment = segmentResult.hasMissingTargetValues();
                            break block5;
                        }
                        case SELECT_ALL: {
                            throw new UnsupportedAttributeException((PMMLObject)segmentation, (Enum)missingPredictionTreatment);
                        }
                        case MODEL_CHAIN: 
                        case MULTI_MODEL_CHAIN: {
                            throw new InvalidAttributeException((PMMLObject)segmentation, (Enum)missingPredictionTreatment);
                        }
                    }
                    skipSegment = true;
                    break;
                }
                case CONTINUE: {
                    break;
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)segmentation, (Enum)missingPredictionTreatment);
                }
            }
            if (!skipSegment) {
                switch (multipleModelMethod) {
                    case SELECT_FIRST: {
                        return Collections.singletonList(segmentResult);
                    }
                    case SELECT_ALL: {
                        Set names = segmentResult.keySet();
                        if (resultNames == null) {
                            resultNames = new LinkedHashSet<String>(names);
                            break;
                        }
                        if (names.equals(resultNames)) break;
                        Function<String, String> function = new Function<String, String>(){

                            public String apply(String name) {
                                return EvaluationException.formatName(name);
                            }
                        };
                        throw new EvaluationException("Field sets " + Iterables.transform((Iterable)names, (Function)function) + " and " + Iterables.transform((Iterable)segmentResult.keySet(), (Function)function) + " do not match");
                    }
                    case MODEL_CHAIN: {
                        break;
                    }
                    case MULTI_MODEL_CHAIN: {
                        Set names = segmentResult.keySet();
                        if (resultNames == null) {
                            resultNames = new LinkedHashSet(segments.size() * names.size());
                            resultNames.addAll(names);
                            break;
                        }
                        for (String name : names) {
                            boolean unique = resultNames.add(name);
                            if (unique) continue;
                            throw new DuplicateFieldValueException(name);
                        }
                        break;
                    }
                }
                switch (multipleModelMethod) {
                    case MODEL_CHAIN: 
                    case MULTI_MODEL_CHAIN: {
                        Object segmentModel = segmentModelEvaluator.getModel();
                        Output segmentOutput = segmentModel.getOutput();
                        if (segmentOutput == null || !segmentOutput.hasOutputFields()) break;
                        List pmmlSegmentOutputFields = segmentOutput.getOutputFields();
                        for (org.dmg.pmml.OutputField pmmlSegmentOutputField : pmmlSegmentOutputFields) {
                            FieldValue value;
                            String name = pmmlSegmentOutputField.requireName();
                            context.putOutputField(name, pmmlSegmentOutputField);
                            try {
                                value = segmentContext.lookup(name);
                            }
                            catch (MissingFieldValueException mfve) {
                                throw mfve.ensureContext((PMMLObject)segment);
                            }
                            context.declare(name, value);
                        }
                        break;
                    }
                }
            }
            boolean clearValues = !segmentModelEvaluator.isPure();
            segmentContext.reset(clearValues);
            switch (multipleModelMethod) {
                case MODEL_CHAIN: {
                    lastModel = model;
                    break;
                }
            }
            segmentResults.add(segmentResult);
        }
        switch (multipleModelMethod) {
            case MODEL_CHAIN: {
                if (lastModel == null) break;
                MiningModelEvaluator.checkMiningFunction(lastModel, miningFunction);
                break;
            }
        }
        return segmentResults;
    }

    private List<Segment> getActiveHead(List<Segment> segments) {
        int max = segments.size();
        for (int i = 0; i < max; ++i) {
            Segment segment = segments.get(i);
            Predicate predicate = segment.requirePredicate();
            if (!(predicate instanceof True)) continue;
            return segments.subList(0, i + 1);
        }
        return segments;
    }

    private List<Segment> getActiveTail(List<Segment> segments) {
        return Lists.reverse(this.getActiveHead(Lists.reverse(segments)));
    }

    private List<OutputField> createNestedOutputFields() {
        MiningModel miningModel = (MiningModel)this.getModel();
        Segmentation segmentation = miningModel.requireSegmentation();
        List segments = segmentation.requireSegments();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.requireMultipleModelMethod();
        switch (multipleModelMethod) {
            case SELECT_FIRST: {
                return this.createNestedOutputFields(this.getActiveHead(segments));
            }
            case SELECT_ALL: {
                break;
            }
            case MODEL_CHAIN: {
                return this.createNestedOutputFields(this.getActiveTail(segments));
            }
            case MULTI_MODEL_CHAIN: {
                return this.createNestedOutputFields(segments);
            }
        }
        return Collections.emptyList();
    }

    private List<OutputField> createNestedOutputFields(List<Segment> segments) {
        ArrayList<OutputField> result = new ArrayList<OutputField>();
        BiMap<String, Segment> entityRegistry = this.getEntityRegistry();
        int max = segments.size();
        for (int i = 0; i < max; ++i) {
            Segment segment = segments.get(i);
            Model model = segment.requireModel();
            String segmentId = EntityUtil.getId(segment, entityRegistry);
            ModelEvaluator<?> segmentModelEvaluator = this.ensureSegmentModelEvaluator(segmentId, model);
            List<OutputField> outputFields = segmentModelEvaluator.getOutputFields();
            for (OutputField outputField : outputFields) {
                OutputField nestedOutputField = new OutputField(outputField.getField(), outputField.getDepth() + 1);
                result.add(nestedOutputField);
            }
        }
        return result;
    }

    private ModelEvaluator<?> ensureSegmentModelEvaluator(String segmentId, Model model) {
        ModelEvaluator<?> segmentModelEvaluator = (ModelEvaluator<?>)this.segmentModelEvaluators.get(segmentId);
        if (segmentModelEvaluator == null) {
            segmentModelEvaluator = this.createSegmentModelEvaluator(segmentId, model);
            this.segmentModelEvaluators.putIfAbsent(segmentId, segmentModelEvaluator);
        }
        return segmentModelEvaluator;
    }

    private ModelEvaluator<?> createSegmentModelEvaluator(String segmentId, Model model) {
        MiningModel miningModel = (MiningModel)this.getModel();
        MiningFunction miningFunction = miningModel.requireMiningFunction();
        Segmentation segmentation = miningModel.requireSegmentation();
        EnumSet<ResultFeature> extraResultFeatures = EnumSet.noneOf(ResultFeature.class);
        Set<ResultFeature> resultFeatures = this.getResultFeatures();
        if (!resultFeatures.isEmpty()) {
            extraResultFeatures.addAll(resultFeatures);
        }
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.requireMultipleModelMethod();
        block0 : switch (multipleModelMethod) {
            case AVERAGE: 
            case WEIGHTED_AVERAGE: 
            case MEDIAN: 
            case MAX: {
                switch (miningFunction) {
                    case CLASSIFICATION: {
                        extraResultFeatures.add(ResultFeature.PROBABILITY);
                        break block0;
                    }
                }
                break;
            }
        }
        Set<ResultFeature> segmentResultFeatures = this.getSegmentResultFeatures(segmentId);
        if (segmentResultFeatures != null && !segmentResultFeatures.isEmpty()) {
            extraResultFeatures.addAll(segmentResultFeatures);
        }
        Configuration configuration = this.ensureConfiguration();
        ModelEvaluatorFactory modelEvaluatorFactory = configuration.getModelEvaluatorFactory();
        ModelEvaluator<?> modelEvaluator = modelEvaluatorFactory.newModelEvaluator(this.getPMML(), model, extraResultFeatures);
        MiningFunction segmentMiningFunction = model.requireMiningFunction();
        if (miningFunction == MiningFunction.CLASSIFICATION && segmentMiningFunction == MiningFunction.CLASSIFICATION) {
            List<TargetField> targetFields = this.getTargetFields();
            List<TargetField> segmentTargetFields = modelEvaluator.getTargetFields();
            if (targetFields.size() == 1 && segmentTargetFields.size() == 1) {
                TargetField targetField = targetFields.get(0);
                TargetField segmentTargetField = segmentTargetFields.get(0);
                if (segmentTargetField instanceof SyntheticTargetField) {
                    SyntheticTargetField syntheticTargetField = (SyntheticTargetField)segmentTargetField;
                    modelEvaluator.setDefaultDataField(new DefaultDataField(OpType.CATEGORICAL, targetField.getDataType()));
                }
            }
        }
        modelEvaluator.configure(configuration);
        return modelEvaluator;
    }

    private Map<String, ?> selectFirst(List<SegmentResult> segmentResults) {
        return (Map)((Object)segmentResults.get(0));
    }

    private Map<String, ?> selectAll(List<SegmentResult> segmentResults) {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (SegmentResult segmentResult : segmentResults) {
            Set names = segmentResult.keySet();
            for (String name : names) {
                result.put((Object)name, segmentResult.get(name));
            }
        }
        return Multimaps.asMap((ListMultimap)result);
    }

    private Map<String, ?> modelChain(List<SegmentResult> segmentResults) {
        return (Map)((Object)segmentResults.get(segmentResults.size() - 1));
    }

    private Map<String, ?> multiModelChain(List<SegmentResult> segmentResults) {
        LinkedHashMap result = new LinkedHashMap();
        for (SegmentResult segmentResult : segmentResults) {
            result.putAll(segmentResult);
        }
        return result;
    }

    private static boolean isEmpty(List<SegmentResult> segmentResults) {
        return segmentResults == null || segmentResults.isEmpty();
    }

    private static void checkMiningFunction(Model model, MiningFunction parentMiningFunction) {
        MiningFunction miningFunction = model.requireMiningFunction();
        switch (parentMiningFunction) {
            case MIXED: {
                break;
            }
            default: {
                if (miningFunction == parentMiningFunction) break;
                throw new InvalidAttributeException(InvalidAttributeException.formatMessage((String)(XPathUtil.formatElement(model.getClass()) + "@functionName=" + miningFunction.value())), (PMMLObject)model);
            }
        }
    }
}

